/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.thefleshthathates.AI;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.mcreator.thefleshthathates.FEvents.FleshWorld;
import net.mcreator.thefleshthathates.entity.FleshMobs;
import net.mcreator.thefleshthathates.init.TheFleshThatHatesModMobEffects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec3;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.joml.Vector3f;

public class DangerAssistGoal
extends Goal {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Mob mob;
    private long lastUsed = 0L;
    private final int COOLDOWN = 1200;
    private final int SUMMON_DELAY = 60;
    private int summonCounter = 0;
    private boolean isSummoning = false;
    private final List<EntityType<?>> spawnTypes;

    public DangerAssistGoal(Mob mob, Set<EntityType<?>> spawnTypes) {
        this.mob = mob;
        this.spawnTypes = new ArrayList(spawnTypes);
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        long time = this.mob.m_9236_().m_46467_();
        boolean canStartSummoning = (double)(this.mob.m_21223_() / this.mob.m_21233_()) < 0.75 && time - this.lastUsed > 1200L;
        return canStartSummoning || this.isSummoning;
    }

    public void m_8056_() {
        this.lastUsed = this.mob.m_9236_().m_46467_();
        this.summonCounter = 60;
        this.isSummoning = true;
    }

    public void m_8037_() {
        this.spawnDefenceParticle();
        if (this.summonCounter > 0) {
            --this.summonCounter;
        } else if (this.summonCounter == 0 && this.mob.m_9236_() instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)this.mob.m_9236_();
            this.summonBackup(serverLevel);
            this.pushNearbyEntities(serverLevel);
            this.applyGOHEffectToNearbyEntities(serverLevel);
            this.extinguishFiresAndEntities(serverLevel);
            this.summonCounter = -1;
        }
    }

    private void spawnDefenceParticle() {
        if (this.mob.m_9236_() instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)this.mob.m_9236_();
            DustParticleOptions redstoneParticle = new DustParticleOptions(new Vector3f(1.0f, 0.0f, 0.0f), 1.0f);
            for (int i = 0; i < 25; ++i) {
                double d0 = this.mob.m_217043_().m_188583_() * 0.09;
                double d1 = this.mob.m_217043_().m_188583_() * 0.09;
                double d2 = this.mob.m_217043_().m_188583_() * 0.09;
                serverLevel.m_8767_((ParticleOptions)redstoneParticle, this.mob.m_20208_(0.5), this.mob.m_20187_() + 0.5, this.mob.m_20262_(0.5), 1, d0, d1, d2, 0.1);
            }
        }
    }

    private void summonBackup(ServerLevel serverLevel) {
        this.isSummoning = false;
        ArrayList availableTypes = new ArrayList(this.spawnTypes);
        Random random = new Random();
        int maxSpawns = FleshWorld.getMaxSpawnsForStage(FleshWorld.getCurrentStage());
        List nearbyLivingEntities = serverLevel.m_6443_(LivingEntity.class, this.mob.m_20191_().m_82400_(16.0), e -> !FleshMobs.ENTITY_TYPES.contains(e.m_6095_()) && e != this.mob);
        int totalArmorAndHealth = nearbyLivingEntities.stream().mapToInt(e -> e.m_21230_() + (int)e.m_21223_()).sum();
        int numToSpawn = Math.min(totalArmorAndHealth / 10, maxSpawns);
        for (int i = 0; i < numToSpawn; ++i) {
            EntityType typeToSpawn = (EntityType)availableTypes.get(random.nextInt(availableTypes.size()));
            Entity entity = typeToSpawn.m_20615_((Level)serverLevel);
            if (!(entity instanceof Mob)) continue;
            entity.m_7678_(this.mob.m_20185_(), this.mob.m_20186_(), this.mob.m_20189_(), this.mob.m_146908_(), this.mob.m_146909_());
            serverLevel.m_7967_(entity);
        }
    }

    private void pushNearbyEntities(ServerLevel serverLevel) {
        List nearbyEntities = serverLevel.m_6443_(Entity.class, this.mob.m_20191_().m_82400_(7.0), e -> e instanceof LivingEntity && !FleshMobs.ENTITY_TYPES.contains(e.m_6095_()) && e != this.mob || e instanceof Player && !((Player)e).m_7500_());
        for (Entity entity : nearbyEntities) {
            Mob otherMob;
            Vec3 direction = entity.m_20182_().m_82546_(this.mob.m_20182_()).m_82541_();
            entity.m_20334_(direction.f_82479_ * 1.5, 0.5, direction.f_82481_ * 1.5);
            if (!(entity instanceof Mob) || FleshMobs.ENTITY_TYPES.contains(entity.m_6095_()) || (otherMob = (Mob)entity).m_5448_() != this.mob) continue;
            otherMob.m_6710_(null);
        }
    }

    private void applyGOHEffectToNearbyEntities(ServerLevel serverLevel) {
        List nearbyEntities = serverLevel.m_6443_(LivingEntity.class, this.mob.m_20191_().m_82400_(24.0), e -> !FleshMobs.ENTITY_TYPES.contains(e.m_6095_()) && e != this.mob);
        MobEffect gohEffect = (MobEffect)TheFleshThatHatesModMobEffects.GOH.get();
        for (LivingEntity entity : nearbyEntities) {
            entity.m_7292_(new MobEffectInstance(gohEffect, 400, 0));
        }
    }

    private void extinguishFiresAndEntities(ServerLevel serverLevel) {
        BlockPos mobPos = this.mob.m_20183_();
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        for (int dx = -30; dx <= 30; ++dx) {
            for (int dy = -30; dy <= 30; ++dy) {
                for (int dz = -30; dz <= 30; ++dz) {
                    mutablePos.m_122178_(mobPos.m_123341_() + dx, mobPos.m_123342_() + dy, mobPos.m_123343_() + dz);
                    Block block = serverLevel.m_8055_((BlockPos)mutablePos).m_60734_();
                    if (block != Blocks.f_50083_ && block != Blocks.f_49991_) continue;
                    serverLevel.m_7731_((BlockPos)mutablePos, Blocks.f_50016_.m_49966_(), 3);
                }
            }
        }
        List burningFleshEntities = serverLevel.m_6443_(Entity.class, this.mob.m_20191_().m_82400_(30.0), e -> FleshMobs.ENTITY_TYPES.contains(e.m_6095_()) && e.m_6060_());
        for (Entity entity : burningFleshEntities) {
            entity.m_20095_();
        }
    }
}

