/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.thefleshthathates.AI;

import net.mcreator.thefleshthathates.AI.PatrolAroundIncubatorGoal;
import net.mcreator.thefleshthathates.FEvents.FleshWorld;
import net.mcreator.thefleshthathates.init.TheFleshThatHatesModParticleTypes;
import net.mcreator.thefleshthathates.potion.OneOfUsMobEffect;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DespawnIdle
extends Goal {
    private final Mob mob;
    private long lastActiveTime;
    private final long idleThreshold;
    private static final Logger LOGGER = LogManager.getLogger();

    public DespawnIdle(Mob mob, long idleThreshold) {
        this.mob = mob;
        this.lastActiveTime = mob.m_9236_().m_46467_();
        this.idleThreshold = idleThreshold;
    }

    private void spawnTransformationParticles() {
        if (this.mob.m_9236_() instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)this.mob.m_9236_();
            SimpleParticleType flesh = (SimpleParticleType)TheFleshThatHatesModParticleTypes.FLESH.get();
            for (int i = 0; i < 10; ++i) {
                double d0 = this.mob.m_217043_().m_188583_() * 0.02;
                double d1 = this.mob.m_217043_().m_188583_() * 0.02;
                double d2 = this.mob.m_217043_().m_188583_() * 0.02;
                serverLevel.m_8767_((ParticleOptions)flesh, this.mob.m_20208_(0.5), this.mob.m_20187_(), this.mob.m_20262_(0.5), 1, d0, d1, d2, 0.1);
            }
        }
    }

    public boolean m_8036_() {
        if (this.hasPatrolAroundIncubatorGoal()) {
            return false;
        }
        long currentTime = this.mob.m_9236_().m_46467_();
        boolean isIdleLongEnough = currentTime - this.lastActiveTime > this.idleThreshold;
        return isIdleLongEnough;
    }

    public void m_8056_() {
        if (this.mob instanceof LivingEntity) {
            int points = FleshWorld.calculatePointsForDespawnedFleshEntity((LivingEntity)this.mob);
            FleshWorld.addPoints(points, this.mob.m_9236_());
        }
        this.spawnTransformationParticles();
        if (this.mob.m_9236_() instanceof ServerLevel) {
            OneOfUsMobEffect.playRandomTransformationSound((ServerLevel)this.mob.m_9236_(), (Entity)this.mob);
        }
        this.mob.m_142687_(Entity.RemovalReason.DISCARDED);
    }

    private boolean hasPatrolAroundIncubatorGoal() {
        GoalSelector goalSelector = this.mob.f_21345_;
        return goalSelector.m_148105_().stream().anyMatch(goal -> goal.m_26015_() instanceof PatrolAroundIncubatorGoal);
    }
}

