/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.thefleshthathates;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import net.mcreator.thefleshthathates.FConfig.TFTHConfiguration;
import net.mcreator.thefleshthathates.block.FleshBlocks;
import net.mcreator.thefleshthathates.init.TheFleshThatHatesModBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.ForgeRegistries;

public class BlockAlgorithms {
    private static final Set<Block> UNREPLACEABLE_BLOCKS = new HashSet<Block>(FleshBlocks.ALL_BLOCKS);

    public static boolean canBeReplacedByFleshBlock(BlockState state) {
        Block block = state.m_60734_();
        if (UNREPLACEABLE_BLOCKS.contains(block)) {
            return false;
        }
        ResourceLocation blockRegistryName = ForgeRegistries.BLOCKS.getKey((Object)block);
        if (blockRegistryName != null && TFTHConfiguration.getNonInfectableBlocks().contains(blockRegistryName.toString())) {
            return false;
        }
        return block.m_7325_() <= ((Double)TFTHConfiguration.BLOCK_EXPLOSION_RESISTANCE_THRESHOLD.get()).floatValue();
    }

    public static boolean canBeReplacedByFleshBlock(BlockState state, Block fleshBlock) {
        Block block = state.m_60734_();
        if (UNREPLACEABLE_BLOCKS.contains(block)) {
            return false;
        }
        ResourceLocation blockRegistryName = ForgeRegistries.BLOCKS.getKey((Object)block);
        if (blockRegistryName != null && TFTHConfiguration.getNonInfectableBlocks().contains(blockRegistryName.toString())) {
            return false;
        }
        float resistance = block.m_7325_();
        return fleshBlock == TheFleshThatHatesModBlocks.TUMOR.get() && resistance >= ((Double)TFTHConfiguration.TUMOR_MIN_EXPLOSION_RESISTANCE.get()).floatValue() && resistance <= ((Double)TFTHConfiguration.TUMOR_MAX_EXPLOSION_RESISTANCE.get()).floatValue();
    }

    public static boolean isSandBlock(BlockState state) {
        Block block = state.m_60734_();
        ResourceLocation blockRegistryName = ForgeRegistries.BLOCKS.getKey((Object)block);
        if (blockRegistryName != null) {
            String blockName = blockRegistryName.toString();
            return TFTHConfiguration.sandInfectableBlocks().contains(blockName);
        }
        return false;
    }

    public static boolean isWoodenPlankBlock(BlockState state) {
        Block block = state.m_60734_();
        ResourceLocation blockRegistryName = ForgeRegistries.BLOCKS.getKey((Object)block);
        if (blockRegistryName != null) {
            String blockName = blockRegistryName.toString();
            return TFTHConfiguration.plankInfectableBlocks().contains(blockName);
        }
        return false;
    }

    public static boolean isBrickBlock(BlockState state) {
        Block block = state.m_60734_();
        ResourceLocation blockRegistryName = ForgeRegistries.BLOCKS.getKey((Object)block);
        if (blockRegistryName != null) {
            String blockName = blockRegistryName.toString();
            return TFTHConfiguration.brickInfectableBlocks().contains(blockName);
        }
        return false;
    }

    public static boolean isStoneOrCobblestoneBlock(BlockState state) {
        Block block = state.m_60734_();
        ResourceLocation blockRegistryName = ForgeRegistries.BLOCKS.getKey((Object)block);
        if (blockRegistryName != null) {
            String blockName = blockRegistryName.toString();
            return TFTHConfiguration.stoneInfectableBlocks().contains(blockName);
        }
        return false;
    }

    public static boolean isWoodenBlock(BlockState state) {
        Block block = state.m_60734_();
        ResourceLocation blockRegistryName = ForgeRegistries.BLOCKS.getKey((Object)block);
        if (blockRegistryName != null) {
            String blockName = blockRegistryName.toString();
            return TFTHConfiguration.logInfectableBlocks().contains(blockName);
        }
        return false;
    }

    public static boolean isLeafBlock(BlockState state) {
        Block block = state.m_60734_();
        ResourceLocation blockRegistryName = ForgeRegistries.BLOCKS.getKey((Object)block);
        if (blockRegistryName != null) {
            String blockName = blockRegistryName.toString();
            return TFTHConfiguration.leavesInfectableBlocks().contains(blockName);
        }
        return false;
    }

    public static boolean isLiquidBlock(BlockState state) {
        Block block = state.m_60734_();
        ResourceLocation blockRegistryName = ForgeRegistries.BLOCKS.getKey((Object)block);
        if (blockRegistryName != null) {
            String blockName = blockRegistryName.toString();
            return TFTHConfiguration.liquidInfectableBlocks().contains(blockName);
        }
        return false;
    }

    public static ArrayList<BlockPos> getNeighborsCube(BlockPos current, BlockPos origin, boolean includeOrigin) {
        ArrayList<BlockPos> neighbors = new ArrayList<BlockPos>();
        for (int j = -1; j <= 1; ++j) {
            for (int i = -1; i <= 1; ++i) {
                for (int k = -1; k <= 1; ++k) {
                    if (i == 0 && j == 0 && k == 0 && !includeOrigin) continue;
                    neighbors.add(current.m_7918_(i, j, k));
                }
            }
        }
        return neighbors;
    }

    public static ArrayList<BlockPos> getAdjacentNeighbors(BlockPos origin) {
        ArrayList<BlockPos> neighbors = new ArrayList<BlockPos>();
        neighbors.add(origin.m_122012_());
        neighbors.add(origin.m_122029_());
        neighbors.add(origin.m_122019_());
        neighbors.add(origin.m_122024_());
        neighbors.add(origin.m_7494_());
        neighbors.add(origin.m_7495_());
        return neighbors;
    }
}

