/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.thefleshthathates;

import java.util.EnumSet;
import net.mcreator.thefleshthathates.entity.IDelayedDamage;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;

public class CustomMeleeAttackGoal
extends Goal {
    protected final PathfinderMob attacker;
    private final boolean persistentPursuit;
    private Path navigationPath;
    private double targetX;
    private double targetY;
    private double targetZ;
    private int recalibrationTicks;
    public int attackCooldownTicks;
    private final int attackDelay = 15;
    private long lastUsageTime;
    private static final long RECHECK_INTERVAL = 20L;
    private int pathfindingPenalty = 0;
    private boolean enablePenalty = false;
    private final double aggressiveSpeed;
    private final double normalSpeed;
    private final double attackReach;

    public CustomMeleeAttackGoal(PathfinderMob mob, double normalSpeed, double aggressiveSpeed, boolean persist, double attackReach) {
        this.attacker = mob;
        this.normalSpeed = normalSpeed;
        this.persistentPursuit = persist;
        this.aggressiveSpeed = aggressiveSpeed;
        this.attackReach = attackReach;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        long currentTime = this.attacker.m_9236_().m_46467_();
        if (currentTime - this.lastUsageTime < 20L) {
            return false;
        }
        this.lastUsageTime = currentTime;
        LivingEntity target = this.attacker.m_5448_();
        if (target == null || !target.m_6084_()) {
            return false;
        }
        if (this.enablePenalty) {
            if (--this.recalibrationTicks <= 0) {
                this.navigationPath = this.attacker.m_21573_().m_6570_((Entity)target, 0);
                this.recalibrationTicks = 4 + this.attacker.m_217043_().m_188503_(7);
                return this.navigationPath != null;
            }
            return true;
        }
        this.navigationPath = this.attacker.m_21573_().m_6570_((Entity)target, 0);
        return this.navigationPath != null || this.getReachDistance(target) >= this.attacker.m_20275_(target.m_20185_(), target.m_20186_(), target.m_20189_());
    }

    protected double getAttackReachSqr(LivingEntity entity) {
        return this.attackReach + (double)(entity.m_20205_() * entity.m_20205_());
    }

    public boolean m_8045_() {
        LivingEntity target = this.attacker.m_5448_();
        return target != null && target.m_6084_() && (this.persistentPursuit || !this.attacker.m_21573_().m_26571_()) && this.attacker.m_21444_(target.m_20183_()) && (!(target instanceof Player) || !target.m_5833_() && !((Player)target).m_7500_());
    }

    public void m_8056_() {
        double currentSpeed = this.attacker.m_5912_() ? this.aggressiveSpeed : this.normalSpeed;
        this.attacker.m_21573_().m_26536_(this.navigationPath, currentSpeed);
        this.attacker.m_21561_(true);
        this.recalibrationTicks = 0;
        this.attackCooldownTicks = 0;
    }

    public void m_8041_() {
        LivingEntity target = this.attacker.m_5448_();
        if (!EntitySelector.f_20406_.test(target)) {
            this.attacker.m_6710_(null);
        }
        this.attacker.m_21561_(false);
        this.attacker.m_21573_().m_26573_();
    }

    public void m_8037_() {
        LivingEntity target = this.attacker.m_5448_();
        if (target != null) {
            this.attacker.m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
            double distance = this.attacker.m_20275_(target.m_20185_(), target.m_20186_(), target.m_20189_());
            this.recalibrationTicks = Math.max(this.recalibrationTicks - 1, 0);
            if ((this.persistentPursuit || this.attacker.m_21574_().m_148306_((Entity)target)) && this.recalibrationTicks <= 0 && (this.targetX == 0.0 && this.targetY == 0.0 && this.targetZ == 0.0 || target.m_20275_(this.targetX, this.targetY, this.targetZ) >= 1.0 || this.attacker.m_217043_().m_188501_() < 0.05f)) {
                double currentSpeed;
                this.targetX = target.m_20185_();
                this.targetY = target.m_20186_();
                this.targetZ = target.m_20189_();
                this.recalibrationTicks = 4 + this.attacker.m_217043_().m_188503_(7);
                if (this.enablePenalty) {
                    Node finalNode;
                    this.recalibrationTicks += this.pathfindingPenalty;
                    this.pathfindingPenalty = this.attacker.m_21573_().m_26570_() != null ? ((finalNode = this.attacker.m_21573_().m_26570_().m_77395_()) != null && target.m_20275_((double)finalNode.f_77271_, (double)finalNode.f_77272_, (double)finalNode.f_77273_) < 1.0 ? 0 : (this.pathfindingPenalty += 10)) : (this.pathfindingPenalty += 10);
                }
                if (distance > 1024.0) {
                    this.recalibrationTicks += 10;
                } else if (distance > 256.0) {
                    this.recalibrationTicks += 5;
                }
                double d = currentSpeed = this.attacker.m_5912_() ? this.aggressiveSpeed : this.normalSpeed;
                if (!this.attacker.m_21573_().m_5624_((Entity)target, currentSpeed)) {
                    this.recalibrationTicks += 15;
                }
                this.recalibrationTicks = this.m_183277_(this.recalibrationTicks);
            }
            this.attackCooldownTicks = Math.max(this.attackCooldownTicks - 1, 0);
            this.performAttackCheck(target, distance);
        }
    }

    protected void performAttackCheck(LivingEntity target, double distance) {
        double reach = this.getReachDistance(target);
        if (distance <= reach && this.attackCooldownTicks <= 0) {
            this.resetCooldown();
            this.attacker.m_6674_(InteractionHand.MAIN_HAND);
            if (this.attacker instanceof IDelayedDamage) {
                ((IDelayedDamage)this.attacker).triggerDelayedAttack(target);
            }
        }
    }

    protected void resetCooldown() {
        this.attackCooldownTicks = this.m_183277_(15);
    }

    protected double getReachDistance(LivingEntity target) {
        return Math.sqrt(this.getAttackReachSqr(target));
    }
}

