/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.thefleshthathates;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.UUID;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkPos;

public class EntityChunkLoaderHelper {
    private ArrayList<EntityChunkLoadRequest> entityChunkLoadRequests = new ArrayList();

    public void createChunkLoadRequestForEntityIfAbsent(Entity entity, int priority, long ticksUntilExpiration) {
        ChunkPos entityChunkPos = new ChunkPos(entity.m_20183_());
        ArrayList<ChunkPos> chunkPositions = new ArrayList<ChunkPos>();
        chunkPositions.add(entityChunkPos);
        EntityChunkLoadRequest request = new EntityChunkLoadRequest(entity.m_20148_(), chunkPositions, priority, ticksUntilExpiration);
        this.entityChunkLoadRequests.add(request);
        this.loadChunkForEntity(entity, (ServerLevel)entity.m_9236_());
    }

    public void unloadAndRemoveChunksWithOwner(UUID ownerId, ServerLevel level) {
        Iterator<EntityChunkLoadRequest> iterator = this.entityChunkLoadRequests.iterator();
        while (iterator.hasNext()) {
            EntityChunkLoadRequest request = iterator.next();
            if (!request.isOwner(ownerId)) continue;
            for (ChunkPos chunkPos : request.getChunkPositions()) {
                this.unloadChunkForEntity(chunkPos, level);
            }
            iterator.remove();
        }
    }

    public void loadChunkForEntity(Entity entity, ServerLevel level) {
        ChunkPos chunkPos = new ChunkPos(entity.m_20183_());
        level.m_8602_(chunkPos.f_45578_, chunkPos.f_45579_, true);
    }

    public void unloadChunkForEntity(ChunkPos chunkPos, ServerLevel level) {
        level.m_8602_(chunkPos.f_45578_, chunkPos.f_45579_, false);
    }

    private static class EntityChunkLoadRequest {
        private final UUID owner;
        private final ArrayList<ChunkPos> chunkPositions;
        private final int priority;
        private long ticksUntilExpiration;

        public EntityChunkLoadRequest(UUID owner, ArrayList<ChunkPos> chunkPositions, int priority, long ticksUntilExpiration) {
            this.owner = owner;
            this.chunkPositions = chunkPositions;
            this.priority = priority;
            this.ticksUntilExpiration = ticksUntilExpiration;
        }

        public boolean isOwner(UUID ownerId) {
            return this.owner.equals(ownerId);
        }

        public ArrayList<ChunkPos> getChunkPositions() {
            return this.chunkPositions;
        }

        public void decrementTicksUntilExpiration(int ticks) {
            this.ticksUntilExpiration -= (long)ticks;
            if (this.ticksUntilExpiration < 0L) {
                this.ticksUntilExpiration = 0L;
            }
        }

        public boolean isExpired() {
            return this.ticksUntilExpiration <= 0L;
        }
    }
}

