/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.thefleshthathates;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;
import net.minecraft.world.phys.AABB;

public class EntitySavedData
extends SavedData {
    private static final String DATA_NAME = "TheFleshThatHates_Entities";
    private final List<UUID> entityUUIDs = new ArrayList<UUID>();
    private final Set<UUID> infectedEntityUUIDs = new HashSet<UUID>();
    private final List<BlockPos> savedBlockPositions = new ArrayList<BlockPos>();

    public static EntitySavedData load(CompoundTag nbt) {
        EntitySavedData data = new EntitySavedData();
        ListTag entitiesList = nbt.m_128437_("Entities", 10);
        for (int i = 0; i < entitiesList.size(); ++i) {
            CompoundTag uuidTag = entitiesList.m_128728_(i);
            data.entityUUIDs.add(new UUID(uuidTag.m_128454_("Most"), uuidTag.m_128454_("Least")));
        }
        ListTag infectedEntitiesList = nbt.m_128437_("InfectedEntities", 10);
        for (int i = 0; i < infectedEntitiesList.size(); ++i) {
            CompoundTag uuidTag = infectedEntitiesList.m_128728_(i);
            data.infectedEntityUUIDs.add(new UUID(uuidTag.m_128454_("Most"), uuidTag.m_128454_("Least")));
        }
        return data;
    }

    public CompoundTag m_7176_(CompoundTag compound) {
        ListTag entitiesList = new ListTag();
        for (UUID uuid : this.entityUUIDs) {
            CompoundTag uuidTag = new CompoundTag();
            uuidTag.m_128356_("Most", uuid.getMostSignificantBits());
            uuidTag.m_128356_("Least", uuid.getLeastSignificantBits());
            entitiesList.add((Object)uuidTag);
        }
        compound.m_128365_("Entities", (Tag)entitiesList);
        ListTag infectedEntitiesList = new ListTag();
        for (UUID uuid : this.infectedEntityUUIDs) {
            CompoundTag uuidTag = new CompoundTag();
            uuidTag.m_128356_("Most", uuid.getMostSignificantBits());
            uuidTag.m_128356_("Least", uuid.getLeastSignificantBits());
            infectedEntitiesList.add((Object)uuidTag);
        }
        compound.m_128365_("InfectedEntities", (Tag)infectedEntitiesList);
        return compound;
    }

    public void setInfected(UUID uuid, boolean infected) {
        if (infected) {
            this.infectEntity(uuid);
        } else {
            this.cureEntity(uuid);
        }
    }

    public void addEntity(UUID uuid) {
        if (!this.entityUUIDs.contains(uuid)) {
            this.entityUUIDs.add(uuid);
            this.m_77762_();
        }
    }

    public boolean removeEntity(UUID uuid) {
        boolean result = this.entityUUIDs.remove(uuid);
        if (result) {
            this.m_77762_();
        }
        return result;
    }

    public List<UUID> getEntityUUIDs() {
        return new ArrayList<UUID>(this.entityUUIDs);
    }

    public void infectEntity(UUID uuid) {
        if (!this.infectedEntityUUIDs.contains(uuid)) {
            this.infectedEntityUUIDs.add(uuid);
            this.m_77762_();
        }
    }

    public boolean isEntityInfected(UUID uuid) {
        return this.infectedEntityUUIDs.contains(uuid);
    }

    public void cureEntity(UUID uuid) {
        if (this.infectedEntityUUIDs.remove(uuid)) {
            this.m_77762_();
        }
    }

    public void addBlockPosition(BlockPos pos) {
        if (!this.savedBlockPositions.contains(pos)) {
            this.savedBlockPositions.add(pos);
            this.m_77762_();
        }
    }

    public boolean isBlockPositionSaved(BlockPos pos) {
        return this.savedBlockPositions.contains(pos);
    }

    public List<BlockPos> getSavedBlockPositions() {
        return new ArrayList<BlockPos>(this.savedBlockPositions);
    }

    public boolean isEntityNearby(ServerLevel world, BlockPos pos, double radius, Class<? extends Entity> entityClass) {
        return world.m_45976_(entityClass, new AABB(pos).m_82400_(radius)).stream().anyMatch(e -> this.entityUUIDs.contains(e.m_20148_()));
    }

    public static EntitySavedData get(DimensionDataStorage storage) {
        return (EntitySavedData)storage.m_164861_(EntitySavedData::load, EntitySavedData::new, DATA_NAME);
    }

    public boolean isPositionNearby(ServerLevel world, BlockPos pos, double radius) {
        return this.savedBlockPositions.stream().anyMatch(savedPos -> savedPos.m_123314_((Vec3i)pos, radius));
    }

    public boolean removeBlockPosition(BlockPos pos) {
        boolean result = this.savedBlockPositions.remove(pos);
        if (result) {
            this.m_77762_();
        }
        return result;
    }
}

