/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.thefleshthathates.FEvents;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import net.mcreator.thefleshthathates.FEvents.SoundControl;
import net.mcreator.thefleshthathates.block.FleshBlocks;
import net.mcreator.thefleshthathates.init.TheFleshThatHatesModSounds;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
public class BiomeMusic {
    private static final int REQUIRED_BLOCK_COUNT = 20;
    private static final int CHECK_RADIUS = 30;
    private static boolean isCustomMusicPlaying = false;
    private static final float MUSIC_VOLUME = 0.5f;
    private static final int CHECK_INTERVAL = 100;
    private static final Map<UUID, Boolean> musicPlayingMap = new HashMap<UUID, Boolean>();
    private static final Map<UUID, Integer> playerTickCounter = new HashMap<UUID, Integer>();
    public static List<SoundEvent> modSounds = null;
    private static final Random random = new Random();

    private static List<SoundEvent> getModSounds() {
        if (modSounds == null) {
            modSounds = Arrays.asList((SoundEvent)TheFleshThatHatesModSounds.GALLBLADDER.get(), (SoundEvent)TheFleshThatHatesModSounds.FOSSA.get(), (SoundEvent)TheFleshThatHatesModSounds.EPIGLOTTIS.get(), (SoundEvent)TheFleshThatHatesModSounds.THEYFOUND.get());
        }
        return modSounds;
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        Player player = event.player;
        UUID playerId = player.m_20148_();
        if (!player.m_9236_().f_46443_) {
            return;
        }
        playerTickCounter.putIfAbsent(playerId, 0);
        int ticks = playerTickCounter.get(playerId);
        if (ticks >= 100) {
            playerTickCounter.put(playerId, 0);
            BiomeMusic.performMusicCheck(player, playerId);
        } else {
            playerTickCounter.put(playerId, ticks + 1);
        }
    }

    private static void performMusicCheck(Player player, UUID playerId) {
        int count = BiomeMusic.countSpecificBlocksAroundPlayer(player, 30);
        double closestDistance = BiomeMusic.getClosestBlockDistance(player);
        if (count >= 20 && closestDistance <= 5.0) {
            if (!isCustomMusicPlaying) {
                if (SoundControl.isVanillaMusicPlaying()) {
                    SoundControl.pauseVanillaMusic();
                }
                isCustomMusicPlaying = true;
                List<SoundEvent> sounds = BiomeMusic.getModSounds();
                SoundEvent soundToPlay = sounds.get(random.nextInt(sounds.size()));
                player.m_9236_().m_5594_(player, player.m_20183_(), soundToPlay, SoundSource.RECORDS, 0.5f, 1.0f);
                musicPlayingMap.put(playerId, true);
            }
        } else if (isCustomMusicPlaying) {
            BiomeMusic.stopMusicForPlayer(player, playerId);
        }
    }

    private static double getClosestBlockDistance(Player player) {
        Level level = player.m_9236_();
        BlockPos playerPos = player.m_20183_();
        double closestDistance = Double.MAX_VALUE;
        for (BlockPos pos : BlockPos.m_121940_((BlockPos)playerPos.m_7918_(-30, -30, -30), (BlockPos)playerPos.m_7918_(30, 30, 30))) {
            double distance;
            Block block = level.m_8055_(pos).m_60734_();
            if (!FleshBlocks.isModBlock(block) || !((distance = pos.m_123331_((Vec3i)playerPos)) < closestDistance)) continue;
            closestDistance = distance;
        }
        return Math.sqrt(closestDistance);
    }

    private static int countSpecificBlocksAroundPlayer(Player player, int radius) {
        Level level = player.m_9236_();
        BlockPos playerPos = player.m_20183_();
        int blockCount = 0;
        for (BlockPos pos : BlockPos.m_121940_((BlockPos)playerPos.m_7918_(-radius, -radius, -radius), (BlockPos)playerPos.m_7918_(radius, radius, radius))) {
            Block block = level.m_8055_(pos).m_60734_();
            if (!FleshBlocks.isModBlock(block)) continue;
            ++blockCount;
        }
        return blockCount;
    }

    private static boolean isMusicPlaying(UUID playerId) {
        return musicPlayingMap.getOrDefault(playerId, false);
    }

    private static void stopMusicForPlayer(Player player, UUID playerId) {
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            if (player.m_20148_().equals(Minecraft.m_91087_().f_91074_.m_20148_()) && BiomeMusic.isMusicPlaying(playerId)) {
                SoundControl.stopBiomeMusicSound();
                BiomeMusic.stopMusic(playerId);
                isCustomMusicPlaying = false;
                SoundControl.resumeVanillaMusic();
            }
        });
    }

    private static void stopMusic(UUID playerId) {
        musicPlayingMap.put(playerId, false);
    }

    public static boolean isCustomMusicPlaying() {
        return isCustomMusicPlaying;
    }
}

