/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.thefleshthathates.FEvents;

import java.util.ArrayList;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.mcreator.thefleshthathates.AI.DespawnIdle;
import net.mcreator.thefleshthathates.FConfig.TFTHConfiguration;
import net.mcreator.thefleshthathates.helpers.DespawnHelper;
import net.mcreator.thefleshthathates.helpers.MobHelper;
import net.mcreator.thefleshthathates.helpers.TimeHelper;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.level.ChunkEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.server.ServerLifecycleHooks;

@Mod.EventBusSubscriber
public class DeleteFleshMob {
    private static long lastCheckTime = 0L;
    private static final Set<ChunkPos> loadedChunks = ConcurrentHashMap.newKeySet();

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END && ++lastCheckTime >= (long)TimeHelper.convertSecondsToTicks((Integer)TFTHConfiguration.DESPAWN_TIMER_SECONDS.get())) {
            DespawnIdle despawn;
            Mob mobToRemove;
            int j;
            ArrayList<Mob> weightedList;
            lastCheckTime = 0L;
            MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
            Random random = new Random();
            ArrayList<Mob> germMobs = new ArrayList<Mob>();
            ArrayList<Mob> awarenessMobs = new ArrayList<Mob>();
            for (Object serverLevel : server.m_129785_()) {
                for (Entity entity : serverLevel.m_8583_()) {
                    if (!(entity instanceof Mob) || !loadedChunks.contains(new ChunkPos(entity.m_20183_())) || entity instanceof Player) continue;
                    if (MobHelper.isGermMob(entity)) {
                        germMobs.add((Mob)entity);
                        continue;
                    }
                    if (!MobHelper.isAwarenessMob(entity)) continue;
                    awarenessMobs.add((Mob)entity);
                }
            }
            while (germMobs.size() > (Integer)TFTHConfiguration.MAX_EMBRYO_MOBS.get()) {
                weightedList = new ArrayList<Mob>();
                for (Mob mob : germMobs) {
                    int priority = DespawnHelper.getPriorityWithAggressionCheck(mob);
                    for (j = 0; j < 4 - priority; ++j) {
                        weightedList.add(mob);
                    }
                }
                if (weightedList.isEmpty()) continue;
                mobToRemove = (Mob)weightedList.get(random.nextInt(weightedList.size()));
                germMobs.remove(mobToRemove);
                despawn = new DespawnIdle(mobToRemove, 0L);
                despawn.m_8056_();
            }
            while (awarenessMobs.size() > (Integer)TFTHConfiguration.MAX_ENLIGHTED_MOBS.get()) {
                weightedList = new ArrayList();
                for (Mob mob : awarenessMobs) {
                    int priority = DespawnHelper.getPriorityAwarenessWithAggressionCheck(mob);
                    for (j = 0; j < 4 - priority; ++j) {
                        weightedList.add(mob);
                    }
                }
                if (weightedList.isEmpty()) continue;
                mobToRemove = (Mob)weightedList.get(random.nextInt(weightedList.size()));
                awarenessMobs.remove(mobToRemove);
                despawn = new DespawnIdle(mobToRemove, 0L);
                despawn.m_8056_();
            }
        }
    }

    @SubscribeEvent
    public static void onChunkLoad(ChunkEvent.Load event) {
        if (!event.getLevel().m_5776_()) {
            loadedChunks.add(event.getChunk().m_7697_());
        }
    }

    @SubscribeEvent
    public static void onChunkUnload(ChunkEvent.Unload event) {
        if (!event.getLevel().m_5776_()) {
            loadedChunks.remove(event.getChunk().m_7697_());
        }
    }
}

