/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.thefleshthathates.FEvents;

import java.util.HashMap;
import java.util.Map;
import net.mcreator.thefleshthathates.FConfig.TFTHConfiguration;
import net.mcreator.thefleshthathates.FleshWorldData;
import net.mcreator.thefleshthathates.StageChangeEvent;
import net.mcreator.thefleshthathates.entity.FleshMobs;
import net.mcreator.thefleshthathates.init.TheFleshThatHatesModMobEffects;
import net.mcreator.thefleshthathates.init.TheFleshThatHatesModSounds;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="the_flesh_that_hates")
public class FleshWorld {
    private static int points = 0;
    private static FleshStage currentStage = null;

    public static int getPoints() {
        return points;
    }

    public static void setPoints(int newPoints, Level level) {
        points = newPoints;
        MinecraftServer server = level.m_7654_();
        FleshWorldData data = FleshWorldData.get(server);
        data.setCurrentStage(currentStage);
        data.m_77762_();
    }

    public static void addPoints(int pointsToAdd, Level level) {
        MinecraftServer server;
        points += pointsToAdd;
        if (!level.m_5776_() && (server = level.m_7654_()) != null) {
            FleshWorldData data = FleshWorldData.get(server);
            data.setPoints(points);
            data.setCurrentStage(currentStage);
            data.m_77762_();
            FleshWorld.checkForPhaseChange(level);
        }
    }

    private static void checkForPhaseChange(Level level) {
        FleshWorldData data;
        MinecraftServer server = level.m_7654_();
        if (server == null) {
            return;
        }
        if (points < 300) {
            if (currentStage != FleshStage.FETAL_STAGE) {
                currentStage = FleshStage.FETAL_STAGE;
                FleshWorld.sendServerMessage(level, "EMBRYO PHASE");
            }
        } else if (points < 3000) {
            if (currentStage != FleshStage.GERM_STAGE) {
                currentStage = FleshStage.GERM_STAGE;
                FleshWorld.sendServerMessage(level, "BIOGENESIS PHASE");
                FleshWorld.playSoundForStageChange(level, (SoundEvent)TheFleshThatHatesModSounds.PHASE_EMBRYO.get());
            }
        } else if (points < 15000) {
            if (currentStage != FleshStage.AWARENESS_STAGE) {
                currentStage = FleshStage.AWARENESS_STAGE;
                FleshWorld.sendServerMessage(level, "ENLIGHTENMENT PHASE");
                FleshWorld.playSoundForStageChange(level, (SoundEvent)TheFleshThatHatesModSounds.PHASE_BIOGENESIS.get());
            }
        } else if (points < 50000) {
            if (currentStage != FleshStage.GROWTH_STAGE) {
                currentStage = FleshStage.GROWTH_STAGE;
                FleshWorld.sendServerMessage(level, "BIOTRANSFORMATION PHASE");
                FleshWorld.playSoundForStageChange(level, (SoundEvent)TheFleshThatHatesModSounds.PHASE_ENLIGHT.get());
            }
        } else if (points < 100000) {
            if (currentStage != FleshStage.SYNTHESIS_STAGE) {
                currentStage = FleshStage.SYNTHESIS_STAGE;
                FleshWorld.sendServerMessage(level, "SYNTHESIS PHASE");
                FleshWorld.playSoundForStageChange(level, (SoundEvent)TheFleshThatHatesModSounds.PHASE_SYNTHESIS.get());
            }
        } else if (currentStage != FleshStage.EPITASIS_STAGE) {
            currentStage = FleshStage.EPITASIS_STAGE;
            FleshWorld.sendServerMessage(level, "EPIKULMINATION PHASE");
            FleshWorld.playSoundForStageChange(level, (SoundEvent)TheFleshThatHatesModSounds.PHASE_BIOTRANSFORM.get());
        }
        if (server != null && (data = FleshWorldData.get(server)) != null) {
            data.setCurrentStage(currentStage);
            data.m_77762_();
        }
    }

    public static int getMaxSpawnsForStage(FleshStage stage) {
        switch (stage) {
            case FETAL_STAGE: {
                return 3;
            }
            case GERM_STAGE: {
                return 5;
            }
            case AWARENESS_STAGE: {
                return 6;
            }
            case GROWTH_STAGE: {
                return 7;
            }
            case SYNTHESIS_STAGE: {
                return 8;
            }
            case EPITASIS_STAGE: {
                return 9;
            }
        }
        return 3;
    }

    public static double getFleshJusticeSpawnChance() {
        switch (currentStage) {
            case FETAL_STAGE: {
                return (Double)TFTHConfiguration.FETAL_STAGE_JUSTICE_SPAWN_CHANCE.get();
            }
            case GERM_STAGE: {
                return (Double)TFTHConfiguration.GERM_STAGE_JUSTICE_SPAWN_CHANCE.get();
            }
            case AWARENESS_STAGE: {
                return (Double)TFTHConfiguration.AWARENESS_STAGE_JUSTICE_SPAWN_CHANCE.get();
            }
            case GROWTH_STAGE: {
                return (Double)TFTHConfiguration.GROWTH_STAGE_JUSTICE_SPAWN_CHANCE.get();
            }
            case SYNTHESIS_STAGE: {
                return (Double)TFTHConfiguration.SYNTHESIS_STAGE_JUSTICE_SPAWN_CHANCE.get();
            }
            case EPITASIS_STAGE: {
                return (Double)TFTHConfiguration.EPITASIS_STAGE_JUSTICE_SPAWN_CHANCE.get();
            }
        }
        return (Double)TFTHConfiguration.FETAL_STAGE_JUSTICE_SPAWN_CHANCE.get();
    }

    public static float getFleshRageSpawnChance() {
        switch (currentStage) {
            case FETAL_STAGE: {
                return 0.05f;
            }
            case GERM_STAGE: {
                return 0.15f;
            }
            case AWARENESS_STAGE: {
                return 0.3f;
            }
            case GROWTH_STAGE: {
                return 0.4f;
            }
            case SYNTHESIS_STAGE: {
                return 0.5f;
            }
            case EPITASIS_STAGE: {
                return 0.75f;
            }
        }
        return 0.05f;
    }

    private static void playSoundForStageChange(Level level, SoundEvent soundEvent) {
        if (!level.f_46443_ && level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_7654_().m_6846_().m_11314_().forEach(player -> player.m_6330_(soundEvent, SoundSource.MASTER, 1.0f, 1.0f));
        }
    }

    private static void sendServerMessage(Level level, String messageText) {
        Component message = Component.m_130674_((String)messageText);
        for (ServerPlayer player : level.m_7654_().m_6846_().m_11314_()) {
            player.m_5661_(message, false);
        }
    }

    private static int calculatePointsForEntity(LivingEntity entity) {
        Map<String, Integer> config = FleshWorld.parsePointsConfig((String)TFTHConfiguration.ENTITY_POINTS_CALCULATION.get());
        int healthDivisor = config.getOrDefault("HealthDivisor", 4);
        int armorDivisor = config.getOrDefault("ArmorDivisor", 4);
        int healthPoints = (int)(entity.m_21233_() / (float)healthDivisor);
        int armorPoints = entity.m_21230_() / armorDivisor;
        return healthPoints + armorPoints;
    }

    private static int calculatePointsForFleshEntity(LivingEntity entity) {
        Map<String, Integer> config = FleshWorld.parsePointsConfig((String)TFTHConfiguration.FLESH_ENTITY_POINTS_CALCULATION.get());
        int maxPoints = config.getOrDefault("MaxPoints", 60);
        int healthDivisor = config.getOrDefault("HealthDivisor", 6);
        int armorDivisor = config.getOrDefault("ArmorDivisor", 6);
        int totalPoints = (int)(entity.m_21233_() / (float)healthDivisor) + entity.m_21230_() / armorDivisor;
        return Math.min(totalPoints, maxPoints);
    }

    public static int calculatePointsForDespawnedFleshEntity(LivingEntity entity) {
        Map<String, Integer> config = FleshWorld.parsePointsConfig((String)TFTHConfiguration.DESPAWNED_FLESH_ENTITY_POINTS_CALCULATION.get());
        int maxPoints = config.getOrDefault("MaxPoints", 120);
        int healthDivisor = config.getOrDefault("HealthDivisor", 3);
        int armorDivisor = config.getOrDefault("ArmorDivisor", 3);
        int totalPoints = (int)(entity.m_21233_() / (float)healthDivisor) + entity.m_21230_() / armorDivisor;
        return Math.min(totalPoints, maxPoints);
    }

    private static int calculatePointsForEffectKill(LivingEntity entity) {
        Map<String, Integer> config = FleshWorld.parsePointsConfig((String)TFTHConfiguration.EFFECT_KILL_POINTS_CALCULATION.get());
        int healthDivisor = config.getOrDefault("HealthDivisor", 4);
        int armorDivisor = config.getOrDefault("ArmorDivisor", 4);
        int healthPoints = (int)(entity.m_21233_() / (float)healthDivisor);
        int armorPoints = entity.m_21230_() / armorDivisor;
        return healthPoints + armorPoints;
    }

    private static Map<String, Integer> parsePointsConfig(String configString) {
        String[] params;
        HashMap<String, Integer> configMap = new HashMap<String, Integer>();
        for (String param : params = configString.split(";")) {
            String[] keyValue = param.split("=");
            if (keyValue.length != 2) continue;
            configMap.put(keyValue[0], Integer.parseInt(keyValue[1]));
        }
        return configMap;
    }

    public static FleshStage getCurrentStage() {
        if (currentStage == null) {
            return FleshStage.FETAL_STAGE;
        }
        return currentStage;
    }

    public static void setCurrentStage(FleshStage stage, Level level) {
        if (currentStage == null || !currentStage.equals((Object)stage)) {
            currentStage = stage;
            MinecraftForge.EVENT_BUS.post((Event)new StageChangeEvent(currentStage, (ServerLevel)level));
            MinecraftServer server = level.m_7654_();
            FleshWorldData data = FleshWorldData.get(server);
            data.setCurrentStage(currentStage);
            data.m_77762_();
        }
    }

    public static void addPoints(int pointsToAdd) {
        points += pointsToAdd;
    }

    public static void subtractPoints(int pointsToSubtract, Level level) {
        if ((points -= pointsToSubtract) < 0) {
            points = 0;
        }
        FleshWorld.checkForPhaseChange(level);
    }

    private static void subtractPointsBasedOnEntity(LivingEntity entity, Level level) {
        int pointsToSubtract = FleshWorld.calculatePointsForFleshEntity(entity);
        FleshWorld.subtractPoints(pointsToSubtract, level);
    }

    public static void subtractPointsForDestroyedBlock(Level level) {
        FleshWorld.subtractPoints(TFTHConfiguration.sbtrPointsForDstrBlock(), level);
    }

    public static void resetStageAndPoints() {
        points = 0;
        currentStage = FleshStage.FETAL_STAGE;
    }

    @SubscribeEvent
    public static void onEntityKilled(LivingDeathEvent event) {
        LivingEntity entity = event.getEntity();
        Level level = entity.m_9236_();
        if (entity.m_21232_() != null && FleshMobs.isFleshEntity((Entity)entity.m_21232_())) {
            int pointsForEntity = FleshWorld.calculatePointsForEntity(entity);
            FleshWorld.addPoints(pointsForEntity, level);
        }
        if (entity.m_6060_() && FleshMobs.isFleshEntity((Entity)entity)) {
            FleshWorld.subtractPointsBasedOnEntity(entity, level);
        }
        if (entity.m_21023_((MobEffect)TheFleshThatHatesModMobEffects.ONE_OF_US.get()) || entity.m_21023_((MobEffect)TheFleshThatHatesModMobEffects.DECOMPOSITION.get())) {
            int pointsForEffectKill = FleshWorld.calculatePointsForEffectKill(entity);
            FleshWorld.addPoints(pointsForEffectKill, level);
        }
    }

    public static enum FleshStage {
        FETAL_STAGE,
        GERM_STAGE,
        AWARENESS_STAGE,
        GROWTH_STAGE,
        SYNTHESIS_STAGE,
        EPITASIS_STAGE;

    }
}

