/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.thefleshthathates.FEvents;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.mcreator.thefleshthathates.FConfig.TFTHConfiguration;
import net.mcreator.thefleshthathates.FEvents.FleshWorld;
import net.mcreator.thefleshthathates.block.FleshBoilBlock;
import net.mcreator.thefleshthathates.block.FleshBoilPhaseTwoBlock;
import net.mcreator.thefleshthathates.block.PusBlock;
import net.mcreator.thefleshthathates.entity.FleshHumanHeadEntity;
import net.mcreator.thefleshthathates.entity.FleshJusticeEntity;
import net.mcreator.thefleshthathates.entity.FleshMobs;
import net.mcreator.thefleshthathates.entity.PlaquecreatureoneEntity;
import net.mcreator.thefleshthathates.entity.PlaqueincubatoroneEntity;
import net.mcreator.thefleshthathates.entity.PlaqueincubatorstartEntity;
import net.mcreator.thefleshthathates.helpers.MobHelper;
import net.mcreator.thefleshthathates.init.TheFleshThatHatesModBlocks;
import net.mcreator.thefleshthathates.init.TheFleshThatHatesModEntities;
import net.mcreator.thefleshthathates.init.TheFleshThatHatesModItems;
import net.mcreator.thefleshthathates.init.TheFleshThatHatesModParticleTypes;
import net.mcreator.thefleshthathates.init.TheFleshThatHatesModSounds;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingKnockBackEvent;
import net.minecraftforge.event.entity.player.FillBucketEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class HandleEvents {
    private static final ThreadLocal<Boolean> isProcessingEvent = ThreadLocal.withInitial(() -> false);

    @SubscribeEvent
    public static void onLivingSpawned(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof PathfinderMob) {
            PathfinderMob mob = (PathfinderMob)entity;
            List<String> attackList = TFTHConfiguration.getMobsThatAttackInfected();
            List<String> superAttackList = TFTHConfiguration.getSuperAttackList();
            List<String> garantedAttackList = TFTHConfiguration.garantedSuperAttackList();
            List<String> fleeList = TFTHConfiguration.getMobsThatFleeFromInfected();
            List<String> superFleeList = TFTHConfiguration.getSuperFleeList();
            List<String> savefleshybuddys = TFTHConfiguration.getModMobsNonAttackList();
            String mobIdentifier = EntityType.m_20613_((EntityType)mob.m_6095_()).toString();
            if (HandleEvents.isFleshSave(mobIdentifier, savefleshybuddys)) {
                mob.f_21346_.m_25352_(4, new PreventAttackGoal(mob, FleshMobs.ENTITY_TYPES));
            }
            if (HandleEvents.isFleshAttack(mobIdentifier, garantedAttackList)) {
                mob.f_21346_.m_25352_(4, new DoAttackGoal(mob, FleshMobs.ENTITY_TYPES, true));
            }
            if (!HandleEvents.isFleshSave(mobIdentifier, savefleshybuddys) && (attackList.contains(mobIdentifier) || HandleEvents.isSuperAttackTarget(mobIdentifier, superAttackList))) {
                mob.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)mob, LivingEntity.class, 10, false, false, target -> FleshMobs.ENTITY_TYPES.contains(target.m_6095_())));
            }
            if (fleeList.contains(mobIdentifier) || HandleEvents.isSuperFlee(mobIdentifier, superFleeList)) {
                mob.f_21345_.m_25352_(4, (Goal)new AvoidEntityGoal(mob, LivingEntity.class, 6.0f, 1.0, 0.8, target -> FleshMobs.ENTITY_TYPES.contains(target.m_6095_())));
            }
        }
    }

    private static boolean isSuperAttackTarget(String mobIdentifier, List<String> superAttackList) {
        for (String idPrefix : superAttackList) {
            if (!mobIdentifier.startsWith(idPrefix)) continue;
            return true;
        }
        return false;
    }

    private static boolean isSuperFlee(String mobIdentifier, List<String> superFleeList) {
        for (String idPrefix : superFleeList) {
            if (!mobIdentifier.startsWith(idPrefix)) continue;
            return true;
        }
        return false;
    }

    private static boolean isFleshSave(String mobIdentifier, List<String> savefleshybuddys) {
        for (String idPrefix : savefleshybuddys) {
            if (!mobIdentifier.startsWith(idPrefix)) continue;
            return true;
        }
        return false;
    }

    private static boolean isFleshAttack(String mobIdentifier, List<String> garantedAttackList) {
        for (String idPrefix : garantedAttackList) {
            if (!mobIdentifier.startsWith(idPrefix)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public static void onLivingHurt(LivingHurtEvent event) {
        if (isProcessingEvent.get().booleanValue()) {
            return;
        }
        try {
            LivingEntity attacker;
            Entity damageToTransfer2;
            float increasedDamage;
            List bruteplaquecreatures;
            isProcessingEvent.set(true);
            LivingEntity eventEntity = event.getEntity();
            if (!(eventEntity instanceof LivingEntity)) {
                return;
            }
            LivingEntity entity = eventEntity;
            DamageSource source = event.getSource();
            float amount = event.getAmount();
            EntityType bruteplaquecreatureoneType = (EntityType)TheFleshThatHatesModEntities.BRUTEPLAQUECREATUREONE.get();
            if (FleshMobs.ENTITY_TYPES.contains(entity.m_6095_()) && !entity.m_6060_()) {
                float damageReductionFactor = HandleEvents.getDamageReductionFactorByStage(FleshWorld.getCurrentStage());
                event.setAmount(event.getAmount() * (1.0f - damageReductionFactor));
            }
            if (FleshMobs.ENTITY_TYPES.contains(entity.m_6095_()) && !(bruteplaquecreatures = entity.m_9236_().m_6443_(LivingEntity.class, entity.m_20191_().m_82400_(10.0), e -> e.m_6095_() == bruteplaquecreatureoneType)).isEmpty()) {
                event.setAmount(amount * 0.7f);
                float damageToTransfer2 = amount * 0.3f / (float)bruteplaquecreatures.size();
                for (LivingEntity bruteplaquecreature : bruteplaquecreatures) {
                    bruteplaquecreature.m_6469_(source, damageToTransfer2);
                }
            }
            if (FleshMobs.ENTITY_TYPES.contains(entity.m_6095_()) && entity.m_6095_() != TheFleshThatHatesModEntities.FLESH_COMMUNITY.get() && entity.m_6060_()) {
                increasedDamage = event.getAmount() * (float)TFTHConfiguration.getFireDamageMultiplier();
                event.setAmount(increasedDamage);
            }
            if (entity.m_6095_() == TheFleshThatHatesModEntities.FLESH_COMMUNITY.get() && entity.m_6060_()) {
                increasedDamage = event.getAmount() * HandleEvents.getFireDamageMultiplierByStage(FleshWorld.getCurrentStage());
                event.setAmount(increasedDamage);
            }
            if ((entity.m_6095_() == TheFleshThatHatesModEntities.PLAQUEINCUBATORONE.get() || entity.m_6095_() == TheFleshThatHatesModEntities.PLAQUEINCUBATORSTART.get()) && (damageToTransfer2 = source.m_7639_()) instanceof LivingEntity && !(attacker = (LivingEntity)damageToTransfer2).m_21224_()) {
                Player player;
                if (attacker instanceof Player && (player = (Player)attacker).m_7500_()) {
                    return;
                }
                List nearbyFleshMobs = entity.m_9236_().m_6443_(Mob.class, entity.m_20191_().m_82400_(64.0), e -> FleshMobs.isFleshEntity((Entity)e) && !HandleEvents.isAlreadyEngaged(e));
                for (Mob fleshMob : nearbyFleshMobs) {
                    fleshMob.m_6710_(attacker);
                    fleshMob.m_21561_(true);
                }
            }
        }
        finally {
            isProcessingEvent.set(false);
        }
    }

    private static float getDamageReductionFactorByStage(FleshWorld.FleshStage stage) {
        switch (stage) {
            case GERM_STAGE: {
                return TFTHConfiguration.getGermStageDamageReduction();
            }
            case AWARENESS_STAGE: {
                return TFTHConfiguration.getAwarenessStageDamageReduction();
            }
            case GROWTH_STAGE: {
                return TFTHConfiguration.getGrowthStageDamageReduction();
            }
            case SYNTHESIS_STAGE: {
                return TFTHConfiguration.getSynthesisStageDamageReduction();
            }
            case EPITASIS_STAGE: {
                return TFTHConfiguration.getEpitasisStageDamageReduction();
            }
        }
        return TFTHConfiguration.getFetalStageDamageReduction();
    }

    private static float getFireDamageMultiplierByStage(FleshWorld.FleshStage stage) {
        switch (stage) {
            case FETAL_STAGE: {
                return ((Double)TFTHConfiguration.FETAL_STAGE_FIRE_DAMAGE_MULTIPLIER.get()).floatValue();
            }
            case GERM_STAGE: {
                return ((Double)TFTHConfiguration.GERM_STAGE_FIRE_DAMAGE_MULTIPLIER.get()).floatValue();
            }
            case AWARENESS_STAGE: {
                return ((Double)TFTHConfiguration.AWARENESS_STAGE_FIRE_DAMAGE_MULTIPLIER.get()).floatValue();
            }
            case GROWTH_STAGE: {
                return ((Double)TFTHConfiguration.GROWTH_STAGE_FIRE_DAMAGE_MULTIPLIER.get()).floatValue();
            }
            case SYNTHESIS_STAGE: {
                return ((Double)TFTHConfiguration.SYNTHESIS_STAGE_FIRE_DAMAGE_MULTIPLIER.get()).floatValue();
            }
            case EPITASIS_STAGE: {
                return ((Double)TFTHConfiguration.EPITASIS_STAGE_FIRE_DAMAGE_MULTIPLIER.get()).floatValue();
            }
        }
        return ((Double)TFTHConfiguration.FETAL_STAGE_FIRE_DAMAGE_MULTIPLIER.get()).floatValue();
    }

    private static boolean isAlreadyEngaged(Mob mob) {
        return mob.m_5448_() != null && !mob.m_5448_().m_21224_() || mob.m_5912_();
    }

    @SubscribeEvent
    public static void onLivingAttack(LivingAttackEvent event) {
        MobEffect paralysisEffect;
        LivingEntity livingAttacker;
        Entity attacker = event.getSource().m_7639_();
        if (attacker instanceof LivingEntity && (livingAttacker = (LivingEntity)attacker).m_21023_(paralysisEffect = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(new ResourceLocation("the_flesh_that_hates:paralysis")))) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onLivingDeath(LivingDeathEvent event) {
        Random rand;
        MobEffect decomposition;
        boolean isExcludedType;
        LivingEntity deadEntity = event.getEntity();
        Level world = deadEntity.m_9236_();
        EntityType entityType = deadEntity.m_6095_();
        boolean bl = isExcludedType = entityType == TheFleshThatHatesModEntities.FLESH_JUSTICE.get() || entityType == TheFleshThatHatesModEntities.FLESH_COCOON.get() || entityType == TheFleshThatHatesModEntities.PLAQUEINCUBATORSTART.get() || entityType == TheFleshThatHatesModEntities.PLAQUEINCUBATORONE.get() || entityType == TheFleshThatHatesModEntities.FLESH_SERVANT.get();
        if (!world.f_46443_ && TFTHConfiguration.isFleshJusticeSpawnEnabled() && FleshMobs.isFleshEntity((Entity)deadEntity) && !isExcludedType) {
            BlockPos spawnPos;
            double spawnChance = FleshWorld.getFleshJusticeSpawnChance();
            if (world.f_46441_.m_188500_() < spawnChance && (spawnPos = HandleEvents.findSafeLocation(world, deadEntity.m_20183_(), 26)) != null) {
                FleshJusticeEntity fleshJustice = new FleshJusticeEntity((EntityType<FleshJusticeEntity>)((EntityType)TheFleshThatHatesModEntities.FLESH_JUSTICE.get()), world);
                fleshJustice.m_6027_((double)spawnPos.m_123341_() + 0.5, spawnPos.m_123342_(), (double)spawnPos.m_123343_() + 0.5);
                world.m_7967_((Entity)fleshJustice);
                fleshJustice.createAndStoreFleshCocoon(deadEntity);
                SoundEvent[] sounds = new SoundEvent[]{(SoundEvent)TheFleshThatHatesModSounds.JUSTICE_A1.get(), (SoundEvent)TheFleshThatHatesModSounds.JUSTICE_A2.get(), (SoundEvent)TheFleshThatHatesModSounds.JUSTICE_A3.get()};
                SoundEvent soundToPlay = sounds[world.f_46441_.m_188503_(sounds.length)];
                world.m_5594_(null, spawnPos, soundToPlay, SoundSource.HOSTILE, 1.0f, 1.0f);
                AABB area = new AABB(spawnPos).m_82400_(50.0);
                for (Player player : world.m_45976_(Player.class, area)) {
                    player.m_6330_(soundToPlay, SoundSource.HOSTILE, 1.0f, 1.0f);
                }
            }
        }
        if (deadEntity.m_21023_(decomposition = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(new ResourceLocation("the_flesh_that_hates:decomposition"))) && (double)(rand = new Random()).nextFloat() < 0.5 && world instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)world;
            if (entityType == TheFleshThatHatesModEntities.FLESH_HUMAN.get() || entityType == TheFleshThatHatesModEntities.FLESH_VILLAGER.get() || entityType == TheFleshThatHatesModEntities.FLESH_PILLAGER.get() || entityType == TheFleshThatHatesModEntities.FLESH_VINDICATOR.get()) {
                FleshHumanHeadEntity headEntity = (FleshHumanHeadEntity)((EntityType)TheFleshThatHatesModEntities.FLESH_HUMAN_HEAD.get()).m_20615_(world);
                headEntity.m_7678_(deadEntity.m_20185_(), deadEntity.m_20186_(), deadEntity.m_20189_(), deadEntity.m_146908_(), deadEntity.m_146909_());
                world.m_7967_((Entity)headEntity);
                Block purulentBlock = (Block)TheFleshThatHatesModBlocks.PURULENT.get();
                BlockPos positionUnder = deadEntity.m_20183_().m_7495_();
                world.m_46597_(positionUnder, purulentBlock.m_49966_());
                SimpleParticleType decompositionboom = (SimpleParticleType)TheFleshThatHatesModParticleTypes.DECOMPOSITION_PARTICLE.get();
                for (int i = 0; i < 20; ++i) {
                    double offsetX = rand.nextGaussian() * 0.02;
                    double offsetY = rand.nextGaussian() * 0.02;
                    double offsetZ = rand.nextGaussian() * 0.02;
                    serverLevel.m_8767_((ParticleOptions)decompositionboom, deadEntity.m_20208_(0.5) + offsetX, deadEntity.m_20187_() + offsetY, deadEntity.m_20262_(0.5) + offsetZ, 1, 0.0, 0.0, 0.0, 0.1);
                }
                deadEntity.m_142687_(Entity.RemovalReason.DISCARDED);
            }
        }
    }

    private static BlockPos findSafeLocation(Level world, BlockPos center, int radius) {
        for (int i = 0; i < 10; ++i) {
            BlockPos pos = center.m_7918_(world.f_46441_.m_188503_(radius * 2) - radius, world.f_46441_.m_188503_(6) - 3, world.f_46441_.m_188503_(radius * 2) - radius);
            if (!world.m_46859_(pos) || !world.m_46859_(pos.m_7494_()) || !world.m_8055_(pos.m_7495_()).m_60804_((BlockGetter)world, pos.m_7495_())) continue;
            return pos;
        }
        return null;
    }

    @SubscribeEvent
    public static void onBlockBreak(BlockEvent.BreakEvent event) {
        BlockState state = event.getState();
        Player player = event.getPlayer();
        Level level = (Level)event.getLevel();
        if (!level.m_5776_()) {
            if ((state.m_60734_() instanceof FleshBoilPhaseTwoBlock || state.m_60734_() instanceof FleshBoilBlock) && player.m_21205_().m_41720_() instanceof PickaxeItem) {
                if (state.m_60734_() instanceof FleshBoilPhaseTwoBlock) {
                    FleshWorld.subtractPoints(TFTHConfiguration.getFleshBoilTwoPointsReduce(), level);
                } else if (state.m_60734_() instanceof FleshBoilBlock) {
                    FleshWorld.subtractPoints(TFTHConfiguration.getFleshBoilPointsReduce(), level);
                }
            }
            BlockPos pos = event.getPos();
            List startEntitiesAbove = level.m_45976_(PlaqueincubatorstartEntity.class, new AABB(pos.m_7494_()));
            List oneEntitiesAbove = level.m_45976_(PlaqueincubatoroneEntity.class, new AABB(pos.m_7494_()));
            if (!(startEntitiesAbove.isEmpty() && oneEntitiesAbove.isEmpty() || player.m_7500_())) {
                event.setCanceled(true);
                return;
            }
        }
    }

    @SubscribeEvent
    public static void registerCommand(RegisterCommandsEvent event) {
        event.getDispatcher().register((LiteralArgumentBuilder)Commands.m_82127_((String)"tfth:entity_stats").then(Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91449_()).executes(context -> {
            CommandSourceStack source = (CommandSourceStack)context.getSource();
            Entity entity = EntityArgument.m_91452_((CommandContext)context, (String)"target");
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                double health = livingEntity.m_21223_();
                double armor = livingEntity.m_21133_(Attributes.f_22284_);
                double attack = livingEntity.m_21133_(Attributes.f_22281_);
                source.m_81375_().m_5661_((Component)Component.m_237113_((String)("Health: " + health)), false);
                source.m_81375_().m_5661_((Component)Component.m_237113_((String)("Armor: " + armor)), false);
                source.m_81375_().m_5661_((Component)Component.m_237113_((String)("Attack Damage: " + attack)), false);
            } else {
                source.m_81375_().m_5661_((Component)Component.m_237113_((String)"Entity not found"), false);
            }
            return 1;
        })));
        event.getDispatcher().register((LiteralArgumentBuilder)Commands.m_82127_((String)"tfth:help").executes(context -> {
            CommandSourceStack source = (CommandSourceStack)context.getSource();
            try {
                source.m_81375_().m_5661_((Component)Component.m_237113_((String)"Available Commands:"), false);
                source.m_81375_().m_5661_((Component)Component.m_237113_((String)"/tfth:points - Displays current points and phase."), false);
                source.m_81375_().m_5661_((Component)Component.m_237113_((String)"/tfth:points_add <points> - Adds points."), false);
                source.m_81375_().m_5661_((Component)Component.m_237113_((String)"/tfth:points_subtr <points> - Subtracts points."), false);
                source.m_81375_().m_5661_((Component)Component.m_237113_((String)"/tfth:points_reset - Resets points and stage."), false);
                source.m_81375_().m_5661_((Component)Component.m_237113_((String)"/tfth:entity_stats <entity> - Displays entity stats."), false);
                source.m_81375_().m_5661_((Component)Component.m_237113_((String)"/tfth:kill - Kill all flesh mobs(not always)"), false);
            }
            catch (CommandSyntaxException e) {
                source.m_81352_((Component)Component.m_237113_((String)"This command can only be executed by a player."));
            }
            return 1;
        }));
        event.getDispatcher().register((LiteralArgumentBuilder)Commands.m_82127_((String)"tfth:kill").executes(context -> {
            CommandSourceStack source = (CommandSourceStack)context.getSource();
            ServerLevel serverLevel = source.m_81372_();
            int count = 0;
            try {
                for (Entity entity : serverLevel.m_8583_()) {
                    if (entity == null || !MobHelper.isFleshMob(entity) || entity.m_6095_().equals(EntityType.f_20532_)) continue;
                    if (entity.m_6095_().equals(TheFleshThatHatesModEntities.FLESH_BOOMER.get())) {
                        entity.m_146870_();
                    } else {
                        entity.m_6074_();
                    }
                    ++count;
                }
                if (source.m_81373_() != null) {
                    source.m_81375_().m_5661_((Component)Component.m_237113_((String)("Killed " + count + " flesh entities")), true);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                source.m_81352_((Component)Component.m_237113_((String)"An error occurred. Check server console."));
            }
            return 1;
        }));
    }

    @SubscribeEvent
    public void onBucketFill(FillBucketEvent event) {
        BlockPos pos;
        ItemStack bucket = event.getEmptyBucket();
        Level level = event.getLevel();
        HitResult target = event.getTarget();
        if (target.m_6662_() == HitResult.Type.BLOCK && level.m_8055_(pos = ((BlockHitResult)target).m_82425_()).m_60734_() instanceof PusBlock && bucket.m_41720_() == Items.f_42446_) {
            level.m_7471_(pos, false);
            event.setFilledBucket(new ItemStack((ItemLike)TheFleshThatHatesModItems.PUS_BUCKET.get()));
            event.setResult(Event.Result.ALLOW);
        }
    }

    @SubscribeEvent
    public static void onLivingKnockBack(LivingKnockBackEvent event) {
        RandomSource random;
        if (event.getEntity() instanceof PlaquecreatureoneEntity && (random = RandomSource.m_216327_()).m_188501_() < 0.3f) {
            event.setCanceled(true);
        }
    }

    public static class PreventAttackGoal<T extends LivingEntity>
    extends Goal {
        private final PathfinderMob mob;
        private final Set<EntityType<?>> forbiddenTargets;

        public PreventAttackGoal(PathfinderMob mob, Set<EntityType<?>> forbiddenTargets) {
            this.mob = mob;
            this.forbiddenTargets = forbiddenTargets;
        }

        public boolean m_8036_() {
            if (this.mob.m_5448_() != null && this.forbiddenTargets.contains(this.mob.m_5448_().m_6095_())) {
                this.mob.m_6710_(null);
                return false;
            }
            return false;
        }
    }

    public static class DoAttackGoal<T extends LivingEntity>
    extends Goal {
        private final PathfinderMob mob;
        private final Set<EntityType<?>> targetTypes;
        private final boolean allowOriginalBehavior;

        public DoAttackGoal(PathfinderMob mob, Set<EntityType<?>> targetTypes, boolean allowOriginalBehavior) {
            this.mob = mob;
            this.targetTypes = targetTypes;
            this.allowOriginalBehavior = allowOriginalBehavior;
        }

        public boolean m_8036_() {
            if (this.mob.m_5448_() != null && this.allowOriginalBehavior && !this.targetTypes.contains(this.mob.m_5448_().m_6095_())) {
                return false;
            }
            List potentialTargets = this.mob.m_9236_().m_45976_(LivingEntity.class, this.mob.m_20191_().m_82400_(10.0));
            for (LivingEntity potentialTarget : potentialTargets) {
                if (!this.targetTypes.contains(potentialTarget.m_6095_())) continue;
                this.mob.m_6710_(potentialTarget);
                return true;
            }
            return false;
        }
    }
}

