/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.thefleshthathates;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.mcreator.thefleshthathates.FleshBlockSpread;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class FleshBlockSavedData
extends SavedData {
    private static final String DATA_NAME = "TheFleshThatHates_FleshBlocks";
    private final List<FleshBlockSpread> blocksToSpread = new ArrayList<FleshBlockSpread>();
    private final Map<BlockPos, Integer> consumedMobsCount = new HashMap<BlockPos, Integer>();
    private Set<BlockPos> fleshBoilBlocks = new HashSet<BlockPos>();

    public static FleshBlockSavedData load(CompoundTag nbt) {
        FleshBlockSavedData data = new FleshBlockSavedData();
        ListTag list = nbt.m_128437_("BlocksToSpread", 10);
        for (int i = 0; i < list.size(); ++i) {
            CompoundTag spreadTag = list.m_128728_(i);
            FleshBlockSpread spread = new FleshBlockSpread(null, BlockPos.f_121853_);
            spread.loadStateFromNBT(spreadTag.m_128469_("SpreadData"));
            data.blocksToSpread.add(spread);
        }
        ListTag listTag = nbt.m_128437_("FleshBoilBlocks", 10);
        for (int i = 0; i < listTag.size(); ++i) {
            CompoundTag posTag = listTag.m_128728_(i);
            BlockPos pos = new BlockPos(posTag.m_128451_("X"), posTag.m_128451_("Y"), posTag.m_128451_("Z"));
            data.fleshBoilBlocks.add(pos);
        }
        return data;
    }

    public CompoundTag m_7176_(CompoundTag compound) {
        ListTag list = new ListTag();
        for (FleshBlockSpread spread : this.blocksToSpread) {
            CompoundTag spreadTag = new CompoundTag();
            spreadTag.m_128365_("SpreadData", (Tag)spread.saveStateToNBT());
            list.add((Object)spreadTag);
        }
        compound.m_128365_("BlocksToSpread", (Tag)list);
        ListTag fleshBoilList = new ListTag();
        for (BlockPos pos : this.fleshBoilBlocks) {
            CompoundTag posTag = new CompoundTag();
            posTag.m_128405_("X", pos.m_123341_());
            posTag.m_128405_("Y", pos.m_123342_());
            posTag.m_128405_("Z", pos.m_123343_());
            fleshBoilList.add((Object)posTag);
        }
        compound.m_128365_("FleshBoilBlocks", (Tag)fleshBoilList);
        return compound;
    }

    public void addBlockToSpread(FleshBlockSpread spread, ServerLevel level) {
        this.blocksToSpread.add(spread);
        Component message = Component.m_130674_((String)("blocksToSpread: " + this.blocksToSpread.size()));
        for (ServerPlayer player : level.m_7654_().m_6846_().m_11314_()) {
            player.m_5661_(message, false);
        }
        this.m_77762_();
    }

    public List<FleshBlockSpread> getBlocksToSpread() {
        return this.blocksToSpread;
    }

    public static FleshBlockSavedData get(DimensionDataStorage storage) {
        return (FleshBlockSavedData)storage.m_164861_(FleshBlockSavedData::load, FleshBlockSavedData::new, DATA_NAME);
    }

    public void saveFleshBlockSpreads(List<FleshBlockSpread> spreads) {
        this.blocksToSpread.clear();
        this.blocksToSpread.addAll(spreads);
        this.m_77762_();
    }

    public void addFleshBoilBlock(BlockPos pos) {
        this.fleshBoilBlocks.add(pos);
    }

    public void removeFleshBoilBlock(BlockPos pos) {
        this.fleshBoilBlocks.remove(pos);
    }

    public Set<BlockPos> getFleshBoilBlocks() {
        return this.fleshBoilBlocks;
    }

    public void incrementConsumedMobCount(BlockPos blockPos) {
        this.consumedMobsCount.put(blockPos, this.consumedMobsCount.getOrDefault(blockPos, 0) + 1);
        this.m_77762_();
    }

    public int getConsumedMobCount(BlockPos blockPos) {
        return this.consumedMobsCount.getOrDefault(blockPos, 0);
    }

    public static FleshBlockSavedData get(MinecraftServer server) {
        if (server == null) {
            return null;
        }
        ServerLevel overworld = server.m_129880_(ServerLevel.f_46428_);
        if (overworld == null) {
            return null;
        }
        return (FleshBlockSavedData)overworld.m_8895_().m_164861_(nbt -> {
            FleshBlockSavedData data = new FleshBlockSavedData();
            FleshBlockSavedData.load(nbt);
            return data;
        }, FleshBlockSavedData::new, DATA_NAME);
    }

    @SubscribeEvent
    public static void onServerStarting(ServerStartingEvent event) {
        MinecraftServer server = event.getServer();
        FleshBlockSavedData data = FleshBlockSavedData.get(server);
        if (data != null) {
            for (Map.Entry<BlockPos, Integer> entry : data.consumedMobsCount.entrySet()) {
            }
        }
    }
}

