/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.thefleshthathates;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Random;
import java.util.Set;
import net.mcreator.thefleshthathates.BlockAlgorithms;
import net.mcreator.thefleshthathates.FConfig.TFTHConfiguration;
import net.mcreator.thefleshthathates.FEvents.FleshWorld;
import net.mcreator.thefleshthathates.block.FleshBlockBlock;
import net.mcreator.thefleshthathates.block.FleshTernsBlock;
import net.mcreator.thefleshthathates.entity.PlaqueincubatoroneEntity;
import net.mcreator.thefleshthathates.entity.PlaqueincubatorstartEntity;
import net.mcreator.thefleshthathates.features.structures.FStructures;
import net.mcreator.thefleshthathates.init.TheFleshThatHatesModBlocks;
import net.mcreator.thefleshthathates.init.TheFleshThatHatesModParticleTypes;
import net.mcreator.thefleshthathates.init.TheFleshThatHatesModSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;

public class FleshBlockSpread {
    protected ServerLevel level;
    public BlockPos origin;
    public BlockPos currentPosition;
    public List<BlockPos> activeSpreadBlocks = new ArrayList<BlockPos>();
    private Map<BlockPos, BlockPos> lastPusPositions = new HashMap<BlockPos, BlockPos>();
    private Map<BlockPos, BlockPos> lastMouthPositions = new HashMap<BlockPos, BlockPos>();
    private Map<BlockPos, BlockPos> lastSpinePositions = new HashMap<BlockPos, BlockPos>();
    private Map<BlockPos, BlockPos> lastTreePositions = new HashMap<BlockPos, BlockPos>();
    public Set<Long> visitedPositions = new HashSet<Long>();
    LinkedList<Map.Entry<BlockPos, Double>> queue = new LinkedList();
    private Map<BlockPos, Boolean> activeBlockOrigins = new HashMap<BlockPos, Boolean>();
    private Set<BlockPos> maxSpreadReachedBlocks = new HashSet<BlockPos>();
    private Map<BlockPos, Integer> requeueCounters = new HashMap<BlockPos, Integer>();
    public Set<BlockPos> processedBlocks = new HashSet<BlockPos>();
    LinkedList<BlockPos> deferredProcessingQueue = new LinkedList();
    private boolean isCooldown = false;
    private boolean hasIncreasedSpread = false;
    private int highestSpreadY = -1;
    private int lastCheckedPoints = 0;
    private int cooldownCounter = 0;
    private int spreadCounter = 0;
    private int spreadRateCounter = 0;
    private int fleshTreeSpawnCounter = 0;
    private final int MIN_DISTANCE_PUS = 56;
    private final int MIN_DISTANCE_MOUTH = 48;
    private final int MIN_DISTANCE_SPINE = 38;
    private final int MIN_DISTANCE_TREE = 12;
    State state = State.IDLE;
    SpreadState spreadState = SpreadState.LINES;
    private int currentPoints = 0;
    private int processedBlocksCount = 0;
    private static final int TARGET_SPREAD_COUNT = 1000;
    private final int BASE_RADIUS_START = 1;
    private final int BASE_RADIUS_ONE = 1;
    private final int POINTS_PER_RADIUS_INCREASE = 10;
    private final int RADIUS_INCREASE_START = 1;
    private final int RADIUS_INCREASE_ONE = 1;
    private final int BASE_MAX_DISTANCE = 1;
    private final int BASE_CHECK_RADIUS = 1;
    private final int BASE_INITIAL_SPREAD_RATE = TFTHConfiguration.biomespreadspeed();
    private final int BASE_INCREASED_SPREAD_RATE = 30;
    private final int MAX_SPREAD_SPEED = 2;
    private static final int BASE_ACTIVE_BLOCK_INTERVAL = 7;
    private static final int MAX_DEPTH_SPREAD = 2;
    private static final int BLOCKS_PER_TICK = TFTHConfiguration.biomespreadspeed();
    private static final int TICK_DELAY = 1;
    private int blockCreationTimer = 0;
    private boolean blocksCreated = false;
    private int tickCooldown = 0;
    int spreadRadiusStart = 1 + this.currentPoints / 10 * 1;
    int spreadRadiusOne = 1 + this.currentPoints / 10 * 1;
    int MAX_DISTANCE = 1 + this.currentPoints / 10;
    int INCREASED_SPREAD_RADIUS = this.spreadRadiusOne;
    int CHECK_RADIUS = 1 + this.currentPoints / 10;
    int INITIAL_SPREAD_RATE;
    int INCREASED_SPREAD_RATE = 30;
    private final int BASE_BLOCKS_TO_REPLACE = 0;
    int blocksToReplace = 0 + this.currentPoints / 10;
    private Set<BlockPos> spawnedStructures = new HashSet<BlockPos>();

    public FleshBlockSpread(ServerLevel level, BlockPos origin) {
        this.level = level;
        this.origin = origin;
        this.currentPosition = origin;
        this.setCurrentPoints();
    }

    public void setCurrentPoints() {
        this.currentPoints = this.getCurrentPoints();
        this.spreadRadiusStart = Math.min(1 + this.currentPoints / 10 * 1, TFTHConfiguration.biomeMaxRangespeed());
        this.spreadRadiusOne = Math.min(1 + this.currentPoints / 10 * 1, TFTHConfiguration.biomeMaxRangespeed());
        this.MAX_DISTANCE = Math.max(this.spreadRadiusStart, this.spreadRadiusOne);
        this.INCREASED_SPREAD_RADIUS = this.spreadRadiusOne;
        this.CHECK_RADIUS = Math.min(1 + this.currentPoints / 10, TFTHConfiguration.biomeMaxRangespeed());
        int maxPoints = 100000;
        this.INITIAL_SPREAD_RATE = (int)((double)this.BASE_INITIAL_SPREAD_RATE + (double)this.currentPoints / (double)maxPoints * (double)(2 - this.BASE_INITIAL_SPREAD_RATE));
        this.blocksToReplace = 0 + this.currentPoints / 10;
    }

    public void setLevel(ServerLevel serverLevel) {
        this.level = serverLevel;
    }

    public State getState() {
        return this.state;
    }

    public CompoundTag saveStateToNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128356_("origin", this.origin.m_121878_());
        tag.m_128379_("isCooldown", this.isCooldown);
        tag.m_128405_("tickCooldown", this.tickCooldown);
        tag.m_128405_("blockCreationTimer", this.blockCreationTimer);
        tag.m_128379_("hasIncreasedSpread", this.hasIncreasedSpread);
        tag.m_128379_("blocksCreated", this.blocksCreated);
        tag.m_128356_("currentPosition", this.currentPosition.m_121878_());
        tag.m_128405_("currentPoints", this.currentPoints);
        tag.m_128405_("highestSpreadY", this.highestSpreadY);
        tag.m_128405_("cooldownCounter", this.cooldownCounter);
        tag.m_128405_("spreadCounter", this.spreadCounter);
        tag.m_128405_("spreadRateCounter", this.spreadRateCounter);
        tag.m_128405_("spreadRadiusStart", this.spreadRadiusStart);
        tag.m_128405_("spreadRadiusOne", this.spreadRadiusOne);
        tag.m_128405_("MAX_DISTANCE", this.MAX_DISTANCE);
        tag.m_128405_("INCREASED_SPREAD_RADIUS", this.INCREASED_SPREAD_RADIUS);
        tag.m_128405_("CHECK_RADIUS", this.CHECK_RADIUS);
        tag.m_128405_("INITIAL_SPREAD_RATE", this.INITIAL_SPREAD_RATE);
        tag.m_128405_("INCREASED_SPREAD_RATE", this.INCREASED_SPREAD_RATE);
        tag.m_128405_("blocksToReplace", this.blocksToReplace);
        tag.m_128359_("state", this.state.name());
        tag.m_128359_("spreadState", this.spreadState.name());
        ListTag activeSpreadBlocksList = new ListTag();
        for (BlockPos blockPos : this.activeSpreadBlocks) {
            activeSpreadBlocksList.add((Object)NbtUtils.m_129224_((BlockPos)blockPos));
        }
        tag.m_128365_("activeSpreadBlocks", (Tag)activeSpreadBlocksList);
        ListTag visitedPositionsList = new ListTag();
        for (Long l : this.visitedPositions) {
            visitedPositionsList.add((Object)LongTag.m_128882_((long)l));
        }
        tag.m_128365_("visitedPositions", (Tag)visitedPositionsList);
        ListTag listTag = new ListTag();
        for (Map.Entry entry : this.queue) {
            CompoundTag compoundTag = new CompoundTag();
            compoundTag.m_128356_("pos", ((BlockPos)entry.getKey()).m_121878_());
            compoundTag.m_128347_("value", ((Double)entry.getValue()).doubleValue());
            listTag.add((Object)compoundTag);
        }
        tag.m_128365_("queue", (Tag)listTag);
        CompoundTag compoundTag = new CompoundTag();
        for (Map.Entry<BlockPos, Boolean> entry : this.activeBlockOrigins.entrySet()) {
            compoundTag.m_128379_(entry.getKey().toString(), entry.getValue().booleanValue());
        }
        tag.m_128365_("activeBlockOrigins", (Tag)compoundTag);
        ListTag listTag2 = new ListTag();
        for (BlockPos blockPos : this.maxSpreadReachedBlocks) {
            listTag2.add((Object)LongTag.m_128882_((long)blockPos.m_121878_()));
        }
        tag.m_128365_("maxSpreadReachedBlocks", (Tag)listTag2);
        CompoundTag compoundTag2 = new CompoundTag();
        for (Map.Entry<BlockPos, Integer> entry : this.requeueCounters.entrySet()) {
            compoundTag2.m_128405_(entry.getKey().toString(), entry.getValue().intValue());
        }
        tag.m_128365_("requeueCounters", (Tag)compoundTag2);
        ListTag listTag3 = new ListTag();
        for (BlockPos pos : this.deferredProcessingQueue) {
            listTag3.add((Object)LongTag.m_128882_((long)pos.m_121878_()));
        }
        tag.m_128365_("deferredProcessingQueue", (Tag)listTag3);
        ListTag listTag4 = new ListTag();
        for (BlockPos pos : this.processedBlocks) {
            listTag4.add((Object)NbtUtils.m_129224_((BlockPos)pos));
        }
        tag.m_128365_("processedBlocks", (Tag)listTag4);
        return tag;
    }

    public void loadStateFromNBT(CompoundTag tag) {
        this.origin = BlockPos.m_122022_((long)tag.m_128454_("origin"));
        this.currentPosition = BlockPos.m_122022_((long)tag.m_128454_("currentPosition"));
        this.currentPoints = tag.m_128451_("currentPoints");
        this.highestSpreadY = tag.m_128451_("highestSpreadY");
        this.cooldownCounter = tag.m_128451_("cooldownCounter");
        this.spreadCounter = tag.m_128451_("spreadCounter");
        this.spreadRateCounter = tag.m_128451_("spreadRateCounter");
        this.state = State.valueOf(tag.m_128461_("state"));
        this.spreadState = SpreadState.valueOf(tag.m_128461_("spreadState"));
        this.isCooldown = tag.m_128471_("isCooldown");
        this.hasIncreasedSpread = tag.m_128471_("hasIncreasedSpread");
        this.blocksCreated = tag.m_128471_("blocksCreated");
        this.tickCooldown = tag.m_128451_("tickCooldown");
        this.blockCreationTimer = tag.m_128451_("blockCreationTimer");
        this.processedBlocksCount = tag.m_128451_("processedBlocksCount");
        this.spreadRadiusStart = tag.m_128441_("spreadRadiusStart") ? tag.m_128451_("spreadRadiusStart") : 1;
        this.spreadRadiusOne = tag.m_128441_("spreadRadiusOne") ? tag.m_128451_("spreadRadiusOne") : 1;
        this.MAX_DISTANCE = tag.m_128441_("MAX_DISTANCE") ? tag.m_128451_("MAX_DISTANCE") : 1;
        this.INCREASED_SPREAD_RADIUS = tag.m_128441_("INCREASED_SPREAD_RADIUS") ? tag.m_128451_("INCREASED_SPREAD_RADIUS") : this.spreadRadiusOne;
        this.CHECK_RADIUS = tag.m_128441_("CHECK_RADIUS") ? tag.m_128451_("CHECK_RADIUS") : 1;
        this.INITIAL_SPREAD_RATE = tag.m_128441_("INITIAL_SPREAD_RATE") ? tag.m_128451_("INITIAL_SPREAD_RATE") : this.BASE_INITIAL_SPREAD_RATE;
        this.INCREASED_SPREAD_RATE = tag.m_128441_("INCREASED_SPREAD_RATE") ? tag.m_128451_("INCREASED_SPREAD_RATE") : 30;
        this.blocksToReplace = tag.m_128441_("blocksToReplace") ? tag.m_128451_("blocksToReplace") : 0;
        this.activeSpreadBlocks.clear();
        ListTag activeSpreadBlocksList = tag.m_128437_("activeSpreadBlocks", 10);
        for (int i = 0; i < activeSpreadBlocksList.size(); ++i) {
            this.activeSpreadBlocks.add(NbtUtils.m_129239_((CompoundTag)activeSpreadBlocksList.m_128728_(i)));
        }
        this.visitedPositions.clear();
        ListTag visitedPositionsList = tag.m_128437_("visitedPositions", 4);
        for (int i = 0; i < visitedPositionsList.size(); ++i) {
            this.visitedPositions.add(((LongTag)visitedPositionsList.get(i)).m_7046_());
        }
        this.queue.clear();
        ListTag queueList = tag.m_128437_("queue", 10);
        for (int i = 0; i < queueList.size(); ++i) {
            CompoundTag entryTag = queueList.m_128728_(i);
            BlockPos pos = BlockPos.m_122022_((long)entryTag.m_128454_("pos"));
            double value = entryTag.m_128459_("value");
            this.queue.add(new AbstractMap.SimpleEntry<BlockPos, Double>(pos, value));
        }
        this.activeBlockOrigins.clear();
        CompoundTag activeBlockOriginsTag = tag.m_128469_("activeBlockOrigins");
        for (Object key : activeBlockOriginsTag.m_128431_()) {
            BlockPos pos = BlockPos.m_122022_((long)Long.parseLong((String)key));
            boolean value = activeBlockOriginsTag.m_128471_((String)key);
            this.activeBlockOrigins.put(pos, value);
        }
        this.maxSpreadReachedBlocks.clear();
        ListTag maxSpreadReachedBlocksList = tag.m_128437_("maxSpreadReachedBlocks", 4);
        for (Tag t : maxSpreadReachedBlocksList) {
            this.maxSpreadReachedBlocks.add(BlockPos.m_122022_((long)((LongTag)t).m_7046_()));
        }
        this.requeueCounters.clear();
        CompoundTag requeueCountersTag = tag.m_128469_("requeueCounters");
        for (String key : requeueCountersTag.m_128431_()) {
            BlockPos pos = BlockPos.m_122022_((long)Long.parseLong(key));
            int value = requeueCountersTag.m_128451_(key);
            this.requeueCounters.put(pos, value);
        }
        this.processedBlocks.clear();
        ListTag processedBlocksList = tag.m_128437_("processedBlocks", 10);
        for (int i = 0; i < processedBlocksList.size(); ++i) {
            this.processedBlocks.add(NbtUtils.m_129239_((CompoundTag)processedBlocksList.m_128728_(i)));
        }
        this.deferredProcessingQueue.clear();
        ListTag deferredProcessingQueueList = tag.m_128437_("deferredProcessingQueue", 4);
        for (Tag t : deferredProcessingQueueList) {
            this.deferredProcessingQueue.add(BlockPos.m_122022_((long)((LongTag)t).m_7046_()));
        }
        this.setCurrentPoints();
    }

    private int getCurrentPoints() {
        return FleshWorld.getPoints();
    }

    public void tick() {
        if (!this.level.m_8055_(this.origin).m_60713_((Block)TheFleshThatHatesModBlocks.FLESH_BLOCK.get())) {
            this.state = State.FINISHED;
            return;
        }
        if (!TFTHConfiguration.isFleshBlockSpreadEnabled()) {
            return;
        }
        if (this.tickCooldown > 0) {
            --this.tickCooldown;
            return;
        }
        this.setCurrentPoints();
        if (this.pointsHaveIncreased()) {
            this.recheckMaxSpreadBlocks();
        }
        if (this.isCooldown) {
            ++this.cooldownCounter;
            if (this.cooldownCounter >= TFTHConfiguration.getSpreadCooldown()) {
                this.cooldownCounter = 0;
                this.isCooldown = false;
            }
            return;
        }
        ++this.spreadCounter;
        if (this.spreadCounter >= TFTHConfiguration.getSpreadDuration()) {
            this.spreadCounter = 0;
            this.isCooldown = true;
            return;
        }
        if (this.spreadRateCounter < this.getSpreadRate()) {
            ++this.spreadRateCounter;
            return;
        }
        this.spreadRateCounter = 0;
        switch (this.state) {
            case IDLE: {
                this.idleTick();
                break;
            }
            case SEARCHING: {
                this.searchTick();
                break;
            }
        }
        int processedThisTick = 0;
        int maxBlocksPerTick = (Integer)TFTHConfiguration.NUMBEROFBLOCKS.get();
        while (!this.queue.isEmpty() && processedThisTick < maxBlocksPerTick) {
            Map.Entry<BlockPos, Double> entry = this.queue.poll();
            BlockPos currentBlock = entry.getKey();
            if (currentBlock.m_123331_((Vec3i)this.origin) > (double)(this.MAX_DISTANCE * this.MAX_DISTANCE)) {
                this.maxSpreadReachedBlocks.add(currentBlock);
                continue;
            }
            if (this.processedBlocks.contains(currentBlock)) continue;
            this.processBlock(currentBlock);
            ++processedThisTick;
            for (Direction dir : Direction.values()) {
                BlockPos nextBlock = currentBlock.m_121945_(dir);
                if (this.visitedPositions.contains(nextBlock.m_121878_()) || this.processedBlocks.contains(nextBlock)) continue;
                double distance = Math.sqrt(this.origin.m_123331_((Vec3i)nextBlock));
                double weight = 1.0 / (distance + 1.0);
                this.queue.add(new AbstractMap.SimpleEntry<BlockPos, Double>(nextBlock, weight));
                this.visitedPositions.add(nextBlock.m_121878_());
            }
        }
        this.tickCooldown = 1;
    }

    private void idleTick() {
        this.queue.add(new AbstractMap.SimpleEntry<BlockPos, Double>(this.origin, 1.0));
        this.state = State.SEARCHING;
    }

    private void searchTick() {
        int baseBlocksToReplace;
        if (!this.areIncubatorsNearby()) {
            return;
        }
        if (this.state == State.FINISHED || this.state == State.IDLE && !this.processedBlocks.isEmpty()) {
            this.processedBlocks.clear();
            this.processedBlocksCount = 0;
        }
        if (this.processedBlocksCount >= 1000) {
            this.state = State.FINISHED;
            return;
        }
        for (BlockPos activeBlock : this.activeSpreadBlocks) {
            boolean fromBelow = this.activeBlockOrigins.getOrDefault(activeBlock, false);
            if (!(activeBlock.m_123331_((Vec3i)this.origin) > (double)(this.CHECK_RADIUS * this.CHECK_RADIUS))) continue;
        }
        int blocksToReplace = baseBlocksToReplace = 1 + (int)(0.001 * (double)(this.currentPoints / 10));
        if (this.isNearIncubatorOne() || this.isPlaqueincubatorstartNearby()) {
            blocksToReplace += 1 + (int)(0.001 * (double)(this.currentPoints / 10));
        }
        block1: for (int i = 0; i < blocksToReplace; ++i) {
            if (this.queue.isEmpty()) {
                if (this.spreadState == SpreadState.LINES) {
                    this.spreadState = SpreadState.FILLING;
                    this.queue.add(new AbstractMap.SimpleEntry<BlockPos, Double>(this.origin, 1.0));
                    return;
                }
                this.state = State.FINISHED;
                return;
            }
            Map.Entry highestWeightEntry = this.queue.stream().max(Comparator.comparing(Map.Entry::getValue)).orElse(null);
            if (highestWeightEntry == null) {
                return;
            }
            BlockPos currentBlock = (BlockPos)highestWeightEntry.getKey();
            if (currentBlock.m_123331_((Vec3i)this.origin) > (double)(this.MAX_DISTANCE * this.MAX_DISTANCE)) {
                this.maxSpreadReachedBlocks.add(currentBlock);
                continue;
            }
            ArrayList<BlockPos> neighbors = this.spreadState == SpreadState.LINES ? BlockAlgorithms.getAdjacentNeighbors(currentBlock) : BlockAlgorithms.getNeighborsCube(currentBlock, this.origin, false);
            for (BlockPos neighbor : neighbors) {
                if (this.visitedPositions.contains(neighbor.m_121878_())) continue;
                this.processBlock(neighbor);
                if (this.hasIncreasedSpread) {
                    this.setActiveBlock(currentBlock);
                    this.hasIncreasedSpread = false;
                    continue block1;
                }
                PriorityQueue<Map.Entry> queue = new PriorityQueue<Map.Entry>(Comparator.comparingDouble(Map.Entry::getValue));
                for (Direction direction : Direction.values()) {
                    BlockPos adjacentBlock = currentBlock.m_121945_(direction);
                    double weight = this.calculateWeightForBlock(adjacentBlock, this.origin);
                    queue.add(new AbstractMap.SimpleEntry<BlockPos, Double>(adjacentBlock, weight));
                }
            }
        }
    }

    private int getSpreadRate() {
        int baseRate = this.INITIAL_SPREAD_RATE;
        if (this.areIncubatorsNearby()) {
            baseRate = this.INITIAL_SPREAD_RATE;
        }
        return baseRate;
    }

    private boolean isNearIncubatorOne() {
        AABB searchArea = new AABB(this.currentPosition).m_82400_((double)this.CHECK_RADIUS);
        return !this.level.m_45976_(PlaqueincubatoroneEntity.class, searchArea).isEmpty();
    }

    private boolean areIncubatorsNearby() {
        AABB searchArea = new AABB(this.currentPosition).m_82400_((double)this.CHECK_RADIUS);
        return !this.level.m_45976_(PlaqueincubatoroneEntity.class, searchArea).isEmpty() || !this.level.m_45976_(PlaqueincubatorstartEntity.class, searchArea).isEmpty();
    }

    private boolean isPlaqueincubatorstartNearby() {
        AABB searchArea = new AABB(this.currentPosition).m_82400_((double)this.CHECK_RADIUS);
        return !this.level.m_45976_(PlaqueincubatorstartEntity.class, searchArea).isEmpty();
    }

    private void spreadToSurface(BlockPos blockPos) {
        if (this.level.m_46859_(blockPos.m_7494_())) {
            float chance = new Random().nextFloat();
            int distanceFromOrigin = blockPos.m_123333_((Vec3i)this.origin);
            FStructures structures = new FStructures();
            if (chance < 0.02f) {
                int i;
                int numberOfTerns = new Random().nextInt(3) + 2;
                boolean canPlace = true;
                for (i = 1; i <= numberOfTerns; ++i) {
                    if (this.level.m_46859_(blockPos.m_6630_(i)) && this.level.m_8055_(blockPos.m_6630_(i)).m_60734_() != TheFleshThatHatesModBlocks.FLESH_TERNS.get()) continue;
                    canPlace = false;
                    break;
                }
                if (canPlace) {
                    for (i = 1; i <= numberOfTerns; ++i) {
                        this.level.m_7731_(blockPos.m_6630_(i), (BlockState)((Block)TheFleshThatHatesModBlocks.FLESH_TERNS.get()).m_49966_().m_61124_((Property)FleshTernsBlock.LEVEL, (Comparable)Integer.valueOf(i)), 3);
                    }
                }
            } else if (chance < 0.06f && this.level.m_46859_(blockPos.m_7494_()) && this.level.m_8055_(blockPos.m_7494_()).m_60734_() != TheFleshThatHatesModBlocks.FLESH_SMALL_GRASS.get()) {
                this.level.m_7731_(blockPos.m_7494_(), ((Block)TheFleshThatHatesModBlocks.FLESH_SMALL_GRASS.get()).m_49966_(), 3);
            } else if (chance < 0.08f && this.level.m_46859_(blockPos.m_7494_()) && this.level.m_8055_(blockPos.m_7494_()).m_60734_() != TheFleshThatHatesModBlocks.FLESH_GRASS.get()) {
                this.level.m_7731_(blockPos.m_7494_(), ((Block)TheFleshThatHatesModBlocks.FLESH_GRASS.get()).m_49966_(), 3);
            }
            this.lastPusPositions.putIfAbsent(blockPos, this.origin);
            this.lastMouthPositions.putIfAbsent(blockPos, this.origin);
            this.lastSpinePositions.putIfAbsent(blockPos, this.origin);
            this.lastTreePositions.putIfAbsent(blockPos, this.origin);
            if (TFTHConfiguration.isStructuresSpawnEnabled()) {
                BlockPos lastTreePos;
                BlockPos treeTargetPos;
                BlockPos lastSpinePos;
                BlockPos spineTargetPos;
                BlockPos lastMouthPos;
                BlockPos mouthTargetPos;
                BlockPos lastPusPos;
                BlockPos pusTargetPos;
                if ((double)chance < 6.0E-5 && !this.spawnedStructures.contains(pusTargetPos = blockPos.m_7494_()) && blockPos.m_123333_((Vec3i)(lastPusPos = this.lastPusPositions.getOrDefault(blockPos, this.origin))) >= 56) {
                    structures.spawnPus(this.level, blockPos);
                    this.lastPusPositions.put(blockPos, blockPos);
                    this.spawnedStructures.add(pusTargetPos);
                }
                if ((double)chance < 2.0E-5 && !this.spawnedStructures.contains(mouthTargetPos = blockPos.m_7494_()) && blockPos.m_123333_((Vec3i)(lastMouthPos = this.lastMouthPositions.getOrDefault(blockPos, this.origin))) >= 48) {
                    structures.spawnMouth(this.level, blockPos);
                    this.lastMouthPositions.put(blockPos, blockPos);
                    this.spawnedStructures.add(mouthTargetPos);
                }
                if ((double)chance < 3.0E-4 && !this.spawnedStructures.contains(spineTargetPos = blockPos.m_7494_()) && blockPos.m_123333_((Vec3i)(lastSpinePos = this.lastSpinePositions.getOrDefault(blockPos, this.origin))) >= 38) {
                    structures.spawnSpine(this.level, blockPos);
                    this.lastSpinePositions.put(blockPos, blockPos);
                    this.spawnedStructures.add(spineTargetPos);
                }
                if ((double)chance < 0.01 && !this.spawnedStructures.contains(treeTargetPos = blockPos.m_7494_()) && blockPos.m_123333_((Vec3i)(lastTreePos = this.lastTreePositions.getOrDefault(blockPos, this.origin))) >= 12) {
                    structures.spawnFleshTrees(this.level, blockPos);
                    this.lastTreePositions.put(blockPos, blockPos);
                    this.spawnedStructures.add(treeTargetPos);
                }
            }
        }
    }

    private boolean hasAirBlockAround(BlockPos pos) {
        BlockPos[] adjacentPositions;
        for (BlockPos adjacentPos : adjacentPositions = new BlockPos[]{new BlockPos(pos.m_123341_() - 1, pos.m_123342_(), pos.m_123343_()), new BlockPos(pos.m_123341_() + 1, pos.m_123342_(), pos.m_123343_()), new BlockPos(pos.m_123341_(), pos.m_123342_() - 1, pos.m_123343_()), new BlockPos(pos.m_123341_(), pos.m_123342_() + 1, pos.m_123343_()), new BlockPos(pos.m_123341_(), pos.m_123342_(), pos.m_123343_() - 1), new BlockPos(pos.m_123341_(), pos.m_123342_(), pos.m_123343_() + 1)}) {
            if (!this.level.m_46859_(adjacentPos)) continue;
            return true;
        }
        return false;
    }

    private double calculateWeightForBlock(BlockPos neighbor, BlockPos origin, int requeueCounter) {
        double baseWeight;
        double surfacePriority = 1.0;
        double heightDifference = neighbor.m_123342_() - origin.m_123342_();
        if (heightDifference < 0.0) {
            baseWeight = !this.hasAirBlockAround(neighbor) ? 0.0 : 1.0;
        } else if (heightDifference > 0.0) {
            baseWeight = 1.0;
            surfacePriority = 1.0;
        } else {
            baseWeight = 1.0;
        }
        double requeueDelay = requeueCounter * 2;
        return baseWeight * surfacePriority + requeueDelay;
    }

    private double calculateWeightForBlock(BlockPos neighbor, BlockPos origin) {
        return this.calculateWeightForBlock(neighbor, origin, 0);
    }

    private void setActiveBlock(BlockPos currentBlock) {
        boolean fromBelow = currentBlock.m_123342_() < this.origin.m_123342_();
        this.activeBlockOrigins.put(currentBlock, fromBelow);
        if (!this.activeSpreadBlocks.contains(currentBlock)) {
            this.activeSpreadBlocks.add(currentBlock);
        }
    }

    private void recheckMaxSpreadBlocks() {
        int newMaxDistanceSquared = this.MAX_DISTANCE * this.MAX_DISTANCE;
        Iterator<BlockPos> it = this.maxSpreadReachedBlocks.iterator();
        while (it.hasNext()) {
            BlockPos blockPos = it.next();
            if (!(blockPos.m_123331_((Vec3i)this.origin) <= (double)newMaxDistanceSquared)) continue;
            it.remove();
            double weight = this.calculateWeightForBlock(blockPos, this.origin);
            this.queue.add(new AbstractMap.SimpleEntry<BlockPos, Double>(blockPos, weight));
        }
    }

    private boolean pointsHaveIncreased() {
        int currentPoints = this.getCurrentPoints();
        boolean haveIncreased = currentPoints > this.lastCheckedPoints;
        this.lastCheckedPoints = currentPoints;
        return haveIncreased;
    }

    private void processBlock(BlockPos blockPos) {
        if (!this.areIncubatorsNearby()) {
            return;
        }
        if (this.processedBlocks.contains(blockPos)) {
            return;
        }
        BlockState neighborState = this.level.m_8055_(blockPos);
        if (BlockAlgorithms.isWoodenBlock(neighborState)) {
            this.replaceBlock(blockPos, ((Block)TheFleshThatHatesModBlocks.FLESH_TREE.get()).m_49966_());
        } else if (BlockAlgorithms.isLeafBlock(neighborState)) {
            this.replaceBlock(blockPos, ((Block)TheFleshThatHatesModBlocks.FLESH_FOLIAGE.get()).m_49966_());
        } else if (BlockAlgorithms.isStoneOrCobblestoneBlock(neighborState)) {
            this.replaceBlock(blockPos, ((Block)TheFleshThatHatesModBlocks.FLESH_COUBLESTONE.get()).m_49966_());
            this.spreadToSurface(blockPos);
        } else if (BlockAlgorithms.isSandBlock(neighborState)) {
            this.replaceBlock(blockPos, ((Block)TheFleshThatHatesModBlocks.FLESH_SAND.get()).m_49966_());
            this.spreadToSurface(blockPos);
        } else if (BlockAlgorithms.isBrickBlock(neighborState)) {
            this.replaceBlock(blockPos, ((Block)TheFleshThatHatesModBlocks.FLESH_BRICKS.get()).m_49966_());
            this.spreadToSurface(blockPos);
        } else if (BlockAlgorithms.isWoodenPlankBlock(neighborState)) {
            this.replaceBlock(blockPos, ((Block)TheFleshThatHatesModBlocks.FLESH_PLANK.get()).m_49966_());
            this.spreadToSurface(blockPos);
        } else if (BlockAlgorithms.isLiquidBlock(neighborState)) {
            this.replaceBlock(blockPos, ((Block)TheFleshThatHatesModBlocks.PUS.get()).m_49966_());
        } else if (BlockAlgorithms.canBeReplacedByFleshBlock(neighborState, (Block)TheFleshThatHatesModBlocks.TUMOR.get())) {
            this.replaceBlock(blockPos, ((Block)TheFleshThatHatesModBlocks.TUMOR.get()).m_49966_());
            this.spreadToSurface(blockPos);
        } else if (BlockAlgorithms.canBeReplacedByFleshBlock(neighborState)) {
            this.replaceBlockWithFlesh(blockPos);
        } else if (BlockAlgorithms.canBeReplacedByFleshBlock(neighborState, (Block)TheFleshThatHatesModBlocks.TUMOR.get())) {
            this.replaceBlock(blockPos, ((Block)TheFleshThatHatesModBlocks.TUMOR.get()).m_49966_());
            this.processedBlocks.add(blockPos);
            this.visitedPositions.add(blockPos.m_121878_());
            ++this.processedBlocksCount;
        }
    }

    private void spawnBloodParticles(ServerLevel serverLevel, BlockPos pos) {
        for (int i = 0; i < 6; ++i) {
            double offsetX = Math.random() * 0.5 - 0.25;
            double offsetY = 1.25;
            double offsetZ = Math.random() * 0.5 - 0.25;
            serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)TheFleshThatHatesModParticleTypes.BLOOD.get()), (double)pos.m_123341_() + 0.5 + offsetX, (double)pos.m_123342_() + offsetY, (double)pos.m_123343_() + 0.5 + offsetZ, 0, 0.0, 0.0, 0.0, 0.1);
        }
    }

    private void replaceBlock(BlockPos blockPos, BlockState newBlockState) {
        if (this.hasAirBlockAround(blockPos) || blockPos.m_123342_() > this.origin.m_123342_()) {
            this.level.m_7731_(blockPos, (BlockState)newBlockState.m_61124_((Property)FleshBlockBlock.SPREAD, (Comparable)Boolean.valueOf(true)), 3);
            this.queue.add(new AbstractMap.SimpleEntry<BlockPos, Double>(blockPos, this.calculateWeightForBlock(blockPos, this.origin)));
            this.visitedPositions.add(blockPos.m_121878_());
            this.setActiveBlock(blockPos);
            this.maxSpreadReachedBlocks.remove(blockPos);
            this.spawnBloodParticles(this.level, blockPos);
            this.level.m_5594_(null, blockPos, (SoundEvent)TheFleshThatHatesModSounds.INFECTION_BLOCK.get(), SoundSource.BLOCKS, 0.6f, 1.0f);
        }
    }

    private void replaceBlockWithFlesh(BlockPos blockPos) {
        if (this.hasAirBlockAround(blockPos) || blockPos.m_123342_() > this.origin.m_123342_()) {
            this.level.m_7731_(blockPos, (BlockState)((Block)TheFleshThatHatesModBlocks.FLESH_BLOCK.get()).m_49966_().m_61124_((Property)FleshBlockBlock.SPREAD, (Comparable)Boolean.valueOf(true)), 3);
            double weight = this.calculateWeightForBlock(blockPos, this.origin);
            this.visitedPositions.add(blockPos.m_121878_());
            this.spreadToSurface(blockPos);
            this.setActiveBlock(blockPos);
            this.queue.add(new AbstractMap.SimpleEntry<BlockPos, Double>(blockPos, weight));
            this.spawnBloodParticles(this.level, blockPos);
            this.level.m_5594_(null, blockPos, (SoundEvent)TheFleshThatHatesModSounds.INFECTION_BLOCK.get(), SoundSource.BLOCKS, 0.6f, 1.0f);
        }
    }

    static enum State {
        IDLE,
        SEARCHING,
        FINISHED;

    }

    static enum SpreadState {
        LINES,
        FILLING,
        FINISHED;

    }

    static enum StructureType {
        PUS,
        MOUTH,
        SPINE,
        TREE;

    }
}

