/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.thefleshthathates;

import net.mcreator.thefleshthathates.FConfig.TFTHConfiguration;
import net.mcreator.thefleshthathates.block.FleshBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class FleshRenderBiome {
    private static int tickCounter = 0;
    private static final int SOME_THRESHOLD = 2;
    private static final int MAX_RADIUS = 30;
    private static final double FOG_START_DISTANCE = 2.0;
    private static final double MAX_FOG_APPEARANCE_DISTANCE = 4.0;
    private static final int MAX_IMPACT_BLOCKS = 30;
    private static boolean isNearFleshBlocks = false;
    private static float fleshBlockDensity = 0.0f;
    private static double nearestFleshBlockDistance = Double.MAX_VALUE;

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (!TFTHConfiguration.isFleshRenderBiomeEnabled()) {
            return;
        }
        if (event.player.m_9236_().f_46443_ && event.phase == TickEvent.Phase.START && ++tickCounter >= 40) {
            FleshRenderBiome.checkAndUpdateFog(event.player);
            tickCounter = 0;
        }
    }

    private static void checkAndUpdateFog(Player player) {
        Level level = player.m_9236_();
        BlockPos playerPos = player.m_20183_();
        int radius = 30;
        int fleshBlockCount = 0;
        nearestFleshBlockDistance = Double.MAX_VALUE;
        for (BlockPos pos : BlockPos.m_121940_((BlockPos)playerPos.m_7918_(-radius, -radius, -radius), (BlockPos)playerPos.m_7918_(radius, radius, radius))) {
            Block block = level.m_8055_(pos).m_60734_();
            if (!FleshBlocks.isModBlock(block)) continue;
            ++fleshBlockCount;
            double distance = pos.m_123331_((Vec3i)playerPos);
            if (!(distance < nearestFleshBlockDistance)) continue;
            nearestFleshBlockDistance = distance;
        }
        isNearFleshBlocks = fleshBlockCount > 2 && nearestFleshBlockDistance <= 72.0;
        fleshBlockDensity = fleshBlockCount > 30 ? 1.0f : (float)fleshBlockCount / 30.0f;
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void onRenderFogEvent(ViewportEvent.RenderFog event) {
        if (isNearFleshBlocks) {
            double distance = Math.sqrt(nearestFleshBlockDistance);
            double distanceFactor = Math.max(0.0, 1.0 - distance / 4.0);
            float farPlane = (float)(50.0 * (1.5 - (double)fleshBlockDensity * distanceFactor));
            float nearPlane = (float)(2.0 + (double)(10.0f * fleshBlockDensity) * distanceFactor);
            event.setNearPlaneDistance(nearPlane);
            event.setFarPlaneDistance(farPlane);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void onComputeFogColorEvent(ViewportEvent.ComputeFogColor event) {
        if (isNearFleshBlocks) {
            double distance = Math.sqrt(nearestFleshBlockDistance);
            float distanceFactor = (float)Math.max(0.0, 1.0 - distance / 4.0);
            float red = 0.2f;
            float green = 0.047058824f;
            float blue = 0.03529412f;
            event.setRed(red);
            event.setGreen(green);
            event.setBlue(blue);
        }
    }
}

