/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.thefleshthathates;

import net.mcreator.thefleshthathates.FEvents.FleshWorld;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class FleshWorldData
extends SavedData {
    public static final String DATA_NAME = "TheFleshThatHates_FleshWorldData";
    private int points = 0;
    private int tickCounter1;
    private int tickCounter2;
    private int plaqueIncubatorStartDeathCounter;
    private int plaqueIncubatorOneDeathCounter;
    private boolean incubatorHibernated;
    private int summonCooldown;
    private int killedCreaturesCount;
    private String currentStageString = "FETAL_STAGE";

    public int getTickCounter1() {
        return this.tickCounter1;
    }

    public void setTickCounter1(int value) {
        this.tickCounter1 = value;
        this.m_77762_();
    }

    public int getTickCounter2() {
        return this.tickCounter2;
    }

    public void setTickCounter2(int value) {
        this.tickCounter2 = value;
        this.m_77762_();
    }

    public int getPlaqueIncubatorStartDeathCounter() {
        return this.plaqueIncubatorStartDeathCounter;
    }

    public void setPlaqueIncubatorStartDeathCounter(int value) {
        this.plaqueIncubatorStartDeathCounter = value;
        this.m_77762_();
    }

    public int getPlaqueIncubatorOneDeathCounter() {
        return this.plaqueIncubatorOneDeathCounter;
    }

    public void setPlaqueIncubatorOneDeathCounter(int value) {
        this.plaqueIncubatorOneDeathCounter = value;
        this.m_77762_();
    }

    public boolean isIncubatorHibernated() {
        return this.incubatorHibernated;
    }

    public void setIncubatorHibernated(boolean value) {
        this.incubatorHibernated = value;
        this.m_77762_();
    }

    public int getSummonCooldown() {
        return this.summonCooldown;
    }

    public void setSummonCooldown(int value) {
        this.summonCooldown = value;
        this.m_77762_();
    }

    public int getKilledCreaturesCount() {
        return this.killedCreaturesCount;
    }

    public void setKilledCreaturesCount(int count) {
        this.killedCreaturesCount = count;
        this.m_77762_();
    }

    public int getPoints() {
        return this.points;
    }

    public void setPoints(int points) {
        this.points = points;
        this.m_77762_();
    }

    public void load(CompoundTag nbt) {
        this.points = nbt.m_128451_("points");
        this.currentStageString = nbt.m_128461_("currentStage");
        this.tickCounter1 = nbt.m_128451_("tickCounter1");
        this.tickCounter2 = nbt.m_128451_("tickCounter2");
        this.plaqueIncubatorStartDeathCounter = nbt.m_128451_("plaqueIncubatorStartDeathCounter");
        this.plaqueIncubatorOneDeathCounter = nbt.m_128451_("plaqueIncubatorOneDeathCounter");
        this.incubatorHibernated = nbt.m_128471_("incubatorHibernated");
        this.summonCooldown = nbt.m_128451_("summonCooldown");
        this.killedCreaturesCount = nbt.m_128451_("killedCreaturesCount");
    }

    public CompoundTag m_7176_(CompoundTag nbt) {
        nbt.m_128405_("points", this.points);
        nbt.m_128359_("currentStage", this.currentStageString);
        nbt.m_128405_("tickCounter1", this.tickCounter1);
        nbt.m_128405_("tickCounter2", this.tickCounter2);
        nbt.m_128405_("plaqueIncubatorStartDeathCounter", this.plaqueIncubatorStartDeathCounter);
        nbt.m_128405_("plaqueIncubatorOneDeathCounter", this.plaqueIncubatorOneDeathCounter);
        nbt.m_128379_("incubatorHibernated", this.incubatorHibernated);
        nbt.m_128405_("summonCooldown", this.summonCooldown);
        nbt.m_128405_("killedCreaturesCount", this.killedCreaturesCount);
        return nbt;
    }

    public FleshWorld.FleshStage getCurrentStage() {
        return FleshWorld.FleshStage.valueOf(this.currentStageString);
    }

    public void setCurrentStage(FleshWorld.FleshStage stage) {
        if (stage == null) {
            return;
        }
        this.currentStageString = stage.name();
        this.m_77762_();
    }

    public static FleshWorldData get(MinecraftServer server) {
        if (server == null) {
            return null;
        }
        ServerLevel overworld = server.m_129880_(ServerLevel.f_46428_);
        if (overworld == null) {
            return null;
        }
        return (FleshWorldData)overworld.m_8895_().m_164861_(nbt -> {
            FleshWorldData data = new FleshWorldData();
            data.load((CompoundTag)nbt);
            return data;
        }, () -> new FleshWorldData(), DATA_NAME);
    }

    @SubscribeEvent
    public static void onServerStarting(ServerStartingEvent event) {
        ServerLevel overworld;
        MinecraftServer server = event.getServer();
        FleshWorldData data = FleshWorldData.get(server);
        if (data != null && (overworld = server.m_129880_(ServerLevel.f_46428_)) != null) {
            FleshWorld.setPoints(data.getPoints(), (Level)overworld);
            if (data.getCurrentStage() != null) {
                FleshWorld.setCurrentStage(data.getCurrentStage(), (Level)overworld);
            }
        }
    }
}

