/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.thefleshthathates;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.stream.StreamSupport;
import net.mcreator.thefleshthathates.AwarenessStageMobs;
import net.mcreator.thefleshthathates.FConfig.TFTHConfiguration;
import net.mcreator.thefleshthathates.FEvents.FleshWorld;
import net.mcreator.thefleshthathates.GermStageMobs;
import net.mcreator.thefleshthathates.block.entity.fleshtype.FleshMValue;
import net.mcreator.thefleshthathates.init.TheFleshThatHatesModBlocks;
import net.mcreator.thefleshthathates.init.TheFleshThatHatesModEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityLeaveLevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class IncubatorMobSpawn {
    private static final int SPAWN_INTERVAL = 1200;
    private static final int PLAYER_SEARCH_RADIUS = 100;
    private static final int SPAWN_RADIUS_START = 75;
    private static final int SPAWN_RADIUS_ONE = 125;
    private static final int PLAYER_RADIUS = 150;
    private static final int SPAWN_INTERVAL_FLESH_SERVANT = 1300;
    private static final int MIN_DISTANCE_BETWEEN_FLESH_SERVANTS = 4;
    private static final int SPAWN_DISTANCE_FROM_INCUBATOR_START = 5;
    private static final int SPAWN_DISTANCE_FROM_INCUBATOR_ONE = 6;
    private static Map<UUID, Integer> spawnedEntityCounts = new HashMap<UUID, Integer>();
    private static Set<UUID> activeIncubators = new HashSet<UUID>();

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (event.getServer().m_129921_() % TFTHConfiguration.getSpawnInterval() == 0) {
            for (ServerLevel world : event.getServer().m_129785_()) {
                IncubatorMobSpawn.checkForIncubators(world);
                IncubatorMobSpawn.spawnEntitiesNearActiveIncubators(world);
            }
        }
        if (event.getServer().m_129921_() % 1300 == 0) {
            for (ServerLevel world : event.getServer().m_129785_()) {
                IncubatorMobSpawn.spawnFleshServantsNearIncubators(world);
            }
        }
    }

    @SubscribeEvent
    public static void onEntityLeaveLevel(EntityLeaveLevelEvent event) {
        LivingEntity entity;
        if (event.getEntity() instanceof LivingEntity && ((entity = (LivingEntity)event.getEntity()).m_6095_() == TheFleshThatHatesModEntities.PLAQUEINCUBATORSTART.get() || entity.m_6095_() == TheFleshThatHatesModEntities.PLAQUEINCUBATORONE.get())) {
            activeIncubators.remove(entity.m_20148_());
            spawnedEntityCounts.remove(entity.m_20148_());
        }
    }

    private static void checkForIncubators(ServerLevel world) {
        for (LivingEntity player : world.m_6907_()) {
            AABB area = new AABB(player.m_20183_()).m_82377_(150.0, 150.0, 150.0);
            List incubators = world.m_6443_(LivingEntity.class, area, entity -> entity != null && (entity.m_6095_() == TheFleshThatHatesModEntities.PLAQUEINCUBATORSTART.get() || entity.m_6095_() == TheFleshThatHatesModEntities.PLAQUEINCUBATORONE.get()));
            for (LivingEntity incubator : incubators) {
                activeIncubators.add(incubator.m_20148_());
            }
        }
    }

    private static int countSpawnedEntitiesByIncubator(ServerLevel world, UUID incubatorId, EntityType<?> specificType) {
        return (int)StreamSupport.stream(world.m_8583_().spliterator(), false).filter(entity -> entity.m_6095_() == specificType).filter(entity -> entity.getPersistentData().m_128441_("SpawnedByIncubator")).filter(entity -> UUID.fromString(entity.getPersistentData().m_128461_("SpawnedByIncubator")).equals(incubatorId)).count();
    }

    private static void spawnFleshServantsNearIncubators(ServerLevel world) {
        if (FleshWorld.getCurrentStage() == FleshWorld.FleshStage.FETAL_STAGE) {
            return;
        }
        for (UUID incubatorId : activeIncubators) {
            int maxAllowed;
            Entity entity = world.m_8791_(incubatorId);
            if (!(entity instanceof LivingEntity)) continue;
            LivingEntity incubator = (LivingEntity)entity;
            int currentCount = IncubatorMobSpawn.countSpawnedEntitiesByIncubator(world, incubatorId, (EntityType)TheFleshThatHatesModEntities.FLESH_SERVANT.get());
            if (currentCount >= (maxAllowed = incubator.m_6095_() == TheFleshThatHatesModEntities.PLAQUEINCUBATORSTART.get() ? 2 : 4)) continue;
            IncubatorMobSpawn.spawnEntityAtSafeDistance(world, incubator, (EntityType)TheFleshThatHatesModEntities.FLESH_SERVANT.get(), incubator.m_6095_() == TheFleshThatHatesModEntities.PLAQUEINCUBATORSTART.get() ? 5 : 6);
        }
    }

    private static void spawnEntityAtSafeDistance(ServerLevel world, LivingEntity incubator, EntityType<?> entityType, int spawnDistance) {
        ArrayList<BlockPos> potentialPositions = new ArrayList<BlockPos>();
        for (int tries = 100; tries > 0; --tries) {
            BlockPos randomPos = incubator.m_20183_().m_7918_(world.f_46441_.m_188503_(2 * spawnDistance) - spawnDistance, 0, world.f_46441_.m_188503_(2 * spawnDistance) - spawnDistance);
            BlockPos highestFleshBlock = IncubatorMobSpawn.findHighestFleshBlock(world, randomPos);
            if (highestFleshBlock == null || IncubatorMobSpawn.isOtherServantNearby(world, highestFleshBlock, 3.0)) continue;
            potentialPositions.add(highestFleshBlock.m_7494_());
        }
        if (!potentialPositions.isEmpty()) {
            BlockPos spawnPos = (BlockPos)potentialPositions.get(world.f_46441_.m_188503_(potentialPositions.size()));
            Entity entity = entityType.m_20615_((Level)world);
            if (entity != null) {
                entity.m_7678_((double)spawnPos.m_123341_() + 0.5, (double)spawnPos.m_123342_(), (double)spawnPos.m_123343_() + 0.5, world.f_46441_.m_188501_() * 360.0f, 0.0f);
                entity.getPersistentData().m_128359_("SpawnedByIncubator", incubator.m_20148_().toString());
                if (world.m_7967_(entity)) {
                    // empty if block
                }
            }
        }
    }

    private static boolean isOtherServantNearby(ServerLevel world, BlockPos pos, double radius) {
        AABB area = new AABB(pos).m_82400_(radius);
        return !world.m_6443_(LivingEntity.class, area, entity -> entity.m_6095_() == TheFleshThatHatesModEntities.FLESH_SERVANT.get()).isEmpty();
    }

    private static BlockPos findHighestFleshBlock(ServerLevel world, BlockPos pos) {
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        mutablePos.m_122190_((Vec3i)pos);
        while (world.m_8055_((BlockPos)mutablePos).m_60734_() == TheFleshThatHatesModBlocks.FLESH_BLOCK.get()) {
            mutablePos.m_122184_(0, 1, 0);
        }
        mutablePos.m_122184_(0, -1, 0);
        return world.m_8055_((BlockPos)mutablePos).m_60734_() == TheFleshThatHatesModBlocks.FLESH_BLOCK.get() ? mutablePos.m_7949_() : null;
    }

    private static void spawnEntitiesNearActiveIncubators(ServerLevel world) {
        for (UUID incubatorId : activeIncubators) {
            int numEntitiesToSpawn;
            Entity entity = world.m_8791_(incubatorId);
            if (!(entity instanceof LivingEntity)) continue;
            LivingEntity incubator = (LivingEntity)entity;
            spawnedEntityCounts.putIfAbsent(incubatorId, 0);
            int currentSpawnedCount = IncubatorMobSpawn.countSpawnedEntitiesByIncubator(world, incubatorId);
            spawnedEntityCounts.put(incubatorId, currentSpawnedCount);
            int maxEntities = incubator.m_6095_() == TheFleshThatHatesModEntities.PLAQUEINCUBATORSTART.get() ? TFTHConfiguration.getMaxMobsGermStage() : TFTHConfiguration.getMaxMobsAwarenessStage();
            int n = numEntitiesToSpawn = incubator.m_6095_() == TheFleshThatHatesModEntities.PLAQUEINCUBATORSTART.get() ? TFTHConfiguration.germmobspawnincub() : TFTHConfiguration.awarenessmobspawnincub();
            if (spawnedEntityCounts.get(incubatorId) >= maxEntities) continue;
            for (int i = 0; i < numEntitiesToSpawn; ++i) {
                EntityType<?> entityTypeToSpawn = IncubatorMobSpawn.chooseEntityType(world, incubator.m_6095_());
                if (entityTypeToSpawn == null || incubator.m_6095_() != TheFleshThatHatesModEntities.PLAQUEINCUBATORONE.get() && !FleshMValue.canSpawn(entityTypeToSpawn, FleshWorld.getPoints())) continue;
                IncubatorMobSpawn.spawnEntity(world, incubator, entityTypeToSpawn);
                spawnedEntityCounts.compute(incubatorId, (key, val) -> val + 1);
            }
        }
    }

    private static EntityType<?> chooseEntityType(ServerLevel world, EntityType<?> incubatorType) {
        if (FleshWorld.getCurrentStage() == FleshWorld.FleshStage.FETAL_STAGE && incubatorType == TheFleshThatHatesModEntities.PLAQUEINCUBATORSTART.get()) {
            if (IncubatorMobSpawn.countSpawnedEntitiesByIncubator(world, incubatorType, (EntityType)TheFleshThatHatesModEntities.PLAQUECONTAMINATOR.get()) < 6) {
                return (EntityType)TheFleshThatHatesModEntities.PLAQUECONTAMINATOR.get();
            }
            return null;
        }
        if (incubatorType == TheFleshThatHatesModEntities.PLAQUEINCUBATORSTART.get()) {
            return GermStageMobs.ENTITY_TYPES.stream().skip(new Random().nextInt(GermStageMobs.ENTITY_TYPES.size())).findFirst().orElse(null);
        }
        if (incubatorType == TheFleshThatHatesModEntities.PLAQUEINCUBATORONE.get()) {
            return AwarenessStageMobs.ENTITY_TYPES.stream().skip(new Random().nextInt(AwarenessStageMobs.ENTITY_TYPES.size())).findFirst().orElse(null);
        }
        return null;
    }

    private static int countSpawnedEntitiesByIncubator(ServerLevel world, UUID incubatorId) {
        int count = 0;
        for (Entity entity : world.m_8583_()) {
            if (!entity.getPersistentData().m_128441_("SpawnedByIncubator") || !UUID.fromString(entity.getPersistentData().m_128461_("SpawnedByIncubator")).equals(incubatorId)) continue;
            ++count;
        }
        return count;
    }

    private static int countSpawnedEntitiesByIncubator(ServerLevel world, EntityType<?> incubatorType, EntityType<?> specificType) {
        return (int)StreamSupport.stream(world.m_8583_().spliterator(), false).filter(entity -> entity.m_6095_() == specificType).filter(entity -> entity.getPersistentData().m_128441_("SpawnedByIncubatorType")).filter(entity -> entity.getPersistentData().m_128441_("SpawnedByIncubator")).count();
    }

    private static void spawnEntity(ServerLevel world, LivingEntity incubator, EntityType<?> entityType) {
        BlockPos spawnPos = IncubatorMobSpawn.getRandomFleshBlockPosition(world, incubator);
        if (spawnPos == null) {
            return;
        }
        BlockPos aboveFleshBlock = spawnPos.m_7494_();
        Entity entity = entityType.m_20615_((Level)world);
        entity.m_7678_((double)aboveFleshBlock.m_123341_() + 0.5, (double)aboveFleshBlock.m_123342_(), (double)aboveFleshBlock.m_123343_() + 0.5, world.f_46441_.m_188501_() * 360.0f, 0.0f);
        entity.getPersistentData().m_128359_("SpawnedByIncubator", incubator.m_20148_().toString());
        entity.getPersistentData().m_128359_("SpawnedByIncubatorType", EntityType.m_20613_((EntityType)incubator.m_6095_()).toString());
        world.m_7967_(entity);
    }

    private static BlockPos getRandomFleshBlockPosition(ServerLevel world, LivingEntity incubator) {
        int radius = incubator.m_6095_() == TheFleshThatHatesModEntities.PLAQUEINCUBATORSTART.get() ? 75 : 125;
        int verticalRadius = 20;
        ArrayList<BlockPos> potentialPositions = new ArrayList<BlockPos>();
        BlockPos.MutableBlockPos blockPos = new BlockPos.MutableBlockPos();
        for (int x = -radius; x <= radius; ++x) {
            for (int y = -verticalRadius; y <= verticalRadius; ++y) {
                for (int z = -radius; z <= radius; ++z) {
                    BlockPos aboveBlockPos;
                    blockPos.m_122178_(incubator.m_20183_().m_123341_() + x, incubator.m_20183_().m_123342_() + y, incubator.m_20183_().m_123343_() + z);
                    if (world.m_8055_((BlockPos)blockPos).m_60734_() != TheFleshThatHatesModBlocks.FLESH_BLOCK.get() || !world.m_46859_(aboveBlockPos = blockPos.m_7494_()) || !world.m_46859_(aboveBlockPos.m_122012_()) || !world.m_46859_(aboveBlockPos.m_122019_()) || !world.m_46859_(aboveBlockPos.m_122029_()) || !world.m_46859_(aboveBlockPos.m_122024_())) continue;
                    potentialPositions.add(blockPos.m_7949_());
                }
            }
        }
        if (potentialPositions.isEmpty()) {
            return null;
        }
        return (BlockPos)potentialPositions.get(world.f_46441_.m_188503_(potentialPositions.size()));
    }
}

