/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.thefleshthathates;

import java.util.List;
import net.mcreator.thefleshthathates.FConfig.TFTHConfiguration;
import net.mcreator.thefleshthathates.FEvents.FleshWorld;
import net.mcreator.thefleshthathates.FleshWorldData;
import net.mcreator.thefleshthathates.block.FleshBlockBlock;
import net.mcreator.thefleshthathates.entity.PlaqueincubatoroneEntity;
import net.mcreator.thefleshthathates.entity.PlaqueincubatorstartEntity;
import net.mcreator.thefleshthathates.init.TheFleshThatHatesModBlocks;
import net.mcreator.thefleshthathates.init.TheFleshThatHatesModEntities;
import net.mcreator.thefleshthathates.init.TheFleshThatHatesModSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class IncubatorSpawn {
    private static int tickCounter1 = 0;
    private static int tickCounter2 = 0;
    private static int plaqueIncubatorStartDeathCounter = 0;
    private static int plaqueIncubatorOneDeathCounter = 0;
    private static boolean incubatorHibernated = false;

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        FleshWorld.FleshStage currentStage;
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        MinecraftServer server = event.getServer();
        FleshWorldData data = FleshWorldData.get(server);
        data.setTickCounter1(data.getTickCounter1() + 1);
        data.setTickCounter2(data.getTickCounter2() + 1);
        if (data.getPlaqueIncubatorStartDeathCounter() > 0) {
            data.setPlaqueIncubatorStartDeathCounter(data.getPlaqueIncubatorStartDeathCounter() - 1);
        }
        if (data.getPlaqueIncubatorOneDeathCounter() > 0) {
            data.setPlaqueIncubatorOneDeathCounter(data.getPlaqueIncubatorOneDeathCounter() - 1);
        }
        if ((currentStage = FleshWorld.getCurrentStage()) == null || currentStage.ordinal() < FleshWorld.FleshStage.FETAL_STAGE.ordinal()) {
            return;
        }
        Iterable allWorlds = event.getServer().m_129785_();
        for (ServerLevel world : allWorlds) {
            for (Player player : world.m_6907_()) {
                if (data.getTickCounter1() % TFTHConfiguration.getIncubatorSpawnTime() == 0) {
                    IncubatorSpawn.processFirstTickEvent(world, player, data);
                }
                if (data.getTickCounter2() % 6400 != 0) continue;
                IncubatorSpawn.processSecondTickEvent(world, player, data);
            }
        }
    }

    private static boolean hasNearbyIncubators(ServerLevel world, double x, double y, double z, double radius) {
        AABB searchArea = new AABB(x - radius, y - radius, z - radius, x + radius, y + radius, z + radius);
        List nearbyEntities = world.m_45933_((Entity)null, searchArea);
        return nearbyEntities.stream().anyMatch(entity -> entity instanceof PlaqueincubatorstartEntity || entity instanceof PlaqueincubatoroneEntity);
    }

    @SubscribeEvent
    public static void onEntityDeath(LivingDeathEvent event) {
        LivingEntity entity = event.getEntity();
        if (!(entity.m_9236_() instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)entity.m_9236_();
        MinecraftServer server = serverLevel.m_7654_();
        FleshWorldData data = FleshWorldData.get(server);
        if (entity instanceof PlaqueincubatorstartEntity) {
            data.setPlaqueIncubatorStartDeathCounter(TFTHConfiguration.getGermIncubNotSpawn());
        } else if (entity instanceof PlaqueincubatoroneEntity) {
            data.setPlaqueIncubatorStartDeathCounter(TFTHConfiguration.getGermIncubNotSpawn());
        }
    }

    private static void processFirstTickEvent(ServerLevel world, Player player, FleshWorldData data) {
        if (!TFTHConfiguration.isIncubatorSpawnEnabled()) {
            return;
        }
        ResourceKey levelKey = world.m_46472_();
        String dimensionId = levelKey.m_135782_().toString();
        if (((List)TFTHConfiguration.INCUBATOR_DIMENSION_BLACKLIST.get()).contains(dimensionId)) {
            return;
        }
        if (data.getPlaqueIncubatorStartDeathCounter() <= 0 && FleshWorld.getCurrentStage().ordinal() >= FleshWorld.FleshStage.FETAL_STAGE.ordinal()) {
            int z;
            int y;
            int xRandomRange = TFTHConfiguration.getIncubatorSpawnXRandomRange();
            int xOffset = TFTHConfiguration.getIncubatorSpawnXOffset();
            int zRandomRange = TFTHConfiguration.getIncubatorSpawnZRandomRange();
            int zOffset = TFTHConfiguration.getIncubatorSpawnZOffset();
            int x = (int)(player.m_20185_() + (double)world.f_46441_.m_188503_(xRandomRange) - (double)xOffset);
            BlockPos blockPos = new BlockPos(x, y = world.m_6924_(Heightmap.Types.WORLD_SURFACE, x, z = (int)(player.m_20189_() + (double)world.f_46441_.m_188503_(zRandomRange) - (double)zOffset)), z);
            if (!world.m_6425_(blockPos).m_76178_() || !world.m_6425_(blockPos.m_7495_()).m_76178_()) {
                return;
            }
            if (!IncubatorSpawn.hasNearbyIncubators(world, x, y, z, TFTHConfiguration.incubatormaxtonextspawn())) {
                IncubatorSpawn.spawnIncubatorStart(world, x, y, z, data);
            }
        }
    }

    private static void spawnIncubatorStart(ServerLevel world, double x, double y, double z, FleshWorldData data) {
        BlockPos spawnPos = new BlockPos((int)Math.floor(x), (int)Math.floor(y), (int)Math.floor(z));
        System.out.println("[DEBUG] Attempting to spawn at: " + spawnPos);
        if (!IncubatorSpawn.isAreaClearForSpawn(world, spawnPos) || IncubatorSpawn.isNearAnyPlayerRespawnPoint(world, spawnPos)) {
            return;
        }
        PlaqueincubatorstartEntity incubatorStart = (PlaqueincubatorstartEntity)((EntityType)TheFleshThatHatesModEntities.PLAQUEINCUBATORSTART.get()).m_20615_((Level)world);
        incubatorStart.m_7678_(x, y, z, world.f_46441_.m_188501_() * 360.0f, 0.0f);
        world.m_7967_((Entity)incubatorStart);
        BlockPos belowIncubator = new BlockPos((int)x, (int)y - 1, (int)z);
        BlockState fleshBlockState = ((Block)TheFleshThatHatesModBlocks.FLESH_BLOCK.get()).m_49966_();
        if (fleshBlockState.m_60734_() instanceof FleshBlockBlock) {
            ((FleshBlockBlock)fleshBlockState.m_60734_()).setShouldSpread(true);
        }
        world.m_7731_(belowIncubator, fleshBlockState, 3);
        SoundEvent sound = (SoundEvent)TheFleshThatHatesModSounds.INCSTART_SPAWN.get();
        IncubatorSpawn.playSoundToNearbyPlayers(world, x, y, z, 500.0, sound, 1.0f, 1.0f);
        if (data.isIncubatorHibernated()) {
            if (data.getPlaqueIncubatorStartDeathCounter() > 0) {
                data.setPlaqueIncubatorStartDeathCounter(data.getPlaqueIncubatorStartDeathCounter() - 1200);
            } else {
                data.setIncubatorHibernated(false);
            }
        }
    }

    private static void processSecondTickEvent(ServerLevel world, Player player, FleshWorldData data) {
        if (!TFTHConfiguration.isIncubatorSpawnEnabled()) {
            return;
        }
        if (plaqueIncubatorOneDeathCounter <= 0) {
            AABB searchArea = player.m_20191_().m_82400_(300.0);
            List nearbyEntities = world.m_45933_((Entity)player, searchArea);
            boolean bl = nearbyEntities.stream().anyMatch(entity -> entity instanceof PlaqueincubatoroneEntity);
        }
    }

    private static void playSoundToNearbyPlayers(ServerLevel world, double x, double y, double z, double radius, SoundEvent sound, float volume, float pitch) {
        AABB searchArea = new AABB(x - radius, y - radius, z - radius, x + radius, y + radius, z + radius);
        List nearbyPlayers = world.m_45976_(Player.class, searchArea);
        for (Player nearbyPlayer : nearbyPlayers) {
            double distanceToPlayer = Math.sqrt(nearbyPlayer.m_20275_(x, y, z));
            if (!(distanceToPlayer <= radius)) continue;
            nearbyPlayer.m_6330_(sound, SoundSource.PLAYERS, volume, pitch);
        }
    }

    private static boolean isAreaClearForSpawn(ServerLevel world, BlockPos spawnPos) {
        for (int i = 0; i < 3; ++i) {
            BlockPos checkPos = spawnPos.m_6630_(i);
            if (world.m_46859_(checkPos)) continue;
            return false;
        }
        return true;
    }

    private static boolean isNearAnyPlayerRespawnPoint(ServerLevel world, BlockPos spawnPos) {
        double minimumDistance = (Double)TFTHConfiguration.PLAYER_SPAWNPOINTS_NOT_SPAWN.get();
        for (ServerPlayer player : world.m_6907_()) {
            double distance;
            BlockPos playerRespawnPoint = player.m_8961_();
            if (playerRespawnPoint == null) continue;
            ResourceKey respawnDimension = player.m_8963_();
            if (!world.m_46472_().equals((Object)respawnDimension) || !((distance = spawnPos.m_123331_((Vec3i)playerRespawnPoint)) < minimumDistance * minimumDistance)) continue;
            return true;
        }
        return false;
    }
}

