/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.thefleshthathates;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;

public class QuadTree {
    private Node root;
    private final int MAX_CAPACITY = 4;
    private final int MAX_DEPTH = 4;

    public QuadTree(BlockPos position, int size) {
        this.root = new Node(position, size);
    }

    public boolean insert(BlockPos pos, Object data) {
        return this.insert(this.root, pos, data, 0);
    }

    private boolean insert(Node node, BlockPos pos, Object data, int depth) {
        if (!node.inBoundary(pos)) {
            return false;
        }
        if (node.isLeaf) {
            if (node.data.size() < 4 || depth >= 4) {
                node.data.add(data);
                return true;
            }
            this.split(node);
            return this.insert(node, pos, data, depth);
        }
        if (pos.m_123341_() < node.position.m_123341_()) {
            if (pos.m_123343_() < node.position.m_123343_()) {
                return this.insert(node.sw, pos, data, depth + 1);
            }
            return this.insert(node.nw, pos, data, depth + 1);
        }
        if (pos.m_123343_() < node.position.m_123343_()) {
            return this.insert(node.se, pos, data, depth + 1);
        }
        return this.insert(node.ne, pos, data, depth + 1);
    }

    private void split(Node node) {
        int subSize = node.size / 2;
        int x = node.position.m_123341_();
        int z = node.position.m_123343_();
        node.isLeaf = false;
        node.nw = new Node(new BlockPos(x - subSize, 0, z - subSize), subSize);
        node.ne = new Node(new BlockPos(x + subSize, 0, z - subSize), subSize);
        node.sw = new Node(new BlockPos(x - subSize, 0, z + subSize), subSize);
        node.se = new Node(new BlockPos(x + subSize, 0, z + subSize), subSize);
        for (Object d : new ArrayList<Object>(node.data)) {
            this.insert(node, (BlockPos)d, d, 0);
        }
        node.data.clear();
    }

    public List<Object> queryRange(BlockPos center, int range) {
        ArrayList<Object> foundPoints = new ArrayList<Object>();
        this.queryRange(this.root, center, range, foundPoints);
        return foundPoints;
    }

    private void queryRange(Node node, BlockPos center, int range, List<Object> foundPoints) {
        if (node == null) {
            return;
        }
        BlockPos min = center.m_7918_(-range, -range, -range);
        BlockPos max = center.m_7918_(range, range, range);
        if (!node.inBoundary(min) && !node.inBoundary(max)) {
            return;
        }
        if (node.isLeaf) {
            for (Object d : node.data) {
                BlockPos pos = (BlockPos)d;
                if (pos.m_123341_() < min.m_123341_() || pos.m_123341_() > max.m_123341_() || pos.m_123343_() < min.m_123343_() || pos.m_123343_() > max.m_123343_()) continue;
                foundPoints.add(d);
            }
        } else {
            this.queryRange(node.nw, center, range, foundPoints);
            this.queryRange(node.ne, center, range, foundPoints);
            this.queryRange(node.sw, center, range, foundPoints);
            this.queryRange(node.se, center, range, foundPoints);
        }
    }

    private class Node {
        BlockPos position;
        List<Object> data;
        Node nw;
        Node ne;
        Node sw;
        Node se;
        boolean isLeaf;
        int size;

        Node(BlockPos position, int size) {
            this.position = position;
            this.size = size;
            this.data = new ArrayList<Object>();
            this.isLeaf = true;
        }

        boolean inBoundary(BlockPos pos) {
            int halfSize = this.size / 2;
            return pos.m_123341_() >= this.position.m_123341_() - halfSize && pos.m_123341_() < this.position.m_123341_() + halfSize && pos.m_123343_() >= this.position.m_123343_() - halfSize && pos.m_123343_() < this.position.m_123343_() + halfSize;
        }
    }
}

