/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.thefleshthathates;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.mcreator.thefleshthathates.FConfig.TFTHConfiguration;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class SyncSpawnControl {
    private static int maxClones;
    private static final Map<UUID, Set<UUID>> originalToClones;
    private static final Map<UUID, Integer> originalToSpawnCount;

    public static void registerOriginal(Entity original) {
        originalToClones.put(original.m_20148_(), new HashSet());
        originalToSpawnCount.put(original.m_20148_(), 0);
    }

    public static boolean canSpawnClone(Entity original) {
        int maxClones = TFTHConfiguration.getMaxDogsAllowed();
        boolean canSpawn = originalToSpawnCount.getOrDefault(original.m_20148_(), 0) < maxClones;
        return canSpawn;
    }

    public static boolean canSpawnClone(UUID parentUUID) {
        int maxClones = TFTHConfiguration.getMaxDogsAllowed();
        return originalToSpawnCount.getOrDefault(parentUUID, 0) < maxClones;
    }

    public static void registerClone(Entity clone, UUID parentUUID) {
        if (parentUUID == null) {
            originalToClones.put(clone.m_20148_(), new HashSet());
            originalToSpawnCount.put(clone.m_20148_(), 0);
            return;
        }
        Set<UUID> clones = originalToClones.get(parentUUID);
        if (clones == null) {
            clones = new HashSet<UUID>();
            originalToClones.put(parentUUID, clones);
        }
        clones.add(clone.m_20148_());
        originalToSpawnCount.put(parentUUID, originalToSpawnCount.getOrDefault(parentUUID, 0) + 1);
    }

    public static void unregisterEntity(Entity entity) {
        if (originalToClones.containsKey(entity.m_20148_())) {
            originalToClones.remove(entity.m_20148_());
            originalToSpawnCount.remove(entity.m_20148_());
        } else {
            for (Map.Entry<UUID, Set<UUID>> entry : originalToClones.entrySet()) {
                if (!entry.getValue().remove(entity.m_20148_())) continue;
                originalToSpawnCount.put(entry.getKey(), originalToSpawnCount.get(entry.getKey()) - 1);
                break;
            }
        }
    }

    static {
        originalToClones = new HashMap<UUID, Set<UUID>>();
        originalToSpawnCount = new HashMap<UUID, Integer>();
    }
}

