/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.thefleshthathates;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.mcreator.thefleshthathates.FleshBlockSavedData;
import net.mcreator.thefleshthathates.FleshBlockSpread;
import net.minecraft.server.level.ServerLevel;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class TickMethods {
    public static Set<FleshBlockSpread> fleshBlockSpreads = new HashSet<FleshBlockSpread>();
    public static List<FleshBlockSpread> newSpreadsToAdd = new ArrayList<FleshBlockSpread>();
    private static int mobCapTickCounter = 0;
    private static final int MOB_CAP_INTERVAL = 600;

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        new TickMethods();
    }

    @Mod.EventBusSubscriber
    private static class ForgeBusEvents {
        private static int saveTickCounter = 0;
        private static final int SAVE_INTERVAL = 200;

        private ForgeBusEvents() {
        }

        @SubscribeEvent
        public static void serverLoad(ServerStartingEvent event) {
            ServerLevel world = event.getServer().m_129783_();
            FleshBlockSavedData data = FleshBlockSavedData.get(world.m_8895_());
            List<FleshBlockSpread> spreads = data.getBlocksToSpread();
            fleshBlockSpreads.clear();
            for (FleshBlockSpread spread : spreads) {
                spread.setLevel(world);
            }
            fleshBlockSpreads.addAll(spreads);
        }

        @OnlyIn(value=Dist.CLIENT)
        @SubscribeEvent
        public static void clientLoad(FMLClientSetupEvent event) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @SubscribeEvent
        public static void onTick(TickEvent.ServerTickEvent event) {
            if (event.phase == TickEvent.Phase.END) {
                for (FleshBlockSpread spread : fleshBlockSpreads) {
                    spread.tick();
                }
                List<FleshBlockSpread> list = newSpreadsToAdd;
                synchronized (list) {
                    fleshBlockSpreads.addAll(newSpreadsToAdd);
                    newSpreadsToAdd.clear();
                }
                if (++saveTickCounter >= 200) {
                    ServerLevel world = event.getServer().m_129783_();
                    FleshBlockSavedData data = FleshBlockSavedData.get(world.m_8895_());
                    data.saveFleshBlockSpreads(new ArrayList<FleshBlockSpread>(fleshBlockSpreads));
                    saveTickCounter = 0;
                }
            }
        }
    }
}

