/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.thefleshthathates.block;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.mcreator.thefleshthathates.AwarenessStageMobs;
import net.mcreator.thefleshthathates.BlockParticleEmitter;
import net.mcreator.thefleshthathates.FConfig.TFTHConfiguration;
import net.mcreator.thefleshthathates.FEvents.FleshWorld;
import net.mcreator.thefleshthathates.FleshBlockSavedData;
import net.mcreator.thefleshthathates.GermStageMobs;
import net.mcreator.thefleshthathates.block.FleshBlocks;
import net.mcreator.thefleshthathates.block.FleshTernsBlock;
import net.mcreator.thefleshthathates.block.entity.fleshtype.FleshMValue;
import net.mcreator.thefleshthathates.init.TheFleshThatHatesModBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class BaseFleshBlock
extends Block {
    public BaseFleshBlock(BlockBehaviour.Properties properties) {
        super(properties.m_60977_());
    }

    public void m_213897_(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        super.m_213897_(state, world, pos, random);
        BlockParticleEmitter.emitFleshParticles(world, pos, random);
        this.extinguishFireWithProbability(world, pos, random);
        if (!world.m_5776_()) {
            Block vegetationBlock;
            BlockPos abovePos;
            if (TFTHConfiguration.isVegetationBlockEnabled() && random.m_188503_(40) == 0 && world.m_46859_(abovePos = pos.m_7494_()) && (vegetationBlock = this.pickRandomVegetationBlock(random)) != null) {
                world.m_7731_(abovePos, vegetationBlock.m_49966_(), 3);
            }
            if (TFTHConfiguration.isFleshTernsEnabled() && random.m_188503_(150) == 0) {
                this.placeIfPossible(world, pos, (Block)TheFleshThatHatesModBlocks.FLESH_TERNS.get());
            }
            if (TFTHConfiguration.isFleshSpikesEnabled() && FleshWorld.getPoints() >= 300 && random.m_188503_(150) == 0) {
                this.placeIfPossible(world, pos, (Block)TheFleshThatHatesModBlocks.FLESH_SPIKES.get());
            }
            if (TFTHConfiguration.isFleshBoilEnabled() && FleshWorld.getPoints() >= 500 && random.m_188503_(500) == 0 && !this.isFleshBoilNearby(world, pos)) {
                this.placeIfPossible(world, pos, (Block)TheFleshThatHatesModBlocks.FLESH_BOIL.get());
            }
            if (TFTHConfiguration.isGermStageMobSpawnEnabled()) {
                this.spawnRandomGermStageMob(world, pos, random);
            }
        }
        if (this.isBlockOnFire(world, pos)) {
            boolean wasFireOnTop = this.isFireBlockOnTop(world, pos);
            world.m_7471_(pos, false);
            FleshWorld.subtractPointsForDestroyedBlock((Level)world);
            if (random.m_188503_(100) < 10) {
                // empty if block
            }
        }
        if (this.isAdjacentToFireOrLava(world, pos) && random.m_188503_(100) < 1) {
            world.m_7471_(pos, false);
        }
    }

    private void extinguishFireWithProbability(ServerLevel world, BlockPos pos, RandomSource random) {
        BlockPos posAbove = pos.m_7494_();
        if (world.m_8055_(posAbove).m_60713_(Blocks.f_50083_)) {
            world.m_7731_(posAbove, Blocks.f_50016_.m_49966_(), 3);
        }
    }

    private boolean isFireBlockOnTop(ServerLevel world, BlockPos pos) {
        BlockState stateAbove = world.m_8055_(pos.m_7494_());
        return stateAbove.m_60713_(Blocks.f_50083_);
    }

    private boolean isBlockOnFire(ServerLevel world, BlockPos pos) {
        return this.isAdjacentToFireOrLava(world, pos) || this.isFireBlockOnTop(world, pos);
    }

    private void placeIfPossible(ServerLevel world, BlockPos pos, Block block) {
        if (block instanceof FleshTernsBlock) {
            int i;
            int numberOfTerns = world.f_46441_.m_188503_(3) + 2;
            boolean canPlace = true;
            for (i = 1; i <= numberOfTerns; ++i) {
                if (world.m_46859_(pos.m_6630_(i))) continue;
                canPlace = false;
                break;
            }
            if (canPlace) {
                for (i = 1; i <= numberOfTerns; ++i) {
                    world.m_7731_(pos.m_6630_(i), (BlockState)block.m_49966_().m_61124_((Property)FleshTernsBlock.LEVEL, (Comparable)Integer.valueOf(i)), 3);
                }
            }
        } else if (world.m_46859_(pos.m_7494_())) {
            world.m_7731_(pos.m_7494_(), block.m_49966_(), 3);
        }
    }

    private boolean isFleshBoilNearby(ServerLevel world, BlockPos pos) {
        FleshBlockSavedData savedData = FleshBlockSavedData.get(world.m_8895_());
        for (BlockPos savedPos : savedData.getFleshBoilBlocks()) {
            if (!savedPos.m_123314_((Vec3i)pos, 80.0)) continue;
            return true;
        }
        return false;
    }

    private Block pickRandomVegetationBlock(RandomSource random) {
        Block[] vegetationBlocks = FleshBlocks.FLESH_VEGETATION.toArray(new Block[0]);
        if (vegetationBlocks.length > 0) {
            return vegetationBlocks[random.m_188503_(vegetationBlocks.length)];
        }
        return null;
    }

    private boolean isAdjacentToFireOrLava(ServerLevel world, BlockPos pos) {
        BlockPos[] adjacentPositions;
        for (BlockPos adjacentPos : adjacentPositions = new BlockPos[]{pos.m_122012_(), pos.m_122019_(), pos.m_122029_(), pos.m_122024_(), pos.m_7494_(), pos.m_7495_()}) {
            BlockState adjacentBlockState = world.m_8055_(adjacentPos);
            if (!adjacentBlockState.m_60713_(Blocks.f_50083_) && !adjacentBlockState.m_60713_(Blocks.f_49991_)) continue;
            return true;
        }
        return false;
    }

    private void spawnRandomGermStageMob(ServerLevel world, BlockPos pos, RandomSource random) {
        ArrayList germMobTypes;
        FleshWorld.FleshStage currentStage = FleshWorld.getCurrentStage();
        if ((currentStage == FleshWorld.FleshStage.FETAL_STAGE || currentStage == FleshWorld.FleshStage.GERM_STAGE) && random.m_188503_(TFTHConfiguration.getMobSpawnChanceGerm()) == 0) {
            germMobTypes = new ArrayList(GermStageMobs.ENTITY_TYPES);
            this.spawnMobs(world, pos, random, germMobTypes);
        }
        if (currentStage.ordinal() >= FleshWorld.FleshStage.AWARENESS_STAGE.ordinal()) {
            if (random.m_188503_(TFTHConfiguration.getMobSpawnChanceAwarenessGerm()) == 0) {
                germMobTypes = new ArrayList(GermStageMobs.ENTITY_TYPES);
                this.spawnMobs(world, pos, random, germMobTypes);
            }
            if (random.m_188503_(TFTHConfiguration.getMobSpawnChanceAwareness()) == 0) {
                ArrayList awarenessMobTypes = new ArrayList(AwarenessStageMobs.ENTITY_TYPES);
                this.spawnMobs(world, pos, random, awarenessMobTypes);
            }
        }
    }

    private void spawnMobs(ServerLevel world, BlockPos pos, RandomSource random, List<EntityType<?>> mobTypes) {
        BlockPos spawnPos;
        EntityType randomMobType;
        Entity entity;
        List spawnableMobs = mobTypes.stream().filter(mobType -> FleshMValue.canSpawn(mobType, FleshWorld.getPoints())).collect(Collectors.toList());
        if (!spawnableMobs.isEmpty() && (entity = (randomMobType = (EntityType)spawnableMobs.get(random.m_188503_(spawnableMobs.size()))).m_20615_((Level)world)) != null && (spawnPos = this.findSuitableSpawnPosition(world, pos, random)) != null) {
            entity.m_7678_((double)spawnPos.m_123341_() + 0.5, (double)spawnPos.m_123342_(), (double)spawnPos.m_123343_() + 0.5, random.m_188501_() * 360.0f, 0.0f);
            world.m_7967_(entity);
        }
    }

    private BlockPos findSuitableSpawnPosition(ServerLevel world, BlockPos pos, RandomSource random) {
        int range = 3;
        for (int dx = -range; dx <= range; ++dx) {
            for (int dy = -range; dy <= range; ++dy) {
                for (int dz = -range; dz <= range; ++dz) {
                    BlockPos checkPos = pos.m_7918_(dx, dy, dz);
                    if (!world.m_46859_(checkPos) || !world.m_46859_(checkPos.m_7494_()) || !world.m_8055_(checkPos.m_7495_()).m_60804_((BlockGetter)world, checkPos.m_7495_())) continue;
                    return checkPos;
                }
            }
        }
        return null;
    }
}

