/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.thefleshthathates.block;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.mcreator.thefleshthathates.FConfig.TFTHConfiguration;
import net.mcreator.thefleshthathates.FEvents.FleshWorld;
import net.mcreator.thefleshthathates.FleshBlockSavedData;
import net.mcreator.thefleshthathates.GermStageMobs;
import net.mcreator.thefleshthathates.entity.test.ImageHolderEntity;
import net.mcreator.thefleshthathates.init.TheFleshThatHatesModBlockEntities;
import net.mcreator.thefleshthathates.init.TheFleshThatHatesModBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;

public class FleshBoilBlock
extends BaseEntityBlock
implements EntityBlock {
    public static final IntegerProperty ANIMATION = IntegerProperty.m_61631_((String)"animation", (int)0, (int)1);
    private Map<BlockPos, Long> mobTimer = new HashMap<BlockPos, Long>();

    public FleshBoilBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_280658_(NoteBlockInstrument.BASEDRUM).m_60918_(SoundType.f_56739_).m_60913_(10.0f, 10.0f));
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos blockPos, BlockState blockState) {
        return ((BlockEntityType)TheFleshThatHatesModBlockEntities.FLESH_BOIL.get()).m_155264_(blockPos, blockState);
    }

    public boolean m_7420_(BlockState state, BlockGetter reader, BlockPos pos) {
        return true;
    }

    public int m_7753_(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return 0;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{ANIMATION});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return this.m_49966_();
    }

    public void m_213897_(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        super.m_213897_(state, world, pos, random);
        long worldTime = world.m_46467_();
        if (worldTime % 300L == 0L) {
            this.attractAndConsumeMobs(world, pos);
        }
        if (worldTime % (long)TFTHConfiguration.getFleshBoilTimeSpawn() == 0L) {
            this.spawnMobs(world, pos, random);
        }
        if (worldTime % 1200L == 0L) {
            FleshWorld.addPoints(TFTHConfiguration.getFleshBoilPoints(), (Level)world);
        }
        world.m_186460_(pos, (Block)this, 1);
    }

    public void m_6807_(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean isMoving) {
        super.m_6807_(state, world, pos, oldState, isMoving);
        if (!world.f_46443_ && world instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)world;
            FleshBlockSavedData savedData = FleshBlockSavedData.get(serverWorld.m_8895_());
            savedData.addFleshBoilBlock(pos);
            savedData.m_77762_();
        }
        world.m_186460_(pos, (Block)this, 600);
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        super.m_6810_(state, world, pos, newState, isMoving);
        if (!world.f_46443_ && world instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)world;
            FleshBlockSavedData savedData = FleshBlockSavedData.get(serverWorld.m_8895_());
            savedData.removeFleshBoilBlock(pos);
            savedData.m_77762_();
        }
        if (!world.f_46443_) {
            List entities = world.m_45976_(ImageHolderEntity.class, new AABB(pos).m_82400_(1.0));
            for (ImageHolderEntity entity : entities) {
                entity.m_142687_(Entity.RemovalReason.DISCARDED);
            }
        }
    }

    private void attractAndConsumeMobs(ServerLevel world, BlockPos blockPos) {
        long currentTime = world.m_46467_();
        if (this.mobTimer.getOrDefault(blockPos, 0L) > currentTime) {
            return;
        }
        this.mobTimer.put(blockPos, currentTime + 1500L);
        double consumeRadius = 30.0;
        this.spawnRedstoneParticles(world, blockPos, 50);
        List nearbyMobs = world.m_6443_(Mob.class, new AABB(blockPos).m_82400_(consumeRadius), e -> GermStageMobs.ENTITY_TYPES.contains(e.m_6095_()));
        if (!nearbyMobs.isEmpty()) {
            Mob mobToConsume = (Mob)nearbyMobs.get(world.m_213780_().m_188503_(nearbyMobs.size()));
            this.spawnRedstoneParticles(world, mobToConsume.m_20183_(), 50);
            mobToConsume.m_142687_(Entity.RemovalReason.DISCARDED);
            FleshBlockSavedData savedData = FleshBlockSavedData.get(world.m_8895_());
            savedData.incrementConsumedMobCount(blockPos);
            if (savedData.getConsumedMobCount(blockPos) >= TFTHConfiguration.fleshBoilEvolution()) {
                world.m_7731_(blockPos, ((Block)TheFleshThatHatesModBlocks.FLESH_BOIL_PHASE_TWO.get()).m_49966_(), 3);
            }
        }
    }

    private void spawnRedstoneParticles(ServerLevel world, BlockPos pos, int count) {
        for (int i = 0; i < count; ++i) {
            double d0 = (double)pos.m_123341_() + 0.5 + (world.f_46441_.m_188500_() - 0.5) * 2.0;
            double d1 = (double)pos.m_123342_() + 0.5 + (world.f_46441_.m_188500_() - 0.5) * 2.0;
            double d2 = (double)pos.m_123343_() + 0.5 + (world.f_46441_.m_188500_() - 0.5) * 2.0;
            world.m_8767_((ParticleOptions)DustParticleOptions.f_123656_, d0, d1, d2, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    private void spawnMobs(ServerLevel world, BlockPos pos, RandomSource random) {
        Entity entity;
        EntityType randomEntityType = GermStageMobs.ENTITY_TYPES.stream().skip(random.m_188503_(GermStageMobs.ENTITY_TYPES.size())).findFirst().orElse(null);
        if (randomEntityType != null && (entity = randomEntityType.m_20615_((Level)world)) != null) {
            BlockPos spawnPos = this.getSafeSpawnPosition(world, pos);
            entity.m_6034_((double)spawnPos.m_123341_() + 0.5, (double)spawnPos.m_123342_(), (double)spawnPos.m_123343_() + 0.5);
            world.m_7967_(entity);
        }
    }

    private BlockPos getSafeSpawnPosition(ServerLevel world, BlockPos pos) {
        BlockPos.MutableBlockPos mutablePos = pos.m_122032_();
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                for (int y = 1; y <= 2; ++y) {
                    mutablePos.m_122178_(pos.m_123341_() + x, pos.m_123342_() + y, pos.m_123343_() + z);
                    if (!world.m_46859_((BlockPos)mutablePos) || !world.m_46859_(mutablePos.m_7494_())) continue;
                    return mutablePos.m_7949_();
                }
            }
        }
        return pos;
    }
}

