/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.thefleshthathates.block.blockbehaviour;

import net.mcreator.thefleshthathates.FEvents.FleshWorld;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;

public class WorldFleshBlocks
extends Block {
    public WorldFleshBlocks(BlockBehaviour.Properties properties) {
        super(properties.m_60977_());
    }

    public void m_213897_(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        super.m_213897_(state, world, pos, random);
        this.extinguishFireWithProbability(world, pos, random);
        if (this.isBlockOnFire(world, pos)) {
            boolean wasFireOnTop = this.isFireBlockOnTop(world, pos);
            world.m_7471_(pos, false);
            FleshWorld.subtractPointsForDestroyedBlock((Level)world);
            if (random.m_188503_(100) < 10) {
                // empty if block
            }
        }
        if (this.isAdjacentToFireOrLava(world, pos) && random.m_188503_(300) < 1) {
            world.m_7471_(pos, false);
        }
    }

    private void extinguishFireWithProbability(ServerLevel world, BlockPos pos, RandomSource random) {
        BlockPos posAbove = pos.m_7494_();
        if (world.m_8055_(posAbove).m_60713_(Blocks.f_50083_)) {
            world.m_7731_(posAbove, Blocks.f_50016_.m_49966_(), 3);
        }
    }

    private void transferFireUpwards(ServerLevel world, BlockPos pos, RandomSource random) {
        BlockPos abovePos = pos.m_7494_();
        if (world.m_46859_(abovePos) && this.isFireBlockOnTop(world, pos)) {
            world.m_7731_(abovePos, Blocks.f_50083_.m_49966_(), 3);
        }
    }

    private void transferFireDownwards(ServerLevel world, BlockPos pos, RandomSource random) {
        BlockPos belowPos = pos.m_7495_();
        if (world.m_46859_(belowPos)) {
            world.m_7731_(belowPos, Blocks.f_50083_.m_49966_(), 3);
        }
    }

    private boolean isFireBlockOnTop(ServerLevel world, BlockPos pos) {
        BlockState stateAbove = world.m_8055_(pos.m_7494_());
        return stateAbove.m_60713_(Blocks.f_50083_);
    }

    private boolean isBlockOnFire(ServerLevel world, BlockPos pos) {
        return this.isAdjacentToFireOrLava(world, pos) || this.isFireBlockOnTop(world, pos);
    }

    private boolean isAdjacentToFireOrLava(ServerLevel world, BlockPos pos) {
        BlockPos[] adjacentPositions;
        for (BlockPos adjacentPos : adjacentPositions = new BlockPos[]{pos.m_122012_(), pos.m_122019_(), pos.m_122029_(), pos.m_122024_(), pos.m_7494_(), pos.m_7495_()}) {
            BlockState adjacentBlockState = world.m_8055_(adjacentPos);
            if (!adjacentBlockState.m_60713_(Blocks.f_50083_) && !adjacentBlockState.m_60713_(Blocks.f_49991_)) continue;
            return true;
        }
        return false;
    }
}

