/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.thefleshthathates.client.animation;

import java.util.Random;
import net.minecraft.world.entity.Mob;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class HandleAnimations {
    public static final RawAnimation IDLE = RawAnimation.begin().thenLoop("idle");
    public static final RawAnimation WALK = RawAnimation.begin().thenLoop("walk");
    public static final RawAnimation AGRWALK = RawAnimation.begin().thenLoop("agrwalk");
    public static final RawAnimation ATTACK = RawAnimation.begin().thenLoop("attack");
    public static final RawAnimation ATTACK1 = RawAnimation.begin().thenLoop("attack1");
    public static final RawAnimation ATTACK2 = RawAnimation.begin().thenLoop("attack2");
    private static final AnimationController ATTACK_ANIMATION_CONTROLLER = HandleAnimations.createAnimationController("attack_controller", "attack_animation", "attack");
    private static final AnimationController ATTACK1_ANIMATION_CONTROLLER = HandleAnimations.createAnimationController("attack1_controller", "attack1_animation", "attack1");
    private static final Random random = new Random();

    public static <T extends Mob> AnimationController<T> genericWalkIdleAgrWalkController(T animatable) {
        return new AnimationController(animatable, "Walk/Idle/AgrWalk", 0, state -> {
            if (animatable.m_5912_()) {
                return state.setAndContinue(AGRWALK);
            }
            return state.setAndContinue(state.isMoving() ? WALK : IDLE);
        });
    }

    public static <T extends Mob> AnimationController<T> genericWalkIdleController(T animatable) {
        return new AnimationController(animatable, "WalkIdle", 0, state -> {
            if (state.isMoving()) {
                return state.setAndContinue(WALK);
            }
            return state.setAndContinue(IDLE);
        });
    }

    public static <T extends Mob> AnimationController<T> genericIdleController(T animatable) {
        return new AnimationController(animatable, "Idle", 0, state -> state.setAndContinue(IDLE));
    }

    private static AnimationController createAnimationController(String controllerName, String animationName, String rawAnimationAction) {
        RawAnimation rawAnimation = RawAnimation.begin().thenPlay(rawAnimationAction);
        return new AnimationController((GeoAnimatable)null, controllerName, state -> PlayState.STOP).triggerableAnim(animationName, rawAnimation);
    }

    public static AnimationController getAttackAnimationController() {
        return ATTACK_ANIMATION_CONTROLLER;
    }

    public static AnimationController getAttack1AnimationController() {
        return ATTACK1_ANIMATION_CONTROLLER;
    }

    public static void triggerOne(GeoEntity entity) {
        entity.triggerAnim("attack_controller", "attack_animation");
    }

    public static void triggerTwo(GeoEntity entity) {
        if (random.nextBoolean()) {
            entity.triggerAnim("attack_controller", "attack_animation");
        } else {
            entity.triggerAnim("attack1_controller", "attack1_animation");
        }
    }

    public static void triggerThree(GeoEntity entity) {
        int attackChoice = random.nextInt(3);
        switch (attackChoice) {
            case 0: {
                entity.triggerAnim("attack_controller", "attack_animation");
                break;
            }
            case 1: {
                entity.triggerAnim("attack1_controller", "attack1_animation");
                break;
            }
            case 2: {
                entity.triggerAnim("attack2_controller", "attack2_animation");
            }
        }
    }
}

