/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.thefleshthathates.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import net.mcreator.thefleshthathates.FEvents.FleshWorld;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class PointsCommandCommand {
    @SubscribeEvent
    public static void registerCommand(RegisterCommandsEvent event) {
        event.getDispatcher().register((LiteralArgumentBuilder)Commands.m_82127_((String)"tfth:points").executes(context -> PointsCommandCommand.displayPoints((CommandSourceStack)context.getSource())));
        event.getDispatcher().register((LiteralArgumentBuilder)Commands.m_82127_((String)"tfth:points_add").then(Commands.m_82129_((String)"pointsToAdd", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(context -> {
            ServerLevel level = ((CommandSourceStack)context.getSource()).m_81372_();
            int pointsToAdd = (Integer)context.getArgument("pointsToAdd", Integer.class);
            FleshWorld.addPoints(pointsToAdd, (Level)level);
            return 1;
        })));
        event.getDispatcher().register((LiteralArgumentBuilder)Commands.m_82127_((String)"tfth:points_subtr").then(Commands.m_82129_((String)"pointsToSubtract", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(context -> {
            ServerLevel level = ((CommandSourceStack)context.getSource()).m_81372_();
            int pointsToSubtract = (Integer)context.getArgument("pointsToSubtract", Integer.class);
            FleshWorld.subtractPoints(pointsToSubtract, (Level)level);
            return 1;
        })));
        event.getDispatcher().register((LiteralArgumentBuilder)Commands.m_82127_((String)"tfth:points_reset").executes(context -> {
            FleshWorld.resetStageAndPoints();
            return 1;
        }));
    }

    private static int displayPoints(CommandSourceStack source) {
        int currentPoints = FleshWorld.getPoints();
        FleshWorld.FleshStage currentPhase = FleshWorld.getCurrentStage();
        MutableComponent pointsMessage = Component.m_237113_((String)("Current points: " + currentPoints));
        MutableComponent phaseMessage = Component.m_237113_((String)("Current phase: " + PointsCommandCommand.getStageDisplayName(currentPhase)));
        source.m_288197_(() -> PointsCommandCommand.lambda$displayPoints$4((Component)pointsMessage), false);
        source.m_288197_(() -> PointsCommandCommand.lambda$displayPoints$5((Component)phaseMessage), false);
        return 1;
    }

    private static String getStageDisplayName(FleshWorld.FleshStage stage) {
        switch (stage) {
            case FETAL_STAGE: {
                return "EMBRYO PHASE";
            }
            case GERM_STAGE: {
                return "BIOGENESIS PHASE";
            }
            case AWARENESS_STAGE: {
                return "ENLIGHTENMENT PHASE";
            }
            case GROWTH_STAGE: {
                return "BIOTRANSFORMATION PHASE";
            }
            case SYNTHESIS_STAGE: {
                return "SYNTHESIS PHASE";
            }
            case EPITASIS_STAGE: {
                return "EPIKULMINATION PHASE";
            }
        }
        return "Unknown Phase";
    }

    private static /* synthetic */ Component lambda$displayPoints$5(Component phaseMessage) {
        return phaseMessage;
    }

    private static /* synthetic */ Component lambda$displayPoints$4(Component pointsMessage) {
        return pointsMessage;
    }
}

