/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.thefleshthathates.entity;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.mcreator.thefleshthathates.FConfig.TFTHConfiguration;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.AbstractFish;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AgroTargetGoal<T extends LivingEntity>
extends NearestAttackableTargetGoal<T> {
    private static final EntityType<?> sporeScentEntityType = EntityType.m_20632_((String)"spore:scent").orElse(null);
    private static final MobEffect anabiosisEffect = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(new ResourceLocation("the_flesh_that_hates:anabiosis"));
    private static final MobEffect gohEffect = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(new ResourceLocation("the_flesh_that_hates:goh"));
    private static final Logger LOGGER = LogManager.getLogger();
    private List<String> blacklist = ((List)TFTHConfiguration.BLACKLIST_MOBS.get()).stream().collect(Collectors.toList());
    private List<String> superblacklist;

    public AgroTargetGoal(PathfinderMob mobIn, Class<T> targetClassIn, boolean mustSee, boolean mustReach, Set<EntityType<?>> entityTypesToIgnore) {
        super((Mob)mobIn, targetClassIn, 10, mustSee, mustReach, target -> {
            String targetIdentifier = EntityType.m_20613_((EntityType)target.m_6095_()).toString();
            if (((List)TFTHConfiguration.BLACKLIST_MOBS.get()).contains(targetIdentifier)) {
                return false;
            }
            if (AgroTargetGoal.isInSuperBlackList(targetIdentifier)) {
                return false;
            }
            if (target instanceof AbstractFish) {
                return false;
            }
            if (gohEffect != null && target.m_21023_(gohEffect)) {
                return true;
            }
            if (anabiosisEffect != null && target.m_21023_(anabiosisEffect)) {
                return false;
            }
            if (target instanceof AbstractFish && !((Boolean)TFTHConfiguration.ATTACK_FISH.get()).booleanValue()) {
                return false;
            }
            if (!(entityTypesToIgnore.contains(target.m_6095_()) || sporeScentEntityType != null && target.m_6095_() == sporeScentEntityType)) {
                PathfinderMob targetMob;
                LivingEntity targetsTarget;
                if (target instanceof PathfinderMob && (targetsTarget = (targetMob = (PathfinderMob)target).m_5448_()) == mobIn) {
                    return true;
                }
                return true;
            }
            return false;
        });
    }

    private static boolean isInSuperBlackList(String targetIdentifier) {
        List<String> superBlackList = TFTHConfiguration.getSuperBlackList();
        return superBlackList.stream().anyMatch(targetIdentifier::startsWith);
    }
}

