/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.thefleshthathates.entity;

import java.util.ArrayList;
import java.util.Comparator;
import net.mcreator.thefleshthathates.init.TheFleshThatHatesModEntities;
import net.mcreator.thefleshthathates.init.TheFleshThatHatesModItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import net.minecraftforge.registries.ForgeRegistries;

@OnlyIn(value=Dist.CLIENT, _interface=ItemSupplier.class)
public class ClayBombEntity
extends AbstractArrow
implements ItemSupplier {
    public ClayBombEntity(PlayMessages.SpawnEntity packet, Level world) {
        super((EntityType)TheFleshThatHatesModEntities.CLAY_BOMB.get(), world);
    }

    public ClayBombEntity(EntityType<? extends ClayBombEntity> type, Level world) {
        super(type, world);
    }

    public ClayBombEntity(EntityType<? extends ClayBombEntity> type, double x, double y, double z, Level world) {
        super(type, x, y, z, world);
    }

    public ClayBombEntity(EntityType<? extends ClayBombEntity> type, LivingEntity entity, Level world) {
        super(type, entity, world);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.f_36703_) {
            Level currentWorld = this.m_9236_();
            BlockPos entityPos = this.m_20183_();
            RandomSource random = this.f_19796_;
            int fireRadius = 7;
            int verticalSpread = 7;
            int numberOfFireBlocks = 15;
            currentWorld.m_6263_(null, (double)entityPos.m_123341_(), (double)entityPos.m_123342_(), (double)entityPos.m_123343_(), (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.generic.explode")), SoundSource.BLOCKS, 1.0f, (1.0f + (random.m_188501_() - random.m_188501_()) * 0.2f) * 0.7f);
            if (currentWorld.f_46443_) {
                for (int i = 0; i < 20; ++i) {
                    double horizontalSpread = 0.7;
                    double verticalSpeed = 0.5;
                    double angle = random.m_188500_() * 2.0 * Math.PI;
                    double horizontalDistance = random.m_188500_() * horizontalSpread;
                    double dX = Math.sin(angle) * horizontalDistance;
                    double dZ = Math.cos(angle) * horizontalDistance;
                    currentWorld.m_7106_((ParticleOptions)ParticleTypes.f_123759_, (double)entityPos.m_123341_() + dX, (double)entityPos.m_123342_(), (double)entityPos.m_123343_() + dZ, dX, verticalSpeed, dZ);
                }
            }
            ArrayList<BlockPos> potentialFirePositions = new ArrayList<BlockPos>();
            for (int dx = -fireRadius; dx <= fireRadius; ++dx) {
                for (int dy = -verticalSpread; dy <= verticalSpread; ++dy) {
                    for (int dz = -fireRadius; dz <= fireRadius; ++dz) {
                        BlockPos pos2 = entityPos.m_7918_(dx, dy, dz);
                        if (!currentWorld.m_46859_(pos2) || !currentWorld.m_8055_(pos2.m_7495_()).m_60804_((BlockGetter)currentWorld, pos2.m_7495_())) continue;
                        potentialFirePositions.add(pos2);
                    }
                }
            }
            potentialFirePositions.sort(Comparator.comparingDouble(pos -> pos.m_123331_((Vec3i)entityPos)));
            for (int i = 0; i < Math.min(numberOfFireBlocks, potentialFirePositions.size()); ++i) {
                BlockPos firePos = (BlockPos)potentialFirePositions.get(i);
                currentWorld.m_7731_(firePos, Blocks.f_50083_.m_49966_(), 3);
            }
            this.m_146870_();
        }
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    @OnlyIn(value=Dist.CLIENT)
    public ItemStack m_7846_() {
        return new ItemStack((ItemLike)TheFleshThatHatesModItems.CLAY_BOMB_AMMO.get());
    }

    protected ItemStack m_7941_() {
        return ItemStack.f_41583_;
    }

    protected void m_7761_(LivingEntity entity) {
        super.m_7761_(entity);
        entity.m_21317_(entity.m_21234_() - 1);
    }

    public static ClayBombEntity shoot(Level world, LivingEntity entity, RandomSource random, float power, double damage, int knockback) {
        ClayBombEntity entityarrow = new ClayBombEntity((EntityType<? extends ClayBombEntity>)((EntityType)TheFleshThatHatesModEntities.CLAY_BOMB.get()), entity, world);
        entityarrow.m_6686_(entity.m_20252_((float)1.0f).f_82479_, entity.m_20252_((float)1.0f).f_82480_, entity.m_20252_((float)1.0f).f_82481_, power * 2.0f, 0.0f);
        entityarrow.m_20225_(true);
        entityarrow.m_36762_(false);
        entityarrow.m_36781_(damage);
        entityarrow.m_36735_(knockback);
        world.m_7967_((Entity)entityarrow);
        world.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.arrow.shoot")), SoundSource.PLAYERS, 1.0f, 1.0f / (random.m_188501_() * 0.5f + 1.0f) + power / 2.0f);
        return entityarrow;
    }

    public static ClayBombEntity shoot(LivingEntity entity, LivingEntity target) {
        ClayBombEntity entityarrow = new ClayBombEntity((EntityType<? extends ClayBombEntity>)((EntityType)TheFleshThatHatesModEntities.CLAY_BOMB.get()), entity, entity.m_9236_());
        double dx = target.m_20185_() - entity.m_20185_();
        double dy = target.m_20186_() + (double)target.m_20192_() - 1.1;
        double dz = target.m_20189_() - entity.m_20189_();
        entityarrow.m_6686_(dx, dy - entityarrow.m_20186_() + Math.hypot(dx, dz) * (double)0.2f, dz, 0.8f, 12.0f);
        entityarrow.m_20225_(true);
        entityarrow.m_36781_(0.0);
        entityarrow.m_36735_(0);
        entityarrow.m_36762_(false);
        entity.m_9236_().m_7967_((Entity)entityarrow);
        entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.arrow.shoot")), SoundSource.PLAYERS, 1.0f, 1.0f / (RandomSource.m_216327_().m_188501_() * 0.5f + 1.0f));
        return entityarrow;
    }
}

