/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.thefleshthathates.entity.FleshAIs;

import javax.annotation.Nullable;
import net.mcreator.thefleshthathates.AI.FleshFloatGoal;
import net.mcreator.thefleshthathates.FConfig.TFTHConfiguration;
import net.mcreator.thefleshthathates.FEvents.FleshWorld;
import net.mcreator.thefleshthathates.FleshWallMovement;
import net.mcreator.thefleshthathates.block.FleshBlocks;
import net.mcreator.thefleshthathates.entity.AgroTargetGoal;
import net.mcreator.thefleshthathates.entity.FleshMobs;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.navigation.WallClimberNavigation;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;

public class FleshAI
extends Monster {
    @Nullable
    BlockPos searchPos;
    private long lastHealTime = 0L;

    public FleshAI(EntityType<? extends Monster> type, Level world) {
        super(type, world);
        this.m_21441_(BlockPathTypes.DANGER_FIRE, 16.0f);
        this.m_21441_(BlockPathTypes.DANGER_OTHER, 16.0f);
        if (FleshWorld.getCurrentStage().ordinal() >= FleshWorld.FleshStage.GROWTH_STAGE.ordinal()) {
            this.f_21344_ = new WallClimberNavigation((Mob)this, world);
            this.f_21342_ = new FleshWallMovement((Mob)this);
        }
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    @Nullable
    public BlockPos getSearchPos() {
        return this.searchPos;
    }

    public void setSearchPos(@Nullable BlockPos searchPos) {
        this.searchPos = searchPos;
    }

    public void m_7023_(Vec3 p_32858_) {
        if (this.m_21515_() && this.isInFluidType()) {
            this.m_19920_(0.1f, p_32858_);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_(0.6));
            if (this.m_5448_() == null) {
                this.m_20256_(this.m_20184_().m_82520_(0.0, -0.005, 0.0));
            }
        } else {
            super.m_7023_(p_32858_);
        }
    }

    public void m_6075_() {
        super.m_6075_();
        long currentTime = this.m_9236_().m_46467_();
        BlockPos posInFront = this.m_20183_().m_121945_(this.m_6350_());
        this.breakDoor(posInFront);
        if (currentTime - this.lastHealTime >= 120L) {
            this.lastHealTime = currentTime;
            if (this.isStandingOnHealingBlock() && !this.m_6060_()) {
                this.healBasedOnStage();
            }
        }
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(4, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21346_.m_25352_(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(3, new AgroTargetGoal<LivingEntity>((PathfinderMob)this, LivingEntity.class, true, true, FleshMobs.ENTITY_TYPES));
        this.f_21345_.m_25352_(1, (Goal)new FleshFloatGoal((Mob)this));
    }

    private void breakDoor(BlockPos pos) {
        BlockState blockState;
        if (FleshWorld.getCurrentStage().ordinal() >= FleshWorld.FleshStage.AWARENESS_STAGE.ordinal() && (blockState = this.m_9236_().m_8055_(pos)).m_60734_() instanceof DoorBlock) {
            this.m_9236_().m_46961_(pos, true);
        }
    }

    private boolean isStandingOnHealingBlock() {
        BlockPos blockUnder = new BlockPos((int)this.m_20185_(), (int)(this.m_20186_() - 1.0), (int)this.m_20189_());
        BlockState blockState = this.m_9236_().m_8055_(blockUnder);
        return FleshBlocks.isAllowedBlock(blockState.m_60734_());
    }

    private void healBasedOnStage() {
        double healPercent = 0.0;
        switch (FleshWorld.getCurrentStage()) {
            case GERM_STAGE: {
                healPercent = TFTHConfiguration.getGermStageHealPercent();
                break;
            }
            case AWARENESS_STAGE: {
                healPercent = TFTHConfiguration.getAwarenessStageHealPercent();
                break;
            }
            case GROWTH_STAGE: {
                healPercent = TFTHConfiguration.getGrowthStageHealPercent();
                break;
            }
            case SYNTHESIS_STAGE: {
                healPercent = TFTHConfiguration.getSynthesisStageHealPercent();
                break;
            }
            case EPITASIS_STAGE: {
                healPercent = TFTHConfiguration.getEpitasisStageHealPercent();
                break;
            }
            default: {
                return;
            }
        }
        this.m_5634_((float)((double)this.m_21233_() * healPercent));
    }
}

