/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.thefleshthathates.entity;

import java.util.List;
import java.util.Map;
import net.mcreator.thefleshthathates.FConfig.TFTHConfiguration;
import net.mcreator.thefleshthathates.client.animation.HandleAnimations;
import net.mcreator.thefleshthathates.entity.FleshMobs;
import net.mcreator.thefleshthathates.entity.mobtypes.AwarenessMob;
import net.mcreator.thefleshthathates.init.TheFleshThatHatesModEntities;
import net.mcreator.thefleshthathates.init.TheFleshThatHatesModParticleTypes;
import net.mcreator.thefleshthathates.init.TheFleshThatHatesModSounds;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import net.minecraftforge.registries.ForgeRegistries;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class FleshBoomerEntity
extends AwarenessMob
implements GeoEntity {
    public static final EntityDataAccessor<Boolean> SHOOT = SynchedEntityData.m_135353_(FleshBoomerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<String> ANIMATION = SynchedEntityData.m_135353_(FleshBoomerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    public static final EntityDataAccessor<String> TEXTURE = SynchedEntityData.m_135353_(FleshBoomerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private boolean swinging;
    private boolean lastloop;
    private long lastSwing;
    private int animationCountDown = 0;
    public String animationprocedure = "empty";
    private boolean spawnPlaqueMinators;
    private int boomTimer = -1;
    private static final RawAnimation BOOM_ANIMATION = RawAnimation.begin().thenPlay("boom");
    private final AnimationController BOOM_ANIMATION_CONTROLLER = new AnimationController((GeoAnimatable)this, "boom_controller", state -> PlayState.STOP).triggerableAnim("boom_animation", BOOM_ANIMATION);
    private static final int BOOM_ANIMATION_DURATION = 10;

    public FleshBoomerEntity(PlayMessages.SpawnEntity packet, Level world) {
        this((EntityType<FleshBoomerEntity>)((EntityType)TheFleshThatHatesModEntities.FLESH_BOOMER.get()), world);
    }

    public FleshBoomerEntity(EntityType<FleshBoomerEntity> type, Level world) {
        super(type, world);
        this.f_21364_ = 0;
        this.m_21557_(false);
        this.m_21530_();
        this.spawnPlaqueMinators = world.f_46441_.m_188503_(100) < 30;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SHOOT, (Object)false);
        this.f_19804_.m_135372_(ANIMATION, (Object)"undefined");
        this.f_19804_.m_135372_(TEXTURE, (Object)"flesh_boomer");
    }

    public void setTexture(String texture) {
        this.f_19804_.m_135381_(TEXTURE, (Object)texture);
    }

    public String getTexture() {
        return (String)this.f_19804_.m_135370_(TEXTURE);
    }

    @Override
    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, new Goal(){

            public boolean m_8036_() {
                boolean result = FleshBoomerEntity.this.m_5448_() != null && FleshBoomerEntity.this.m_5448_().m_20270_((Entity)FleshBoomerEntity.this) <= 3.0f;
                return result;
            }

            public void m_8056_() {
                FleshBoomerEntity.this.boomTimer = 15;
            }
        });
        this.f_21345_.m_25352_(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
    }

    public MobType m_6336_() {
        return MobType.f_21640_;
    }

    public boolean m_6785_(double distanceToClosestPlayer) {
        return false;
    }

    protected SoundEvent m_7515_() {
        RandomSource random = RandomSource.m_216327_();
        int randomSoundIndex = random.m_188503_(3);
        switch (randomSoundIndex) {
            case 0: {
                return (SoundEvent)TheFleshThatHatesModSounds.BOOMER_A1.get();
            }
            case 1: {
                return (SoundEvent)TheFleshThatHatesModSounds.BOOMER_A2.get();
            }
            case 2: {
                return (SoundEvent)TheFleshThatHatesModSounds.BOOMER_A3.get();
            }
        }
        return (SoundEvent)TheFleshThatHatesModSounds.BOOMER_A1.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        RandomSource random = RandomSource.m_216327_();
        int randomSoundIndex = random.m_188503_(2);
        switch (randomSoundIndex) {
            case 0: {
                return (SoundEvent)TheFleshThatHatesModSounds.FLESH_HIT.get();
            }
        }
        return (SoundEvent)TheFleshThatHatesModSounds.FLESH_HIT.get();
    }

    private void playBoomSound() {
        this.m_5496_((SoundEvent)TheFleshThatHatesModSounds.BOOMER_EXPL1.get(), 3.0f, 1.0f);
    }

    public SoundEvent m_5592_() {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.generic.death"));
    }

    @Override
    public void m_6075_() {
        super.m_6075_();
        this.m_6210_();
    }

    public EntityDimensions m_6972_(Pose p_33597_) {
        return super.m_6972_(p_33597_).m_20388_(1.0f);
    }

    public static void init() {
    }

    public static AttributeSupplier.Builder createAttributes() {
        Map<String, Double> attributesMap = TheFleshThatHatesModEntities.parseAttributesConfig((String)TFTHConfiguration.FLESH_BOOMER_STATS.get());
        return Mob.m_21552_().m_22268_(Attributes.f_22279_, 0.3).m_22268_(Attributes.f_22276_, attributesMap.getOrDefault("MaxHealth", 20.0) * (Double)TFTHConfiguration.GLOBAL_HEALTH.get()).m_22268_(Attributes.f_22284_, attributesMap.getOrDefault("Armor", 0.0) * (Double)TFTHConfiguration.GLOBAL_ARMOR.get()).m_22268_(Attributes.f_22281_, attributesMap.getOrDefault("AttackDamage", 3.0) * (Double)TFTHConfiguration.GLOBAL_DAMAGE.get()).m_22268_(Attributes.f_22277_, 24.0).m_22268_(Attributes.f_22278_, 0.0);
    }

    protected void m_6153_() {
        ++this.f_20919_;
        if (this.f_20919_ == 20) {
            this.m_142687_(Entity.RemovalReason.KILLED);
            this.m_21226_();
        }
    }

    public String getSyncedAnimation() {
        return (String)this.f_19804_.m_135370_(ANIMATION);
    }

    public void setAnimation(String animation) {
        this.f_19804_.m_135381_(ANIMATION, (Object)animation);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        data.add(new AnimationController[]{HandleAnimations.genericWalkIdleController(this)});
        data.add(new AnimationController[]{this.BOOM_ANIMATION_CONTROLLER});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    private void triggerBoomAnimation() {
        this.triggerAnim("boom_controller", "boom_animation");
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if ((double)this.m_21223_() <= 0.1) {
            return false;
        }
        if (super.m_6469_(source, amount)) {
            if (this.m_21223_() <= 0.0f) {
                this.m_21153_(0.1f);
                this.boomTimer = 10;
                this.triggerBoomAnimation();
                return false;
            }
            return true;
        }
        return false;
    }

    private void spawnPlaqueMinators(Level world, double x, double y, double z) {
        for (int i = 0; i < 3; ++i) {
            Entity plaqueContaminator = ((EntityType)TheFleshThatHatesModEntities.PLAQUECONTAMINATOR.get()).m_20615_(world);
            if (plaqueContaminator == null) continue;
            double offsetX = world.f_46441_.m_188583_() * 0.5;
            double offsetY = world.f_46441_.m_188583_() * 0.5;
            double offsetZ = world.f_46441_.m_188583_() * 0.5;
            plaqueContaminator.m_6034_(x + offsetX, y + offsetY, z + offsetZ);
            double motionX = offsetX * 0.5;
            double motionY = 0.5;
            double motionZ = offsetZ * 0.5;
            plaqueContaminator.m_20334_(motionX, motionY, motionZ);
            world.m_7967_(plaqueContaminator);
        }
    }

    public void m_8119_() {
        super.m_8119_();
        Level world = this.m_9236_();
        LivingEntity target = this.m_5448_();
        if (target != null && this.m_20270_((Entity)target) <= 3.0f) {
            this.triggerBoomAnimation();
        }
        if (this.boomTimer > 0) {
            --this.boomTimer;
        }
        if (this.boomTimer == 0) {
            this.executeExplosionLogic(world);
            this.boomTimer = -1;
        }
    }

    private void executeExplosionLogic(Level world) {
        this.m_142687_(Entity.RemovalReason.KILLED);
        if (world instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)world;
            SimpleParticleType decompositionboom = (SimpleParticleType)TheFleshThatHatesModParticleTypes.DECOMPOSITION_BOOM.get();
            for (int i = 0; i < 100; ++i) {
                double offsetX = world.f_46441_.m_188583_() * 0.5;
                double offsetY = world.f_46441_.m_188583_() * 0.5;
                double offsetZ = world.f_46441_.m_188583_() * 0.5;
                serverLevel.m_8767_((ParticleOptions)decompositionboom, this.m_20208_(1.0) + offsetX, this.m_20187_() + offsetY, this.m_20262_(1.0) + offsetZ, 1, 0.0, 0.0, 0.0, 0.1);
            }
            this.playBoomSound();
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123813_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 10, 0.2, 0.2, 0.2, 0.0);
        }
        if (this.spawnPlaqueMinators) {
            this.spawnPlaqueMinators(world, this.m_20185_(), this.m_20186_(), this.m_20189_());
        }
        AreaEffectCloud cloud = new AreaEffectCloud(world, this.m_20185_(), this.m_20186_(), this.m_20189_());
        cloud.m_19712_(5.0f);
        cloud.m_19734_(200);
        SimpleParticleType decompositionParticle = (SimpleParticleType)TheFleshThatHatesModParticleTypes.DECOMPOSITION_PARTICLE.get();
        cloud.m_19724_((ParticleOptions)decompositionParticle);
        cloud.m_19716_(new MobEffectInstance((MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(new ResourceLocation("the_flesh_that_hates:decomposition")), 160));
        world.m_7967_((Entity)cloud);
        MobEffect decomposition = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(new ResourceLocation("the_flesh_that_hates:decomposition"));
        List nearbyEntities = world.m_45976_(LivingEntity.class, cloud.m_20191_().m_82400_(6.0));
        for (LivingEntity entity : nearbyEntities) {
            int amplifier = 0;
            MobEffectInstance existingEffect = entity.m_21124_(decomposition);
            if (existingEffect != null) {
                amplifier = existingEffect.m_19564_() + 1;
            }
            if (FleshMobs.ENTITY_TYPES.contains(entity.m_6095_())) {
                entity.m_7292_(new MobEffectInstance(decomposition, 600, amplifier));
                continue;
            }
            entity.m_7292_(new MobEffectInstance(decomposition, 160, amplifier));
        }
    }
}

