/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.thefleshthathates.entity;

import java.util.Map;
import net.mcreator.thefleshthathates.FConfig.TFTHConfiguration;
import net.mcreator.thefleshthathates.FEvents.FleshWorld;
import net.mcreator.thefleshthathates.block.FleshBlocks;
import net.mcreator.thefleshthathates.client.animation.HandleAnimations;
import net.mcreator.thefleshthathates.entity.FleshAIs.FleshAI;
import net.mcreator.thefleshthathates.init.TheFleshThatHatesModEntities;
import net.mcreator.thefleshthathates.init.TheFleshThatHatesModSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.util.GeckoLibUtil;

public class FleshCommunityEntity
extends FleshAI
implements GeoEntity {
    public static final EntityDataAccessor<Boolean> SHOOT = SynchedEntityData.m_135353_(FleshCommunityEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<String> ANIMATION = SynchedEntityData.m_135353_(FleshCommunityEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    public static final EntityDataAccessor<String> TEXTURE = SynchedEntityData.m_135353_(FleshCommunityEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private boolean lastloop;
    public String animationprocedure = "empty";
    private static final double BASE_HEALTH = 50.0;
    private static final double BASE_ATTACK_DAMAGE = 8.0;

    public FleshCommunityEntity(PlayMessages.SpawnEntity packet, Level world) {
        this((EntityType<FleshCommunityEntity>)((EntityType)TheFleshThatHatesModEntities.FLESH_COMMUNITY.get()), world);
    }

    public FleshCommunityEntity(EntityType<FleshCommunityEntity> type, Level world) {
        super(type, world);
        this.f_21364_ = 0;
        this.m_21557_(false);
        this.m_21530_();
        this.adjustAttributesBasedOnPoints();
        this.m_21153_(this.m_21233_());
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SHOOT, (Object)false);
        this.f_19804_.m_135372_(ANIMATION, (Object)"undefined");
        this.f_19804_.m_135372_(TEXTURE, (Object)"flesh_comminity");
    }

    public void setTexture(String texture) {
        this.f_19804_.m_135381_(TEXTURE, (Object)texture);
    }

    public String getTexture() {
        return (String)this.f_19804_.m_135370_(TEXTURE);
    }

    public String getSyncedAnimation() {
        return (String)this.f_19804_.m_135370_(ANIMATION);
    }

    public void setAnimation(String animation) {
        this.f_19804_.m_135381_(ANIMATION, (Object)animation);
    }

    @Override
    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.2, false){

            protected double m_6639_(LivingEntity entity) {
                return 8.0 + (double)(entity.m_20205_() * entity.m_20205_());
            }
        });
    }

    public MobType m_6336_() {
        return MobType.f_21640_;
    }

    public boolean m_6785_(double distanceToClosestPlayer) {
        return false;
    }

    protected SoundEvent m_7515_() {
        RandomSource random = RandomSource.m_216327_();
        int randomSoundIndex = random.m_188503_(3);
        switch (randomSoundIndex) {
            case 0: {
                return (SoundEvent)TheFleshThatHatesModSounds.COMM_AM1.get();
            }
            case 1: {
                return (SoundEvent)TheFleshThatHatesModSounds.COMM_AM2.get();
            }
            case 2: {
                return (SoundEvent)TheFleshThatHatesModSounds.COMM_AM3.get();
            }
        }
        return (SoundEvent)TheFleshThatHatesModSounds.COMM_AM1.get();
    }

    public void m_8032_() {
        SoundEvent ambientSound = this.m_7515_();
        if (ambientSound != null) {
            this.m_5496_(ambientSound, 2.0f, 1.0f);
        }
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        RandomSource random = RandomSource.m_216327_();
        int randomSoundIndex = random.m_188503_(1);
        switch (randomSoundIndex) {
            case 0: {
                return (SoundEvent)TheFleshThatHatesModSounds.COMM_HURT.get();
            }
        }
        return (SoundEvent)TheFleshThatHatesModSounds.COMM_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)TheFleshThatHatesModSounds.COMM_DEATH.get();
    }

    private void playAggressionSound() {
        RandomSource random = RandomSource.m_216327_();
        int randomSoundIndex = random.m_188503_(2);
        SoundEvent soundEvent = randomSoundIndex == 0 ? (SoundEvent)TheFleshThatHatesModSounds.COMM_AGR1.get() : (SoundEvent)TheFleshThatHatesModSounds.COMM_AGR2.get();
        this.m_5496_(soundEvent, 2.0f, 1.0f);
    }

    public static void init() {
    }

    public static AttributeSupplier.Builder createAttributes() {
        Map<String, Double> attributesMap = TheFleshThatHatesModEntities.parseAttributesConfig((String)TFTHConfiguration.FLESH_COMMUNITY_STATS.get());
        return Mob.m_21552_().m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22276_, 50.0 * attributesMap.getOrDefault("MaxHealthMultiplier", 1.0) * (Double)TFTHConfiguration.GLOBAL_HEALTH.get()).m_22268_(Attributes.f_22284_, attributesMap.getOrDefault("Armor", 0.0) * (Double)TFTHConfiguration.GLOBAL_ARMOR.get()).m_22268_(Attributes.f_22281_, 8.0 * attributesMap.getOrDefault("AttackDamageMultiplier", 1.0) * (Double)TFTHConfiguration.GLOBAL_DAMAGE.get()).m_22268_(Attributes.f_22277_, 42.0).m_22268_(Attributes.f_22278_, 0.6);
    }

    protected void m_6153_() {
        ++this.f_20919_;
        if (this.f_20919_ == 20) {
            this.m_142687_(Entity.RemovalReason.KILLED);
            this.m_21226_();
        }
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        data.add(new AnimationController[]{HandleAnimations.genericWalkIdleController(this)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public boolean m_7327_(Entity target) {
        if (super.m_7327_(target)) {
            if (!this.m_6060_() && target instanceof LivingEntity) {
                this.m_5634_(16.0f);
            }
            return true;
        }
        return false;
    }

    @Override
    public void m_6075_() {
        super.m_6075_();
        this.adjustAttributesBasedOnPoints();
        if (this.m_5912_() && !this.f_20911_) {
            this.playAggressionSound();
            this.f_20911_ = true;
        } else if (!this.m_5912_()) {
            this.f_20911_ = false;
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.f_19797_ % 40 == 0) {
            this.breakBlocksInFront();
        }
    }

    private void adjustAttributesBasedOnPoints() {
        int points = FleshWorld.getPoints();
        double healthScaleFactor = this.calculateHealthScaleFactor(points);
        double attackDamageScaleFactor = this.calculateAttackDamageScaleFactor(points);
        double currentMaxHealth = this.m_21051_(Attributes.f_22276_).m_22115_();
        double newMaxHealth = 50.0 * healthScaleFactor;
        double healthScaleChangeFactor = newMaxHealth / currentMaxHealth;
        double currentHealth = this.m_21223_();
        double newHealth = Math.min(currentHealth * healthScaleChangeFactor, newMaxHealth);
        this.m_21051_(Attributes.f_22276_).m_22100_(newMaxHealth);
        this.m_21051_(Attributes.f_22281_).m_22100_(8.0 * attackDamageScaleFactor);
        this.m_21153_((float)newHealth);
    }

    private double calculateHealthScaleFactor(int points) {
        return 1.0 + (double)(points / 10) * 0.02;
    }

    private double calculateAttackDamageScaleFactor(int points) {
        return 1.0 + (double)(points / 10) * 0.004;
    }

    private void breakBlocksInFront() {
        if (this.m_5448_() != null && !this.m_9236_().f_46443_) {
            BlockPos pos = this.m_20183_();
            Vec3 lookVec = this.m_20252_(1.0f);
            int distance = 4;
            for (int dx = -distance; dx <= distance; ++dx) {
                for (int dz = -distance; dz <= distance; ++dz) {
                    for (int dy = 0; dy <= distance; ++dy) {
                        BlockPos targetPos = pos.m_7918_((int)(lookVec.f_82479_ * (double)distance + (double)dx), dy, (int)(lookVec.f_82481_ * (double)distance + (double)dz));
                        BlockState targetState = this.m_9236_().m_8055_(targetPos);
                        Block targetBlock = targetState.m_60734_();
                        if (targetState.m_60795_() || !(targetState.m_60800_((BlockGetter)this.m_9236_(), targetPos) < 0.5f) || FleshBlocks.isModBlock(targetBlock)) continue;
                        this.m_9236_().m_46953_(targetPos, true, (Entity)this);
                    }
                }
            }
        }
    }
}

