/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.thefleshthathates.entity;

import java.util.Map;
import java.util.UUID;
import net.mcreator.thefleshthathates.CustomMeleeAttackGoal;
import net.mcreator.thefleshthathates.FConfig.TFTHConfiguration;
import net.mcreator.thefleshthathates.SyncSpawnControl;
import net.mcreator.thefleshthathates.client.animation.HandleAnimations;
import net.mcreator.thefleshthathates.entity.DelayedDamageManager;
import net.mcreator.thefleshthathates.entity.FleshAIs.FleshAI;
import net.mcreator.thefleshthathates.entity.IDelayedDamage;
import net.mcreator.thefleshthathates.entity.JumpOverFence;
import net.mcreator.thefleshthathates.init.TheFleshThatHatesModEntities;
import net.mcreator.thefleshthathates.init.TheFleshThatHatesModSounds;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class FleshDogEntity
extends FleshAI
implements GeoEntity,
IDelayedDamage {
    public static final EntityDataAccessor<Boolean> SHOOT = SynchedEntityData.m_135353_(FleshDogEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<String> ANIMATION = SynchedEntityData.m_135353_(FleshDogEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    public static final EntityDataAccessor<String> TEXTURE = SynchedEntityData.m_135353_(FleshDogEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private boolean swinging;
    private boolean lastloop;
    private long lastSwing;
    public String animationprocedure = "empty";
    private boolean isOriginal = true;
    private UUID parentUUID = null;
    private final DelayedDamageManager delayedDamageManager;
    private final AnimationController ATTACK_ANIMATION_CONTROLLER = this.createAnimationController("attack_controller", "attack_animation", "attack");

    public FleshDogEntity(PlayMessages.SpawnEntity packet, Level world) {
        this((EntityType<FleshDogEntity>)((EntityType)TheFleshThatHatesModEntities.FLESH_DOG.get()), world);
    }

    public FleshDogEntity(EntityType<FleshDogEntity> type, Level level) {
        super(type, level);
        this.f_21364_ = 0;
        this.m_21557_(false);
        this.m_21530_();
        this.delayedDamageManager = new DelayedDamageManager(this, level, 8);
        if (this.isOriginal) {
            SyncSpawnControl.registerOriginal((Entity)this);
        }
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SHOOT, (Object)false);
        this.f_19804_.m_135372_(ANIMATION, (Object)"undefined");
        this.f_19804_.m_135372_(TEXTURE, (Object)"fleshdog");
    }

    public void setTexture(String texture) {
        this.f_19804_.m_135381_(TEXTURE, (Object)texture);
    }

    public String getTexture() {
        return (String)this.f_19804_.m_135370_(TEXTURE);
    }

    public String getSyncedAnimation() {
        return (String)this.f_19804_.m_135370_(ANIMATION);
    }

    public void setAnimation(String animation) {
        this.f_19804_.m_135381_(ANIMATION, (Object)animation);
    }

    @Override
    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        double normalSpeed = 1.2;
        double aggressiveSpeed = 2.0;
        double attackSpeedMultiplier = 0.5;
        final double customAttackReach = 35.0;
        this.f_21345_.m_25352_(1, (Goal)new CustomMeleeAttackGoal((PathfinderMob)this, normalSpeed, aggressiveSpeed, false, customAttackReach){

            @Override
            protected double getAttackReachSqr(LivingEntity entity) {
                return customAttackReach + (double)(entity.m_20205_() * entity.m_20205_());
            }
        });
        this.f_21345_.m_25352_(7, (Goal)new JumpOverFence((Mob)this));
        this.f_21345_.m_25352_(8, (Goal)new FollowOriginalGoal(this, 1.0));
    }

    @Override
    public void m_6075_() {
        super.m_6075_();
        this.delayedDamageManager.tick();
        if (this.m_5912_() && !this.swinging) {
            this.playAggressionSound();
            this.swinging = true;
        } else if (!this.m_5912_()) {
            this.swinging = false;
        }
    }

    public MobType m_6336_() {
        return MobType.f_21640_;
    }

    public boolean m_6785_(double distanceToClosestPlayer) {
        return false;
    }

    private void playCustomSound(SoundEvent sound, float volume, float pitch) {
        if (sound != null) {
            this.m_5496_(sound, volume, pitch);
        }
    }

    protected SoundEvent m_7515_() {
        RandomSource random = RandomSource.m_216327_();
        switch (random.m_188503_(3)) {
            case 0: {
                return (SoundEvent)TheFleshThatHatesModSounds.DOG_A1.get();
            }
            case 1: {
                return (SoundEvent)TheFleshThatHatesModSounds.DOG_A2.get();
            }
        }
        return (SoundEvent)TheFleshThatHatesModSounds.DOG_A1.get();
    }

    public void m_8032_() {
        this.playCustomSound(this.m_7515_(), 1.0f, 1.0f);
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        RandomSource random = RandomSource.m_216327_();
        switch (random.m_188503_(3)) {
            case 0: {
                return (SoundEvent)TheFleshThatHatesModSounds.DOG_H1.get();
            }
            case 1: {
                return (SoundEvent)TheFleshThatHatesModSounds.DOG_H2.get();
            }
        }
        return (SoundEvent)TheFleshThatHatesModSounds.DOG_H1.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)TheFleshThatHatesModSounds.DOG_DEATH.get();
    }

    private void playAggressionSound() {
        RandomSource random = RandomSource.m_216327_();
        this.playCustomSound(switch (random.m_188503_(3)) {
            case 0 -> (SoundEvent)TheFleshThatHatesModSounds.DOG_AA1.get();
            case 1 -> (SoundEvent)TheFleshThatHatesModSounds.DOG_AA2.get();
            default -> (SoundEvent)TheFleshThatHatesModSounds.DOG_AA1.get();
        }, 1.0f, 1.0f);
    }

    public static AttributeSupplier.Builder createAttributes() {
        Map<String, Double> attributesMap = TheFleshThatHatesModEntities.parseAttributesConfig((String)TFTHConfiguration.DOG_STATS.get());
        return Mob.m_21552_().m_22268_(Attributes.f_22279_, 0.2).m_22268_(Attributes.f_22276_, attributesMap.getOrDefault("MaxHealth", 25.0) * (Double)TFTHConfiguration.GLOBAL_HEALTH.get()).m_22268_(Attributes.f_22284_, attributesMap.getOrDefault("Armor", 0.0) * (Double)TFTHConfiguration.GLOBAL_ARMOR.get()).m_22268_(Attributes.f_22281_, attributesMap.getOrDefault("AttackDamage", 6.0) * (Double)TFTHConfiguration.GLOBAL_DAMAGE.get()).m_22268_(Attributes.f_22277_, 48.0).m_22268_(Attributes.f_22278_, 0.2);
    }

    protected void m_6153_() {
        ++this.f_20919_;
        if (this.f_20919_ == 20) {
            SyncSpawnControl.unregisterEntity((Entity)this);
            this.m_142687_(Entity.RemovalReason.KILLED);
            this.m_21226_();
        }
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        data.add(new AnimationController[]{HandleAnimations.genericWalkIdleController(this)});
        data.add(new AnimationController[]{this.ATTACK_ANIMATION_CONTROLLER});
    }

    private AnimationController createAnimationController(String controllerName, String animationName, String rawAnimationAction) {
        RawAnimation rawAnimation = RawAnimation.begin().thenPlay(rawAnimationAction);
        return new AnimationController((GeoAnimatable)this, controllerName, state -> PlayState.STOP).triggerableAnim(animationName, rawAnimation);
    }

    private void triggerAnimation(String controllerName, String animationName) {
        this.triggerAnim(controllerName, animationName);
    }

    private void triggerAttack() {
        this.triggerAnimation("attack_controller", "attack_animation");
    }

    @Override
    public void triggerDelayedAttack(LivingEntity target) {
        this.triggerAttack();
        this.delayedDamageManager.triggerDelayedAttack(target);
    }

    public boolean m_7327_(Entity target) {
        boolean result = super.m_7327_(target);
        if (result && target instanceof LivingEntity) {
            this.delayedDamageManager.triggerDelayedAttack((LivingEntity)target);
        }
        return result;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    @SubscribeEvent
    public static void onEntityDeath(LivingDeathEvent event) {
        if (event.getSource().m_7639_() instanceof FleshDogEntity) {
            FleshDogEntity newFleshDog;
            UUID parentID;
            FleshDogEntity fleshDog = (FleshDogEntity)event.getSource().m_7639_();
            Level currentLevel = fleshDog.m_9236_();
            UUID uUID = parentID = fleshDog.parentUUID == null ? fleshDog.m_20148_() : fleshDog.parentUUID;
            if (SyncSpawnControl.canSpawnClone((Entity)fleshDog) && SyncSpawnControl.canSpawnClone(parentID) && (newFleshDog = (FleshDogEntity)((EntityType)TheFleshThatHatesModEntities.FLESH_DOG.get()).m_20615_(currentLevel)) != null) {
                newFleshDog.m_7678_(event.getEntity().m_20185_(), event.getEntity().m_20186_(), event.getEntity().m_20189_(), event.getEntity().m_146908_(), event.getEntity().m_146909_());
                newFleshDog.isOriginal = false;
                newFleshDog.parentUUID = parentID;
                SyncSpawnControl.registerClone((Entity)newFleshDog, parentID);
                currentLevel.m_7967_((Entity)newFleshDog);
            }
        }
    }

    private class FollowOriginalGoal
    extends Goal {
        private final FleshDogEntity fleshDogEntity;
        private final double followSpeed;
        private int timeToRecalcPath;

        public FollowOriginalGoal(FleshDogEntity fleshDogEntity2, double followSpeed) {
            this.fleshDogEntity = fleshDogEntity2;
            this.followSpeed = followSpeed;
        }

        public boolean m_8036_() {
            if (this.fleshDogEntity.parentUUID == null) {
                return false;
            }
            Entity parentEntity = this.fleshDogEntity.m_9236_().m_6443_(Entity.class, this.fleshDogEntity.m_20191_().m_82400_(30.0), entity -> entity.m_20148_().equals(this.fleshDogEntity.parentUUID)).stream().findFirst().orElse(null);
            return parentEntity != null && !((double)parentEntity.m_20270_((Entity)this.fleshDogEntity) < 12.0);
        }

        public void m_8056_() {
            this.timeToRecalcPath = 0;
        }

        public void m_8037_() {
            if (--this.timeToRecalcPath <= 0) {
                this.timeToRecalcPath = 10;
                Entity parentEntity = this.fleshDogEntity.m_9236_().m_6443_(Entity.class, this.fleshDogEntity.m_20191_().m_82400_(15.0), entity -> entity.m_20148_().equals(this.fleshDogEntity.parentUUID)).stream().findFirst().orElse(null);
                if (parentEntity != null) {
                    this.fleshDogEntity.m_21573_().m_5624_(parentEntity, this.followSpeed);
                }
            }
        }
    }
}

