/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.thefleshthathates.entity;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import net.mcreator.thefleshthathates.FConfig.TFTHConfiguration;
import net.mcreator.thefleshthathates.FEvents.FleshWorld;
import net.mcreator.thefleshthathates.GermStageMobs;
import net.mcreator.thefleshthathates.client.animation.HandleAnimations;
import net.mcreator.thefleshthathates.entity.FleshMobs;
import net.mcreator.thefleshthathates.entity.mobtypes.AwarenessMob;
import net.mcreator.thefleshthathates.init.TheFleshThatHatesModEntities;
import net.mcreator.thefleshthathates.init.TheFleshThatHatesModSounds;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.util.GeckoLibUtil;

@Mod.EventBusSubscriber
public class FleshHowlerEntity
extends AwarenessMob
implements GeoEntity {
    private static final Logger LOGGER = LogManager.getLogger(FleshHowlerEntity.class);
    public static final EntityDataAccessor<Boolean> SHOOT = SynchedEntityData.m_135353_(FleshHowlerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<String> ANIMATION = SynchedEntityData.m_135353_(FleshHowlerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    public static final EntityDataAccessor<String> TEXTURE = SynchedEntityData.m_135353_(FleshHowlerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private boolean swinging;
    private boolean lastloop;
    private long lastSwing;
    public String animationprocedure = "empty";
    private static final double STOP_DISTANCE_SQUARED = 100.0;
    private int abilityCooldown = 0;
    private static final int COOLDOWN_TICKS = 1200;
    private boolean canUseAbility = true;

    public FleshHowlerEntity(PlayMessages.SpawnEntity packet, Level world) {
        this((EntityType<FleshHowlerEntity>)((EntityType)TheFleshThatHatesModEntities.FLESH_HOWLER.get()), world);
    }

    public FleshHowlerEntity(EntityType<FleshHowlerEntity> type, Level world) {
        super(type, world);
        this.f_21364_ = 0;
        this.m_21557_(false);
        this.m_21530_();
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SHOOT, (Object)false);
        this.f_19804_.m_135372_(ANIMATION, (Object)"undefined");
        this.f_19804_.m_135372_(TEXTURE, (Object)"flesh_howler");
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
    }

    public void m_7350_(EntityDataAccessor<?> key) {
        super.m_7350_(key);
    }

    public void setTexture(String texture) {
        this.f_19804_.m_135381_(TEXTURE, (Object)texture);
    }

    public String getTexture() {
        return (String)this.f_19804_.m_135370_(TEXTURE);
    }

    @Override
    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.2, false){
            private static final double STOP_DISTANCE_SQUARED = 64.0;

            protected double m_6639_(LivingEntity attackTarget) {
                return super.m_6639_(attackTarget);
            }

            public boolean m_8045_() {
                if (this.f_25540_.m_5448_() == null) {
                    return false;
                }
                double distanceToTargetSqr = this.f_25540_.m_20238_(this.f_25540_.m_5448_().m_20182_());
                return !(distanceToTargetSqr < 64.0) && super.m_8045_();
            }
        });
        this.f_21345_.m_25352_(2, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21346_.m_25352_(1, (Goal)new AdvancedHurtByTargetGoal((PathfinderMob)this));
        this.f_21345_.m_25352_(6, (Goal)new CallForHelpGoal(this, 64.0));
    }

    public MobType m_6336_() {
        return MobType.f_21640_;
    }

    public boolean m_6785_(double distanceToClosestPlayer) {
        return false;
    }

    private void playCustomSound(SoundEvent sound, float volume, float pitch) {
        if (sound != null) {
            this.m_5496_(sound, volume, pitch);
        }
    }

    protected SoundEvent m_7515_() {
        RandomSource random = RandomSource.m_216327_();
        switch (random.m_188503_(3)) {
            case 0: {
                return (SoundEvent)TheFleshThatHatesModSounds.HUMAN_A1.get();
            }
            case 1: {
                return (SoundEvent)TheFleshThatHatesModSounds.HUMAN_A2.get();
            }
            case 2: {
                return (SoundEvent)TheFleshThatHatesModSounds.HUMAN_A3.get();
            }
        }
        return (SoundEvent)TheFleshThatHatesModSounds.HUMAN_A1.get();
    }

    public void m_8032_() {
        this.playCustomSound(this.m_7515_(), 1.0f, 0.2f);
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        RandomSource random = RandomSource.m_216327_();
        switch (random.m_188503_(3)) {
            case 0: {
                return (SoundEvent)TheFleshThatHatesModSounds.HUMAN_H1.get();
            }
            case 1: {
                return (SoundEvent)TheFleshThatHatesModSounds.HUMAN_H2.get();
            }
            case 2: {
                return (SoundEvent)TheFleshThatHatesModSounds.HUMAN_H3.get();
            }
        }
        return (SoundEvent)TheFleshThatHatesModSounds.HUMAN_H1.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)TheFleshThatHatesModSounds.HUMAN_DEATH.get();
    }

    @Override
    public void m_6075_() {
        super.m_6075_();
        this.m_6210_();
    }

    public EntityDimensions m_6972_(Pose p_33597_) {
        return super.m_6972_(p_33597_).m_20388_(1.0f);
    }

    public static void init() {
    }

    public static AttributeSupplier.Builder createAttributes() {
        Map<String, Double> attributesMap = TheFleshThatHatesModEntities.parseAttributesConfig((String)TFTHConfiguration.FLESH_HOWLER_STATS.get());
        return Mob.m_21552_().m_22268_(Attributes.f_22279_, 0.2).m_22268_(Attributes.f_22276_, attributesMap.getOrDefault("MaxHealth", 30.0) * (Double)TFTHConfiguration.GLOBAL_HEALTH.get()).m_22268_(Attributes.f_22284_, attributesMap.getOrDefault("Armor", 2.0) * (Double)TFTHConfiguration.GLOBAL_ARMOR.get()).m_22268_(Attributes.f_22281_, attributesMap.getOrDefault("AttackDamage", 0.0) * (Double)TFTHConfiguration.GLOBAL_DAMAGE.get()).m_22268_(Attributes.f_22277_, 48.0).m_22268_(Attributes.f_22278_, 0.2);
    }

    protected void m_6153_() {
        ++this.f_20919_;
        if (this.f_20919_ == 20) {
            this.m_142687_(Entity.RemovalReason.KILLED);
            this.m_21226_();
        }
    }

    public String getSyncedAnimation() {
        return (String)this.f_19804_.m_135370_(ANIMATION);
    }

    public void setAnimation(String animation) {
        this.f_19804_.m_135381_(ANIMATION, (Object)animation);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        data.add(new AnimationController[]{HandleAnimations.genericWalkIdleController(this)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.abilityCooldown > 0) {
            --this.abilityCooldown;
        } else {
            this.canUseAbility = true;
        }
        if (this.canUseAbility && this.m_5448_() != null && FleshWorld.getPoints() >= TFTHConfiguration.getMinPointsForSpawning()) {
            this.spawnMobsNearSelf();
        }
    }

    private void spawnMobsNearSelf() {
        if (this.canUseAbility && this.m_5448_() != null) {
            Level level = this.m_9236_();
            for (int i = 0; i < TFTHConfiguration.getNumberOfMobsToSummon(); ++i) {
                Mob mob;
                EntityType<?> randomEntityType = this.getRandomGermStageMob();
                if (randomEntityType == null || (mob = (Mob)randomEntityType.m_20615_(level)) == null) continue;
                double x = this.m_20185_() + (level.f_46441_.m_188500_() - 0.5) * 4.0;
                double y = this.m_20186_();
                double z = this.m_20189_() + (level.f_46441_.m_188500_() - 0.5) * 4.0;
                mob.m_6027_(x, y, z);
                level.m_7967_((Entity)mob);
            }
            this.abilityCooldown = 1200;
            this.canUseAbility = false;
        }
    }

    private EntityType<?> getRandomGermStageMob() {
        ArrayList mobList = new ArrayList(GermStageMobs.ENTITY_TYPES);
        if (mobList.isEmpty()) {
            return null;
        }
        int randomIndex = this.m_9236_().f_46441_.m_188503_(mobList.size());
        return (EntityType)mobList.get(randomIndex);
    }

    @SubscribeEvent
    public static void onFleshHowlerAttacked(LivingHurtEvent event) {
        LivingEntity attacker;
        if (!(event.getEntity() instanceof FleshHowlerEntity)) {
            return;
        }
        FleshHowlerEntity howler = (FleshHowlerEntity)event.getEntity();
        DamageSource source = event.getSource();
        if (source != null && source.m_7639_() instanceof LivingEntity && (attacker = (LivingEntity)source.m_7639_()) != null && howler.m_20280_((Entity)attacker) > Math.pow(howler.m_21133_(Attributes.f_22277_), 2.0)) {
            howler.m_6710_(attacker);
        }
    }

    public class AdvancedHurtByTargetGoal
    extends HurtByTargetGoal {
        public AdvancedHurtByTargetGoal(PathfinderMob mob) {
            super(mob, new Class[0]);
        }

        protected void m_5766_(Mob mobIn, LivingEntity targetIn) {
            if (mobIn.m_5448_() == null && !mobIn.equals((Object)this.f_26135_)) {
                mobIn.m_6710_(targetIn);
            }
        }

        public void m_8037_() {
            if (this.f_26135_.m_5448_() != null && (!this.f_26135_.m_5448_().m_6084_() || this.f_26135_.m_5448_().m_213877_())) {
                this.f_26135_.m_6710_(null);
            }
        }
    }

    public class CallForHelpGoal
    extends Goal {
        private final FleshHowlerEntity howler;
        private final double radius;
        private int tickCounter = 0;
        private int cooldownTickCounter = 0;

        public CallForHelpGoal(FleshHowlerEntity howler, double radius) {
            this.howler = howler;
            this.radius = radius;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return this.howler.m_5448_() != null && !this.howler.m_9236_().f_46443_;
        }

        public boolean m_8045_() {
            return this.howler.m_5448_() != null && !this.howler.m_9236_().f_46443_;
        }

        public void m_8056_() {
            if (this.cooldownTickCounter <= 0) {
                this.callForHelp();
                this.cooldownTickCounter = 200;
            }
        }

        public void m_8037_() {
            if (this.cooldownTickCounter > 0) {
                --this.cooldownTickCounter;
            }
            if (++this.tickCounter >= 200) {
                this.tickCounter = 0;
                if (this.howler.m_5448_() != null && this.cooldownTickCounter <= 0) {
                    this.callForHelp();
                    this.cooldownTickCounter = 200;
                }
            }
        }

        private void callForHelp() {
            Level level = this.howler.m_9236_();
            List list = level.m_6443_(Mob.class, this.howler.m_20191_().m_82400_(this.radius), mob -> FleshMobs.ENTITY_TYPES.contains(mob.m_6095_()) && mob.m_5448_() == null);
            Collections.shuffle(list);
            list.stream().limit(3L).forEach(mob -> {
                if (mob.m_5448_() == null) {
                    mob.m_6710_(this.howler.m_5448_());
                    double targetX = this.howler.m_5448_().m_20185_();
                    double targetY = this.howler.m_5448_().m_20186_();
                    double targetZ = this.howler.m_5448_().m_20189_();
                    mob.m_21573_().m_26519_(targetX, targetY, targetZ, 1.0);
                }
            });
        }
    }
}

