/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.thefleshthathates.entity;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.mcreator.thefleshthathates.AI.FleshFloatGoal;
import net.mcreator.thefleshthathates.CustomMeleeAttackGoal;
import net.mcreator.thefleshthathates.FConfig.TFTHConfiguration;
import net.mcreator.thefleshthathates.FleshWallMovement;
import net.mcreator.thefleshthathates.block.FleshBlocks;
import net.mcreator.thefleshthathates.client.animation.HandleAnimations;
import net.mcreator.thefleshthathates.entity.DelayedDamageManager;
import net.mcreator.thefleshthathates.entity.FleshMobs;
import net.mcreator.thefleshthathates.entity.IDelayedDamage;
import net.mcreator.thefleshthathates.init.TheFleshThatHatesModEntities;
import net.mcreator.thefleshthathates.init.TheFleshThatHatesModSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.WallClimberNavigation;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import net.minecraftforge.registries.ForgeRegistries;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class FleshHunterThreeEntity
extends Monster
implements GeoEntity,
IDelayedDamage {
    public static final EntityDataAccessor<Boolean> SHOOT = SynchedEntityData.m_135353_(FleshHunterThreeEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<String> ANIMATION = SynchedEntityData.m_135353_(FleshHunterThreeEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    public static final EntityDataAccessor<String> TEXTURE = SynchedEntityData.m_135353_(FleshHunterThreeEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private boolean swinging;
    private boolean lastloop;
    private long lastSwing;
    public String animationprocedure = "empty";
    private Vec3 lastKnownMovementLocation;
    private long lastMovementTime = 0L;
    private int sniffingTimer = 0;
    private static final int SNIFFING_DURATION = 80;
    private final DelayedDamageManager delayedDamageManager;
    private final AnimationController ATTACK_ANIMATION_CONTROLLER = this.createAnimationController("attack_controller", "attack_animation", "attack");
    private LivingEntity target;

    public FleshHunterThreeEntity(PlayMessages.SpawnEntity packet, Level world) {
        this((EntityType<FleshHunterThreeEntity>)((EntityType)TheFleshThatHatesModEntities.FLESH_HUNTER_THREE.get()), world);
    }

    public FleshHunterThreeEntity(EntityType<FleshHunterThreeEntity> type, Level world) {
        super(type, world);
        this.f_21364_ = 0;
        this.m_21557_(false);
        this.delayedDamageManager = new DelayedDamageManager(this, world, 8);
        this.f_21344_ = new WallClimberNavigation((Mob)this, world);
        this.f_21342_ = new FleshWallMovement((Mob)this);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SHOOT, (Object)false);
        this.f_19804_.m_135372_(ANIMATION, (Object)"undefined");
        this.f_19804_.m_135372_(TEXTURE, (Object)"flesh_hunter_three");
    }

    public void setTexture(String texture) {
        this.f_19804_.m_135381_(TEXTURE, (Object)texture);
    }

    public String getTexture() {
        return (String)this.f_19804_.m_135370_(TEXTURE);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public boolean m_6785_(double distanceToClosestPlayer) {
        return false;
    }

    protected void m_8099_() {
        super.m_8099_();
        double normalSpeed = 1.2;
        double aggressiveSpeed = 2.2;
        final double customAttackReach = 65.0;
        this.f_21345_.m_25352_(1, (Goal)new CustomMeleeAttackGoal((PathfinderMob)this, normalSpeed, aggressiveSpeed, false, customAttackReach){

            @Override
            protected double getAttackReachSqr(LivingEntity entity) {
                return customAttackReach + (double)(entity.m_20205_() * entity.m_20205_());
            }
        });
        this.f_21345_.m_25352_(2, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21346_.m_25352_(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21345_.m_25352_(5, (Goal)new FleshFloatGoal((Mob)this));
        this.f_21346_.m_25352_(6, (Goal)new FleshHunterTargetGoal(this, true, false));
    }

    public MobType m_6336_() {
        return MobType.f_21640_;
    }

    private void playCustomSound(SoundEvent sound, float volume, float pitch) {
        if (sound != null) {
            this.m_5496_(sound, volume, pitch);
        }
    }

    protected SoundEvent m_7515_() {
        RandomSource random = RandomSource.m_216327_();
        switch (random.m_188503_(3)) {
            case 0: {
                return (SoundEvent)TheFleshThatHatesModSounds.UNSEEN_A1.get();
            }
            case 1: {
                return (SoundEvent)TheFleshThatHatesModSounds.UNSEEN_A2.get();
            }
            case 2: {
                return (SoundEvent)TheFleshThatHatesModSounds.UNSEEN_A3.get();
            }
        }
        return (SoundEvent)TheFleshThatHatesModSounds.UNSEEN_A1.get();
    }

    public void m_8032_() {
        this.playCustomSound(this.m_7515_(), 3.0f, 1.0f);
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        RandomSource random = RandomSource.m_216327_();
        switch (random.m_188503_(3)) {
            case 0: {
                return (SoundEvent)TheFleshThatHatesModSounds.FLESH_HIT.get();
            }
        }
        return (SoundEvent)TheFleshThatHatesModSounds.FLESH_HIT.get();
    }

    public void m_6677_(DamageSource source) {
        this.playCustomSound(this.m_7975_(source), 1.0f, 1.0f);
    }

    public SoundEvent m_5592_() {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.generic.death"));
    }

    private void playAggressionSound() {
        RandomSource random = RandomSource.m_216327_();
        this.playCustomSound(switch (random.m_188503_(3)) {
            case 0 -> (SoundEvent)TheFleshThatHatesModSounds.UNSEEN_SENS1.get();
            case 1 -> (SoundEvent)TheFleshThatHatesModSounds.UNSEEN_SENS2.get();
            case 2 -> (SoundEvent)TheFleshThatHatesModSounds.UNSEEN_SENS3.get();
            default -> (SoundEvent)TheFleshThatHatesModSounds.UNSEEN_SENS1.get();
        }, 1.0f, 1.0f);
    }

    public EntityDimensions m_6972_(Pose pose) {
        return EntityDimensions.m_20395_((float)1.5f, (float)3.3f);
    }

    public static void init() {
    }

    public static AttributeSupplier.Builder createAttributes() {
        Map<String, Double> attributesMap = TheFleshThatHatesModEntities.parseAttributesConfig((String)TFTHConfiguration.FLESH_HUNTER_THREE_STATS.get());
        return Mob.m_21552_().m_22268_(Attributes.f_22279_, 0.2).m_22268_(Attributes.f_22276_, attributesMap.getOrDefault("MaxHealth", 100.0) * (Double)TFTHConfiguration.GLOBAL_HEALTH.get()).m_22268_(Attributes.f_22284_, attributesMap.getOrDefault("Armor", 10.0) * (Double)TFTHConfiguration.GLOBAL_ARMOR.get()).m_22268_(Attributes.f_22281_, attributesMap.getOrDefault("AttackDamage", 14.0) * (Double)TFTHConfiguration.GLOBAL_DAMAGE.get()).m_22268_(Attributes.f_22277_, 16.0).m_22268_(Attributes.f_22278_, 1.0);
    }

    protected void m_6153_() {
        ++this.f_20919_;
        if (this.f_20919_ == 20) {
            this.m_142687_(Entity.RemovalReason.KILLED);
            this.m_21226_();
        }
    }

    public String getSyncedAnimation() {
        return (String)this.f_19804_.m_135370_(ANIMATION);
    }

    public void setAnimation(String animation) {
        this.f_19804_.m_135381_(ANIMATION, (Object)animation);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        data.add(new AnimationController[]{HandleAnimations.genericWalkIdleAgrWalkController(this)});
        data.add(new AnimationController[]{this.ATTACK_ANIMATION_CONTROLLER});
    }

    public void m_6075_() {
        super.m_6075_();
        this.m_6210_();
        this.delayedDamageManager.tick();
    }

    private AnimationController createAnimationController(String controllerName, String animationName, String rawAnimationAction) {
        RawAnimation rawAnimation = RawAnimation.begin().thenPlay(rawAnimationAction);
        return new AnimationController((GeoAnimatable)this, controllerName, state -> PlayState.STOP).triggerableAnim(animationName, rawAnimation);
    }

    private void triggerAnimation(String controllerName, String animationName) {
        this.triggerAnim(controllerName, animationName);
    }

    private void triggerAttack1() {
        this.triggerAnimation("attack_controller", "attack_animation");
    }

    @Override
    public void triggerDelayedAttack(LivingEntity target) {
        this.triggerAttack1();
        this.delayedDamageManager.triggerDelayedAttack(target);
    }

    public boolean m_7327_(Entity target) {
        boolean result = super.m_7327_(target);
        if (result && target instanceof LivingEntity) {
            this.delayedDamageManager.triggerDelayedAttack((LivingEntity)target);
        }
        return result;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.f_19797_ % 80 == 0) {
            this.breakBlocksInFront();
        }
        if (this.m_5448_() == null) {
            List potentialDistantTargets = this.m_9236_().m_6443_(LivingEntity.class, this.m_20191_().m_82400_(52.0), target -> !FleshMobs.ENTITY_TYPES.contains(target.m_6095_()) && FleshHunterThreeEntity.isTargetOnFleshBlock(target, (Mob)this) && target.m_20184_().m_82556_() > 0.0);
            Iterator iterator = potentialDistantTargets.iterator();
            if (iterator.hasNext()) {
                LivingEntity target2 = (LivingEntity)iterator.next();
                this.updateLastKnownMovementLocation(target2.m_20182_());
            }
            if (this.lastKnownMovementLocation != null) {
                if (this.m_9236_().m_46467_() - this.lastMovementTime > 120L) {
                    this.lastKnownMovementLocation = null;
                } else if (!this.m_20182_().m_82509_((Position)this.lastKnownMovementLocation, 1.0)) {
                    this.m_21573_().m_26519_(this.lastKnownMovementLocation.f_82479_, this.lastKnownMovementLocation.f_82480_, this.lastKnownMovementLocation.f_82481_, 1.0);
                } else {
                    this.sniffForTargets();
                    this.lastKnownMovementLocation = null;
                }
            }
        }
    }

    private void sniffForTargets() {
        List nearbyEntities = this.m_9236_().m_6443_(LivingEntity.class, this.m_20191_().m_82400_(6.0), e -> !FleshMobs.ENTITY_TYPES.contains(e.m_6095_()));
        if (!nearbyEntities.isEmpty()) {
            this.m_6710_((LivingEntity)nearbyEntities.get(0));
        }
    }

    public void updateLastKnownMovementLocation(Vec3 location) {
        this.lastKnownMovementLocation = location;
        this.lastMovementTime = this.m_9236_().m_46467_();
    }

    private static boolean isTargetOnFleshBlock(LivingEntity target, Mob mob) {
        BlockPos pos = target.m_20183_().m_7495_();
        BlockState blockUnderTarget = mob.m_9236_().m_8055_(pos);
        return FleshBlocks.isAllowedBlock(blockUnderTarget.m_60734_());
    }

    private void breakBlocksInFront() {
        if (this.m_5448_() != null && !this.m_9236_().f_46443_) {
            BlockPos pos = this.m_20183_();
            Vec3 lookVec = this.m_20252_(1.0f);
            int distance = 4;
            for (int dx = -distance; dx <= distance; ++dx) {
                for (int dz = -distance; dz <= distance; ++dz) {
                    for (int dy = 0; dy <= distance; ++dy) {
                        BlockPos targetPos = pos.m_7918_((int)(lookVec.f_82479_ * (double)distance + (double)dx), dy, (int)(lookVec.f_82481_ * (double)distance + (double)dz));
                        BlockState targetState = this.m_9236_().m_8055_(targetPos);
                        Block targetBlock = targetState.m_60734_();
                        if (targetState.m_60795_() || !(targetState.m_60800_((BlockGetter)this.m_9236_(), targetPos) < 1.0f) || FleshBlocks.isModBlock(targetBlock)) continue;
                        this.m_9236_().m_46953_(targetPos, true, (Entity)this);
                    }
                }
            }
        }
    }

    public class FleshHunterTargetGoal
    extends NearestAttackableTargetGoal<LivingEntity> {
        private static final Set<EntityType<?>> entityTypesToIgnore = FleshMobs.ENTITY_TYPES;
        private static final double MIN_MOVEMENT_THRESHOLD = 0.1;

        public FleshHunterTargetGoal(FleshHunterThreeEntity mob, boolean mustSee, boolean mustReach) {
            super((Mob)mob, LivingEntity.class, 10, mustSee, mustReach, target -> {
                boolean isTargetMoving;
                if (entityTypesToIgnore.contains(target.m_6095_())) {
                    return false;
                }
                Vec3 targetMovement = target.m_20184_();
                boolean bl = isTargetMoving = targetMovement.m_82556_() > 0.010000000000000002;
                if (!isTargetMoving) {
                    return false;
                }
                BlockPos pos = target.m_20183_().m_7495_();
                BlockState blockUnderTarget = mob.m_9236_().m_8055_(pos);
                boolean isOnFleshBlock = FleshBlocks.isAllowedBlock(blockUnderTarget.m_60734_());
                return isOnFleshBlock;
            });
        }
    }
}

