/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.thefleshthathates.entity;

import java.util.List;
import java.util.Map;
import net.mcreator.thefleshthathates.AwarenessStageMobs;
import net.mcreator.thefleshthathates.FConfig.TFTHConfiguration;
import net.mcreator.thefleshthathates.client.animation.HandleAnimations;
import net.mcreator.thefleshthathates.entity.FleshCocoonEntity;
import net.mcreator.thefleshthathates.entity.FleshMobs;
import net.mcreator.thefleshthathates.init.TheFleshThatHatesModEntities;
import net.mcreator.thefleshthathates.init.TheFleshThatHatesModSounds;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

@Mod.EventBusSubscriber
public class FleshJusticeEntity
extends Monster
implements GeoEntity {
    public static final EntityDataAccessor<Boolean> SHOOT = SynchedEntityData.m_135353_(FleshJusticeEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<String> ANIMATION = SynchedEntityData.m_135353_(FleshJusticeEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    public static final EntityDataAccessor<String> TEXTURE = SynchedEntityData.m_135353_(FleshJusticeEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private boolean swinging;
    private boolean lastloop;
    private long lastSwing;
    public String animationprocedure = "empty";
    private static final int TIME_LIMIT = 500;
    private long lastDeathTime = 0L;
    private int cocoonCount = 0;
    private final AnimationController ATTACK_ANIMATION_CONTROLLER = this.createAnimationController("attack_controller", "attack_animation", "appear");
    private final AnimationController ATTACK2_ANIMATION_CONTROLLER = this.createAnimationController("attack2_controller", "attack2_animation", "disappear");

    public FleshJusticeEntity(PlayMessages.SpawnEntity packet, Level world) {
        this((EntityType<FleshJusticeEntity>)((EntityType)TheFleshThatHatesModEntities.FLESH_JUSTICE.get()), world);
    }

    public FleshJusticeEntity(EntityType<FleshJusticeEntity> type, Level world) {
        super(type, world);
        this.f_21364_ = 0;
        this.m_21557_(false);
        this.m_21530_();
        this.lastDeathTime = world.m_46467_();
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SHOOT, (Object)false);
        this.f_19804_.m_135372_(ANIMATION, (Object)"undefined");
        this.f_19804_.m_135372_(TEXTURE, (Object)"flesh_justice");
    }

    public void setTexture(String texture) {
        this.f_19804_.m_135381_(TEXTURE, (Object)texture);
    }

    public String getTexture() {
        return (String)this.f_19804_.m_135370_(TEXTURE);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(5, (Goal)new FloatGoal((Mob)this));
    }

    public MobType m_6336_() {
        return MobType.f_21640_;
    }

    public boolean m_6785_(double distanceToClosestPlayer) {
        return false;
    }

    protected SoundEvent m_7515_() {
        RandomSource random = RandomSource.m_216327_();
        int randomSoundIndex = random.m_188503_(3);
        switch (randomSoundIndex) {
            case 0: {
                return (SoundEvent)TheFleshThatHatesModSounds.JUSTICE_A1.get();
            }
            case 1: {
                return (SoundEvent)TheFleshThatHatesModSounds.JUSTICE_A2.get();
            }
            case 2: {
                return (SoundEvent)TheFleshThatHatesModSounds.JUSTICE_A3.get();
            }
        }
        return (SoundEvent)TheFleshThatHatesModSounds.JUSTICE_A1.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        RandomSource random = RandomSource.m_216327_();
        int randomSoundIndex = random.m_188503_(2);
        switch (randomSoundIndex) {
            case 0: {
                return (SoundEvent)TheFleshThatHatesModSounds.JUSTICE_H1.get();
            }
            case 1: {
                return (SoundEvent)TheFleshThatHatesModSounds.JUSTICE_H2.get();
            }
        }
        return (SoundEvent)TheFleshThatHatesModSounds.JUSTICE_H1.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)TheFleshThatHatesModSounds.JUSTICE_DEATH.get();
    }

    public void m_6075_() {
        super.m_6075_();
        this.m_6210_();
        long currentTime = this.m_9236_().m_46467_();
        if (currentTime - this.lastDeathTime > 460L) {
            this.triggerDespawn();
        }
        if (currentTime - this.lastDeathTime > 500L) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }

    public EntityDimensions m_6972_(Pose p_33597_) {
        return super.m_6972_(p_33597_).m_20388_(1.0f);
    }

    public static void init() {
    }

    public static AttributeSupplier.Builder createAttributes() {
        Map<String, Double> attributesMap = TheFleshThatHatesModEntities.parseAttributesConfig((String)TFTHConfiguration.FLESH_JUSTICE_STATS.get());
        return Mob.m_21552_().m_22268_(Attributes.f_22279_, 0.0).m_22268_(Attributes.f_22276_, attributesMap.getOrDefault("MaxHealth", 35.0) * (Double)TFTHConfiguration.GLOBAL_HEALTH.get()).m_22268_(Attributes.f_22284_, attributesMap.getOrDefault("Armor", 4.0) * (Double)TFTHConfiguration.GLOBAL_ARMOR.get()).m_22268_(Attributes.f_22281_, attributesMap.getOrDefault("AttackDamage", 0.0) * (Double)TFTHConfiguration.GLOBAL_DAMAGE.get()).m_22268_(Attributes.f_22277_, 0.0).m_22268_(Attributes.f_22278_, 2.0);
    }

    protected void m_6153_() {
        ++this.f_20919_;
        if (this.f_20919_ == 20) {
            this.m_142687_(Entity.RemovalReason.KILLED);
            this.m_21226_();
        }
    }

    public String getSyncedAnimation() {
        return (String)this.f_19804_.m_135370_(ANIMATION);
    }

    public void setAnimation(String animation) {
        this.f_19804_.m_135381_(ANIMATION, (Object)animation);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        data.add(new AnimationController[]{HandleAnimations.genericIdleController(this)});
        data.add(new AnimationController[]{this.ATTACK_ANIMATION_CONTROLLER});
        data.add(new AnimationController[]{this.ATTACK2_ANIMATION_CONTROLLER});
    }

    private AnimationController createAnimationController(String controllerName, String animationName, String rawAnimationAction) {
        RawAnimation rawAnimation = RawAnimation.begin().thenPlay(rawAnimationAction);
        return new AnimationController((GeoAnimatable)this, controllerName, state -> PlayState.STOP).triggerableAnim(animationName, rawAnimation);
    }

    private void triggerAnimation(String controllerName, String animationName) {
        this.triggerAnim(controllerName, animationName);
    }

    private void triggerSpawn() {
        this.triggerAnimation("attack_controller", "attack_animation");
    }

    private void triggerDespawn() {
        this.triggerAnimation("attack2_controller", "attack2_animation");
    }

    private void resetDisappearTimer(Level world) {
        this.lastDeathTime = world.m_46467_();
    }

    public boolean m_6094_() {
        return false;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    @SubscribeEvent
    public static void onLivingDeath(LivingDeathEvent event) {
        LivingEntity deadEntity = event.getEntity();
        Level world = deadEntity.m_9236_();
        if (!world.f_46443_) {
            List fleshJustices = world.m_45976_(FleshJusticeEntity.class, deadEntity.m_20191_().m_82400_(32.0));
            for (FleshJusticeEntity fleshJustice : fleshJustices) {
                fleshJustice.resetDisappearTimer(world);
                if (FleshJusticeEntity.isExcludedEntity(deadEntity)) continue;
                if (FleshMobs.isFleshEntity((Entity)deadEntity)) {
                    fleshJustice.createAndStoreFleshCocoon(deadEntity);
                    continue;
                }
                fleshJustice.increaseCocoonCount();
            }
        }
    }

    private void increaseCocoonCount() {
        if (this.cocoonCount < 3) {
            ++this.cocoonCount;
        }
    }

    private static boolean isExcludedEntity(LivingEntity entity) {
        EntityType entityType = entity.m_6095_();
        return entityType == TheFleshThatHatesModEntities.FLESH_JUSTICE.get() || entityType == TheFleshThatHatesModEntities.FLESH_COCOON.get() || entityType == TheFleshThatHatesModEntities.FLESH_PIECE.get() || entityType == TheFleshThatHatesModEntities.PLAQUEINCUBATORSTART.get() || entityType == TheFleshThatHatesModEntities.PLAQUEINCUBATORONE.get() || entityType == TheFleshThatHatesModEntities.FLESH_SERVANT.get();
    }

    public void createAndStoreFleshCocoon(LivingEntity entity) {
        int requiredCocoonCharges;
        boolean isAwarenessStageMob = AwarenessStageMobs.ENTITY_TYPES.contains(entity.m_6095_());
        int n = requiredCocoonCharges = isAwarenessStageMob ? 2 : 1;
        if (this.cocoonCount + requiredCocoonCharges <= 3) {
            FleshCocoonEntity cocoon = new FleshCocoonEntity((EntityType<FleshCocoonEntity>)((EntityType)TheFleshThatHatesModEntities.FLESH_COCOON.get()), this.m_9236_());
            cocoon.setStoredMobType(entity.m_6095_());
            cocoon.m_6034_(this.m_20185_(), this.m_20186_(), this.m_20189_());
            this.m_9236_().m_7967_((Entity)cocoon);
            this.cocoonCount += requiredCocoonCharges;
        }
    }

    public void onAddedToWorld() {
        super.onAddedToWorld();
        this.triggerSpawn();
    }
}

