/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.thefleshthathates.entity;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.pathfinder.Path;

public class FleshNavigation
extends GroundPathNavigation {
    private final PathfinderMob mob;
    private final Level world;

    public FleshNavigation(PathfinderMob mob, Level world) {
        super((Mob)mob, world);
        this.mob = mob;
        this.world = world;
    }

    @Nullable
    public Path m_7864_(BlockPos targetPos, int maxDistance) {
        BlockPos alternativeTarget;
        if (this.shouldFindAlternativePath(targetPos) && (alternativeTarget = this.findAlternativeTarget(targetPos)) != null) {
            return super.m_7864_(alternativeTarget, maxDistance);
        }
        return super.m_7864_(targetPos, maxDistance);
    }

    private boolean shouldFindAlternativePath(BlockPos targetPos) {
        return !this.isPathSafe(targetPos, 10);
    }

    private boolean isPathSafe(BlockPos pos, int distance) {
        for (int i = 0; i < distance; ++i) {
            BlockPos currentPos = pos.m_7918_(0, -i, 0);
            if (this.isBlockSafeForWalking((BlockGetter)this.world, currentPos)) continue;
            return false;
        }
        return true;
    }

    private boolean isBlockSafeForWalking(BlockGetter world, BlockPos pos) {
        return world.m_8055_(pos).m_60713_(Blocks.f_50016_) && world.m_8055_(pos.m_7495_()).m_60804_(world, pos.m_7495_());
    }

    private BlockPos findAlternativeTarget(BlockPos originalTarget) {
        int radius = 5;
        for (BlockPos pos : BlockPos.m_121940_((BlockPos)originalTarget.m_7918_(-radius, -radius, -radius), (BlockPos)originalTarget.m_7918_(radius, radius, radius))) {
            if (!this.isPathSafe(pos, radius)) continue;
            return pos;
        }
        return originalTarget;
    }
}

