/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.thefleshthathates.entity.mobtypes;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import net.mcreator.thefleshthathates.AwarenessStageMobs;
import net.mcreator.thefleshthathates.FConfig.TFTHConfiguration;
import net.mcreator.thefleshthathates.FEvents.FleshWorld;
import net.mcreator.thefleshthathates.entity.FleshAIs.FleshAI;
import net.mcreator.thefleshthathates.helpers.TimeHelper;
import net.mcreator.thefleshthathates.init.TheFleshThatHatesModParticleTypes;
import net.mcreator.thefleshthathates.potion.OneOfUsMobEffect;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;

public class GermMob
extends FleshAI {
    private boolean hasMadeKill = false;
    private boolean isBumping = false;
    private boolean hasTransformed = false;
    private long bumpingStartTime = 0L;
    private long killTime = 0L;
    private int killCount = 0;
    private static final int CALL_DELAY = 300;
    private static final int TRANSFORM_DELAY = 200;
    private static final int REQUIRED_MOB_COUNT = 3;
    private boolean hasCalledForMobs = false;
    private List<GermMob> selectedMobsForBumping = new ArrayList<GermMob>();
    private static final FleshWorld.FleshStage TRANSFORMATION_STAGE = FleshWorld.FleshStage.AWARENESS_STAGE;
    private long lastReplicationTime = 0L;

    public GermMob(EntityType<? extends Monster> type, Level world) {
        super(type, world);
    }

    public void m_5993_(Entity killedEntity, int score, DamageSource source) {
        super.m_5993_(killedEntity, score, source);
        this.hasMadeKill = true;
        this.killTime = this.m_9236_().m_46467_();
        ++this.killCount;
    }

    public void m_8119_() {
        super.m_8119_();
        int currentPoints = FleshWorld.getPoints();
        if (this.hasMadeKill && !this.hasCalledForMobs && this.m_9236_().m_46467_() > this.killTime + 300L) {
            if (currentPoints >= 3000) {
                this.callNearbyGermMobs();
            } else if (currentPoints >= (Integer)TFTHConfiguration.MIN_POINTS_FOR_REPLICATION.get()) {
                this.replicateGermMob();
                if (this.m_9236_() instanceof ServerLevel) {
                    // empty if block
                }
            }
            this.hasMadeKill = false;
        }
        if (this.isBumping) {
            this.constantlyMoveTowardsEachOther();
            if (this.areAllRequiredMobsClose() && FleshWorld.getCurrentStage().compareTo(TRANSFORMATION_STAGE) >= 0) {
                this.startTransformationTimer();
            } else if (!this.areAllRequiredMobsClose() && this.m_9236_().m_46467_() > this.bumpingStartTime + 200L) {
                this.resetBumpingProcess();
                this.replicateGermMob();
                if (this.m_9236_() instanceof ServerLevel) {
                    OneOfUsMobEffect.playRandomTransformationSound((ServerLevel)this.m_9236_(), (Entity)this);
                }
                this.spawnParticleExplosion();
            }
        }
    }

    private void spawnParticleExplosion() {
        if (!this.m_9236_().f_46443_) {
            ServerLevel serverLevel = (ServerLevel)this.m_9236_();
            SimpleParticleType flesh = (SimpleParticleType)TheFleshThatHatesModParticleTypes.FLESH.get();
            int particleCount = 10;
            for (int i = 0; i < particleCount; ++i) {
                double d0 = this.f_19796_.m_188583_() * 0.3;
                double d1 = this.f_19796_.m_188583_() * 0.3;
                double d2 = this.f_19796_.m_188583_() * 0.3;
                serverLevel.m_8767_((ParticleOptions)flesh, this.m_20185_(), this.m_20227_(0.5), this.m_20189_(), 1, d0, d1, d2, 0.1);
            }
        }
    }

    private void callNearbyGermMobs() {
        List<GermMob> nearbyGermMobs = this.getNearbyGermMobs();
        if (nearbyGermMobs.size() >= 3) {
            this.hasCalledForMobs = true;
            this.selectedMobsForBumping = nearbyGermMobs.stream().sorted(Comparator.comparingDouble(mob -> mob.m_20280_((Entity)this))).limit(3L).collect(Collectors.toList());
            for (GermMob mob2 : this.selectedMobsForBumping) {
                mob2.m_21573_().m_26519_(this.m_20185_(), this.m_20186_(), this.m_20189_(), 1.0);
                mob2.startBumping();
            }
        } else {
            this.replicateGermMob();
            this.spawnParticleExplosion();
        }
    }

    private void constantlyMoveTowardsEachOther() {
        for (GermMob mob : this.selectedMobsForBumping) {
            mob.m_21573_().m_26519_(this.m_20185_(), this.m_20186_(), this.m_20189_(), 1.0);
        }
    }

    public void startBumping() {
        this.isBumping = true;
        this.bumpingStartTime = this.m_9236_().m_46467_();
        this.checkAllBumping();
    }

    private void resetBumpingProcess() {
        this.isBumping = false;
        this.hasCalledForMobs = false;
        this.selectedMobsForBumping.clear();
    }

    private void checkAllBumping() {
        List<GermMob> nearbyGermMobs = this.getNearbyGermMobs();
        if (nearbyGermMobs.size() >= 3) {
            for (GermMob mob : nearbyGermMobs) {
                if (mob.isBumping) continue;
                return;
            }
            List<GermMob> selectedMobs = nearbyGermMobs.subList(0, 3);
            selectedMobs.forEach(GermMob::startTransformationTimer);
        } else {
            this.replicateGermMob();
        }
    }

    private void replicateGermMob() {
        long currentTime = this.m_9236_().m_46467_();
        if (currentTime - this.lastReplicationTime < (long)TimeHelper.convertSecondsToTicks((Integer)TFTHConfiguration.REPLICATION_COOLDOWN_SECONDS.get())) {
            this.killCount = 0;
            return;
        }
        this.lastReplicationTime = currentTime;
        int copiesToCreate = Math.min(this.killCount, (Integer)TFTHConfiguration.GERMOB_REPLICATION_COUNT.get());
        for (int i = 0; i < copiesToCreate; ++i) {
            try {
                Class<?> mobClass = ((Object)((Object)this)).getClass();
                GermMob newGermMob = (GermMob)((Object)mobClass.getConstructor(EntityType.class, Level.class).newInstance(this.m_6095_(), this.m_9236_()));
                newGermMob.m_7678_(this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_146908_(), this.m_146909_());
                this.m_9236_().m_7967_((Entity)newGermMob);
                continue;
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        this.spawnParticleExplosion();
        OneOfUsMobEffect.playRandomTransformationSound((ServerLevel)this.m_9236_(), (Entity)this);
        this.killCount = 0;
    }

    private List<GermMob> getNearbyGermMobs() {
        double searchRadius = 24.0;
        AABB searchArea = new AABB(this.m_20185_() - searchRadius, this.m_20186_() - searchRadius, this.m_20189_() - searchRadius, this.m_20185_() + searchRadius, this.m_20186_() + searchRadius, this.m_20189_() + searchRadius);
        return this.m_9236_().m_45976_(GermMob.class, searchArea);
    }

    private void startTransformationTimer() {
        if (FleshWorld.getCurrentStage().compareTo(TRANSFORMATION_STAGE) >= 0) {
            this.f_21345_.m_25352_(1, (Goal)new PushAgainstEachOtherGoal(this));
        }
    }

    void transformAllNearbyGermMobs() {
        if (this.selectedMobsForBumping.size() >= 3) {
            GermMob transformingMob = this.selectedMobsForBumping.get(0);
            transformingMob.transformIntoAwarenessMob();
            this.selectedMobsForBumping.forEach(mob -> mob.m_142687_(Entity.RemovalReason.DISCARDED));
        }
    }

    private boolean areAllRequiredMobsClose() {
        for (GermMob mob : this.selectedMobsForBumping) {
            if (!(mob.m_20280_((Entity)this) > 4.0)) continue;
            return false;
        }
        return true;
    }

    private void transformIntoAwarenessMob() {
        if (!this.hasTransformed && this.m_9236_() instanceof ServerLevel) {
            LivingEntity newEntity;
            this.hasTransformed = true;
            Random random = new Random();
            EntityType<?> randomType = new ArrayList(AwarenessStageMobs.ENTITY_TYPES).get(random.nextInt(AwarenessStageMobs.ENTITY_TYPES.size()));
            if (randomType != null && (newEntity = (LivingEntity)randomType.m_20615_(this.m_9236_())) != null) {
                newEntity.m_7678_(this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_146908_(), this.m_146909_());
                this.m_9236_().m_7967_((Entity)newEntity);
                this.spawnParticleExplosion();
            }
        }
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
    }

    class PushAgainstEachOtherGoal
    extends Goal {
        private final GermMob germMob;
        private long startTime;

        PushAgainstEachOtherGoal(GermMob germMob) {
            this.germMob = germMob;
        }

        public boolean m_8036_() {
            return true;
        }

        public void m_8056_() {
            super.m_8056_();
            this.startTime = this.germMob.m_9236_().m_46467_();
        }

        public void m_8037_() {
            super.m_8037_();
            if (this.germMob.m_9236_().m_46467_() > this.startTime + 200L) {
                this.germMob.transformAllNearbyGermMobs();
            }
        }
    }
}

