/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.thefleshthathates.entity.test;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.registries.ForgeRegistries;

public class ImageHolderEntity
extends Entity {
    private long lastTextureChangeTime = 0L;
    private long scaleFilledTime = -1L;
    public static final EntityDataAccessor<Integer> TEXTURE_INDEX = SynchedEntityData.m_135353_(ImageHolderEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> SCALE_VALUE = SynchedEntityData.m_135353_(ImageHolderEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final TextureItem[] ITEMS = ImageHolderEntity.createTextureItems("the_flesh_that_hates", "flesh_sword|3", "flesh_axe|2", "flesh_piece_spawn_egg|4", "brain|6");
    private static final TextureItem[] FOOD = ImageHolderEntity.createTextureItems("minecraft", "apple|1", "bread|1", "carrot|1", "cooked_beef|1");
    private static final TextureItem[] OTHER_ITEMS = ImageHolderEntity.createTextureItems("minecraft", "diamond|1", "iron_ingot|1", "gold_ingot|1");
    private static TextureArray currentArrayChoice = TextureArray.ITEMS;

    private static TextureItem[] createTextureItems(String modNamespace, String ... itemsDefinitions) {
        TextureItem[] items = new TextureItem[itemsDefinitions.length];
        for (int i = 0; i < itemsDefinitions.length; ++i) {
            String[] parts = itemsDefinitions[i].split("\\|");
            String path = parts[0];
            int maxScaleValue = Integer.parseInt(parts[1]);
            items[i] = new TextureItem(modNamespace, path, maxScaleValue);
        }
        return items;
    }

    public static void setArrayChoice(TextureArray choice) {
        currentArrayChoice = choice;
    }

    private TextureItem[] getCurrentArray() {
        switch (currentArrayChoice) {
            case FOOD: {
                return FOOD;
            }
            case OTHER_ITEMS: {
                return OTHER_ITEMS;
            }
        }
        return ITEMS;
    }

    public ImageHolderEntity(EntityType<? extends ImageHolderEntity> type, Level world) {
        super(type, world);
        this.f_19794_ = true;
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(TEXTURE_INDEX, (Object)0);
        this.f_19804_.m_135372_(SCALE_VALUE, (Object)0);
    }

    protected void m_7378_(CompoundTag compound) {
        if (compound.m_128441_("TextureIndex")) {
            this.f_19804_.m_135381_(TEXTURE_INDEX, (Object)compound.m_128451_("TextureIndex"));
        }
        if (compound.m_128441_("ScaleValue")) {
            this.f_19804_.m_135381_(SCALE_VALUE, (Object)compound.m_128451_("ScaleValue"));
        }
    }

    protected void m_7380_(CompoundTag compound) {
        compound.m_128405_("TextureIndex", ((Integer)this.f_19804_.m_135370_(TEXTURE_INDEX)).intValue());
        compound.m_128405_("ScaleValue", ((Integer)this.f_19804_.m_135370_(SCALE_VALUE)).intValue());
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void nextTexture() {
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastTextureChangeTime > 200L) {
            int currentIndex = (Integer)this.f_19804_.m_135370_(TEXTURE_INDEX);
            TextureItem[] currentArray = this.getCurrentArray();
            int nextIndex = (currentIndex + 1) % currentArray.length;
            this.f_19804_.m_135381_(TEXTURE_INDEX, (Object)nextIndex);
            this.f_19804_.m_135381_(SCALE_VALUE, (Object)0);
            this.lastTextureChangeTime = currentTime;
        }
    }

    public ResourceLocation getCurrentTexture() {
        TextureItem[] currentArray = switch (currentArrayChoice) {
            case TextureArray.FOOD -> FOOD;
            case TextureArray.OTHER_ITEMS -> OTHER_ITEMS;
            default -> ITEMS;
        };
        return currentArray[((Integer)this.f_19804_.m_135370_(ImageHolderEntity.TEXTURE_INDEX)).intValue()].resourceLocation;
    }

    public int getCurrentTextureNumber() {
        TextureItem[] currentArray = this.getCurrentArray();
        return currentArray[((Integer)this.f_19804_.m_135370_(ImageHolderEntity.TEXTURE_INDEX)).intValue()].maxScaleValue;
    }

    public int getCurrentScaleValue() {
        return (Integer)this.f_19804_.m_135370_(SCALE_VALUE);
    }

    public void incrementScaleValue() {
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastTextureChangeTime > 500L) {
            int currentScale = (Integer)this.f_19804_.m_135370_(SCALE_VALUE);
            TextureItem[] currentArray = this.getCurrentArray();
            int maxScale = currentArray[((Integer)this.f_19804_.m_135370_(ImageHolderEntity.TEXTURE_INDEX)).intValue()].maxScaleValue;
            if (currentScale < maxScale) {
                this.f_19804_.m_135381_(SCALE_VALUE, (Object)(currentScale + 1));
                if (currentScale + 1 == maxScale) {
                    this.scaleFilledTime = System.currentTimeMillis();
                }
            }
        }
    }

    public void decrementScaleValue() {
        int currentScale = (Integer)this.f_19804_.m_135370_(SCALE_VALUE);
        if (currentScale > 0) {
            this.f_19804_.m_135381_(SCALE_VALUE, (Object)(currentScale - 1));
        }
    }

    public List<ResourceLocation> findItemsByTextureName() {
        ArrayList<ResourceLocation> matchingItems = new ArrayList<ResourceLocation>();
        String currentTexturePath = this.getCurrentTexture().m_135815_();
        String textureName = currentTexturePath.substring(currentTexturePath.lastIndexOf(47) + 1).replace(".png", "");
        for (ResourceLocation key : ForgeRegistries.ITEMS.getKeys()) {
            if (!key.m_135815_().contains(textureName)) continue;
            matchingItems.add(key);
        }
        return matchingItems;
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.scaleFilledTime > 0L && System.currentTimeMillis() - this.scaleFilledTime >= 3000L) {
            this.nextTexture();
            this.f_19804_.m_135381_(SCALE_VALUE, (Object)0);
            this.scaleFilledTime = -1L;
        }
    }

    private static class TextureItem {
        final ResourceLocation resourceLocation;
        final int maxScaleValue;

        TextureItem(String namespace, String path, int maxScaleValue) {
            this.resourceLocation = new ResourceLocation(namespace, path);
            this.maxScaleValue = maxScaleValue;
        }
    }

    public static enum TextureArray {
        ITEMS,
        FOOD,
        OTHER_ITEMS;

    }
}

