/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.thefleshthathates.entity.test;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.mcreator.thefleshthathates.entity.test.ImageHolderEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import org.joml.Matrix4f;

public class ImageHolderRenderer
extends EntityRenderer<ImageHolderEntity> {
    public ImageHolderRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    public void render(ImageHolderEntity entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        poseStack.m_85836_();
        this.renderEntityText(entity, poseStack, bufferSource, packedLight);
        Item currentItem = (Item)ForgeRegistries.ITEMS.getValue(entity.getCurrentTexture());
        if (currentItem != null) {
            this.renderItemImage(poseStack, bufferSource, packedLight, currentItem);
        }
        poseStack.m_85849_();
        super.m_7392_((Entity)entity, entityYaw, partialTicks, poseStack, bufferSource, packedLight);
    }

    private void renderEntityText(ImageHolderEntity entity, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        double distance = Minecraft.m_91087_().m_91290_().m_114471_((Entity)entity);
        if (distance <= 4096.0) {
            poseStack.m_85836_();
            poseStack.m_85837_(0.0, 1.5, 0.0);
            poseStack.m_252781_(this.f_114476_.m_253208_());
            poseStack.m_85841_(-0.025f, -0.025f, 0.025f);
            int currentScale = entity.getCurrentScaleValue();
            int maxScale = entity.getCurrentTextureNumber();
            String text = currentScale + "/" + maxScale;
            float textWidth = (float)this.m_114481_().m_92895_(text) / 2.0f;
            poseStack.m_252880_(-textWidth, 0.0f, 0.0f);
            MutableComponent textComponent = Component.m_237113_((String)text);
            float ratio = (float)currentScale / (float)maxScale;
            int color = ratio < 0.33f ? 0xFF0000 : (ratio < 0.7f ? 0xFFFF00 : 65280);
            Font font = this.m_114481_();
            font.m_272077_((Component)textComponent, 0.0f, 0.0f, color, false, poseStack.m_85850_().m_252922_(), bufferSource, Font.DisplayMode.NORMAL, 0, packedLight);
            poseStack.m_85849_();
        }
    }

    public void renderItemImage(PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, Item item) {
        Minecraft minecraft = Minecraft.m_91087_();
        ItemStack itemStack = new ItemStack((ItemLike)item);
        BakedModel itemModel = minecraft.m_91291_().m_174264_(itemStack, null, null, 0);
        float scale = 0.7f;
        poseStack.m_85841_(scale, scale, scale);
        poseStack.m_252781_(this.f_114476_.m_253208_());
        poseStack.m_85836_();
        long time = System.currentTimeMillis();
        float oscillation = Mth.m_14031_((float)((float)(time % 2000L) / 2000.0f * (float)Math.PI * 2.0f)) * 0.05f;
        poseStack.m_85837_(0.0, 1.3 + (double)oscillation, 0.0);
        minecraft.m_91291_().m_115143_(itemStack, ItemDisplayContext.GUI, false, poseStack, bufferSource, packedLight, OverlayTexture.f_118083_, itemModel);
        poseStack.m_85849_();
    }

    private void renderEntityBackground(ImageHolderEntity entity, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        ResourceLocation backgroundTexture = new ResourceLocation("minecraft", "textures/gui/hanging_sings/mangrove.png");
        RenderType renderType = RenderType.m_110458_((ResourceLocation)backgroundTexture);
        VertexConsumer vertexConsumer = bufferSource.m_6299_(renderType);
        poseStack.m_85836_();
        poseStack.m_85837_(-0.5, 1.0, 0.0);
        float scale = 1.0f;
        poseStack.m_85841_(scale, scale, scale);
        float backgroundWidth = 1.0f;
        float backgroundHeight = 1.0f;
        Matrix4f matrix = poseStack.m_85850_().m_252922_();
        vertexConsumer.m_252986_(matrix, 0.0f, backgroundHeight, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(0.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
        vertexConsumer.m_252986_(matrix, backgroundWidth, backgroundHeight, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(1.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
        vertexConsumer.m_252986_(matrix, backgroundWidth, 0.0f, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(1.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
        vertexConsumer.m_252986_(matrix, 0.0f, 0.0f, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(0.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
        poseStack.m_85849_();
    }

    public ResourceLocation getTextureLocation(ImageHolderEntity entity) {
        return entity.getCurrentTexture();
    }
}

