/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.thefleshthathates.helpers;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;

public class BlockHelper {
    public static BlockState getBlockState(LevelAccessor world, BlockPos pos) {
        return world.m_8055_(pos);
    }

    public static void setBlock(LevelAccessor world, BlockPos pos, BlockState state, int flags) {
        world.m_7731_(pos, state, flags);
    }

    public static void destroyBlock(LevelAccessor world, BlockPos pos, boolean dropBlock) {
        world.m_46961_(pos, dropBlock);
    }

    public static boolean isSolid(ServerLevel level, BlockPos pos) {
        return !BlockHelper.isNotSolid(level, pos);
    }

    public static boolean isNotSolid(ServerLevel level, BlockPos pos) {
        BlockState state = level.m_8055_(pos);
        boolean canNotOcclude = !state.m_60815_();
        boolean isNotSolid = !state.m_280296_();
        boolean isAir = state.m_60795_();
        boolean isNotSolidRender = !state.m_60804_((BlockGetter)level, pos);
        return canNotOcclude || isNotSolid || isAir || isNotSolidRender;
    }

    private static boolean isBlockFlat(ServerLevel level, BlockPos pos) {
        if (!BlockHelper.isSolid(level, pos) && BlockHelper.isSolid(level, pos.m_7495_())) {
            return true;
        }
        if (BlockHelper.isSolid(level, pos) && !BlockHelper.isSolid(level, pos.m_7494_())) {
            return true;
        }
        return BlockHelper.isSolid(level, pos) && BlockHelper.isSolid(level, pos.m_7494_()) && !BlockHelper.isSolid(level, pos.m_7494_().m_7494_());
    }

    public static BlockPos getGroundBlockPos(Level level, BlockPos origin, int startHeight) {
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos(origin.m_123341_(), startHeight, origin.m_123343_());
        while (mutable.m_123342_() > level.m_141937_() && level.m_46859_((BlockPos)mutable)) {
            mutable.m_122173_(Direction.DOWN);
        }
        return mutable;
    }

    public BlockPos getSafeMobSpawnPosition(ServerLevel world, BlockPos pos) {
        BlockPos.MutableBlockPos mutablePos = pos.m_122032_();
        for (int x = -3; x <= 3; ++x) {
            for (int z = -3; z <= 3; ++z) {
                for (int y = 1; y <= 3; ++y) {
                    mutablePos.m_122178_(pos.m_123341_() + x, pos.m_123342_() + y, pos.m_123343_() + z);
                    if (!world.m_46859_((BlockPos)mutablePos) || !world.m_46859_(mutablePos.m_7494_()) || !world.m_46859_(mutablePos.m_6630_(2)) || world.m_8055_(mutablePos.m_7495_()).m_60795_() || world.m_6425_(mutablePos.m_7495_()).m_76170_()) continue;
                    return mutablePos.m_7949_();
                }
            }
        }
        return pos;
    }

    public static void drawLine(LevelAccessor world, BlockPos start, BlockPos end, BlockState state, int flags) {
        BlockPos.m_121990_((BlockPos)start, (BlockPos)end).forEach(pos -> BlockHelper.setBlock(world, pos, state, flags));
    }

    public static void drawSquare(LevelAccessor world, BlockPos center, int radius, BlockState state, int flags) {
        BlockPos.m_121990_((BlockPos)center.m_7918_(-radius, 0, -radius), (BlockPos)center.m_7918_(radius, 0, radius)).forEach(pos -> BlockHelper.setBlock(world, pos, state, flags));
    }

    public static void drawCircle(LevelAccessor world, BlockPos center, int radius, BlockState state, int flags) {
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                if (x * x + z * z > radius * radius) continue;
                BlockPos pos = center.m_7918_(x, 0, z);
                BlockHelper.setBlock(world, pos, state, flags);
            }
        }
    }
}

