/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.thefleshthathates.helpers;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.mcreator.thefleshthathates.FConfig.TFTHConfiguration;
import net.mcreator.thefleshthathates.helpers.MobHelper;
import net.mcreator.thefleshthathates.init.TheFleshThatHatesModEntities;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;

public class DespawnHelper {
    public static final Map<EntityType<?>, Integer> germPriorityMap = new HashMap();
    public static final Map<EntityType<?>, Integer> awarenessPriorityMap = new HashMap();

    public static List<EntityPriorityPair> getSortedGermEntitiesByPriority() {
        return germPriorityMap.entrySet().stream().sorted(Map.Entry.comparingByValue()).map(entry -> new EntityPriorityPair((EntityType)entry.getKey(), (Integer)entry.getValue())).collect(Collectors.toList());
    }

    public static int getPriorityWithAggressionCheck(Mob mob) {
        int basePriority = germPriorityMap.getOrDefault(mob.m_6095_(), Integer.MAX_VALUE);
        if (MobHelper.isMobAgro(mob)) {
            return 3;
        }
        return basePriority;
    }

    public static int getPriorityAwarenessWithAggressionCheck(Mob mob) {
        int basePriority = awarenessPriorityMap.getOrDefault(mob.m_6095_(), Integer.MAX_VALUE);
        if (MobHelper.isMobAgro(mob)) {
            return 3;
        }
        return basePriority;
    }

    static {
        germPriorityMap.put((EntityType)TheFleshThatHatesModEntities.PLAQUECONTAMINATOR.get(), (Integer)TFTHConfiguration.FLESH_INFECTOR_PRIORITY.get());
        germPriorityMap.put((EntityType)TheFleshThatHatesModEntities.FLESH_HUMAN.get(), (Integer)TFTHConfiguration.FLESH_HUMAN_PRIORITY.get());
        germPriorityMap.put((EntityType)TheFleshThatHatesModEntities.FLESH_VILLAGER.get(), (Integer)TFTHConfiguration.FLESH_VILLAGER_PRIORITY.get());
        germPriorityMap.put((EntityType)TheFleshThatHatesModEntities.FLESH_SHEEP.get(), (Integer)TFTHConfiguration.FLESH_SHEEP_PRIORITY.get());
        germPriorityMap.put((EntityType)TheFleshThatHatesModEntities.FLESH_COW.get(), (Integer)TFTHConfiguration.FLESH_COW_PRIORITY.get());
        germPriorityMap.put((EntityType)TheFleshThatHatesModEntities.FLESH_PIG.get(), (Integer)TFTHConfiguration.FLESH_PIG_PRIORITY.get());
        germPriorityMap.put((EntityType)TheFleshThatHatesModEntities.FLESH_PILLAGER.get(), (Integer)TFTHConfiguration.FLESH_PILLAGER_PRIORITY.get());
        germPriorityMap.put((EntityType)TheFleshThatHatesModEntities.FLESH_VINDICATOR.get(), (Integer)TFTHConfiguration.FLESH_VINDICATOR_PRIORITY.get());
        germPriorityMap.put((EntityType)TheFleshThatHatesModEntities.PLAQUECREATUREONE.get(), (Integer)TFTHConfiguration.PLAQUECREATUREONE_PRIORITY.get());
        germPriorityMap.put((EntityType)TheFleshThatHatesModEntities.FLESH_DOG.get(), (Integer)TFTHConfiguration.FLESH_DOG_PRIORITY.get());
        germPriorityMap.put((EntityType)TheFleshThatHatesModEntities.BRUTEPLAQUECREATUREONE.get(), (Integer)TFTHConfiguration.BRUTEPLAQUECREATUREONE_PRIORITY.get());
        awarenessPriorityMap.put((EntityType)TheFleshThatHatesModEntities.PLAQUECREATURETWO.get(), (Integer)TFTHConfiguration.PLAQUECREATURETWO_PRIORITY.get());
        awarenessPriorityMap.put((EntityType)TheFleshThatHatesModEntities.FLESH_HUNTER_TWO.get(), (Integer)TFTHConfiguration.FLESH_HUNTER_TWO_PRIORITY.get());
        awarenessPriorityMap.put((EntityType)TheFleshThatHatesModEntities.FLESH_BOOMER.get(), (Integer)TFTHConfiguration.FLESH_BOOMER_PRIORITY.get());
        awarenessPriorityMap.put((EntityType)TheFleshThatHatesModEntities.FLESH_HOWLER.get(), (Integer)TFTHConfiguration.FLESH_HOWLER_PRIORITY.get());
        awarenessPriorityMap.put((EntityType)TheFleshThatHatesModEntities.FLESH_SUFFER.get(), (Integer)TFTHConfiguration.FLESH_SUFFER_PRIORITY.get());
        awarenessPriorityMap.put((EntityType)TheFleshThatHatesModEntities.PLAQUETHREELEGCREATURE.get(), (Integer)TFTHConfiguration.PLAQUETHREELEGCREATURE_PRIORITY.get());
    }

    public static class EntityPriorityPair {
        private final EntityType<?> entityType;
        private final Integer priority;

        public EntityPriorityPair(EntityType<?> entityType, Integer priority) {
            this.entityType = entityType;
            this.priority = priority;
        }

        public EntityType<?> getEntityType() {
            return this.entityType;
        }

        public Integer getPriority() {
            return this.priority;
        }
    }
}

