/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.thefleshthathates.helpers;

import java.util.List;
import java.util.function.Predicate;
import net.mcreator.thefleshthathates.AwarenessStageMobs;
import net.mcreator.thefleshthathates.GermStageMobs;
import net.mcreator.thefleshthathates.entity.FleshMobs;
import net.minecraft.core.BlockPos;
import net.minecraft.server.TickTask;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;

public class MobHelper {
    public static boolean isGermMob(Entity entity) {
        return GermStageMobs.ENTITY_TYPES.contains(entity.m_6095_());
    }

    public static boolean isAwarenessMob(Entity entity) {
        return AwarenessStageMobs.ENTITY_TYPES.contains(entity.m_6095_());
    }

    public static boolean isFleshMob(Entity entity) {
        return FleshMobs.ENTITY_TYPES.contains(entity.m_6095_());
    }

    public static ServerLevel getEntityLevel(Entity entity) {
        Level level = entity.m_9236_();
        if (level instanceof ServerLevel) {
            return (ServerLevel)level;
        }
        return null;
    }

    public static <T extends Entity> List<T> getEntitiesWithinAABB(Level world, Class<T> entityClass, AABB boundingBox, Predicate<? super T> filter) {
        return world.m_6443_(entityClass, boundingBox, filter);
    }

    public static boolean isLivingEntityAndServerLevel(Entity entity) {
        return entity instanceof LivingEntity && entity.m_9236_() instanceof ServerLevel;
    }

    public static boolean isEntityOfType(Entity entity, EntityType<?> entityType) {
        return entity.m_6095_() == entityType;
    }

    public static boolean isMobAgro(Mob mob) {
        return mob.m_5448_() != null && !mob.m_5448_().m_21224_() || mob.m_5912_();
    }

    public static Entity spawnEntity(ServerLevel level, EntityType<?> type, double x, double y, double z) {
        Entity entity = type.m_20615_((Level)level);
        if (entity != null) {
            entity.m_6034_(x, y, z);
            level.m_7967_(entity);
            return entity;
        }
        return null;
    }

    public static Entity spawnEntity(ServerLevel level, EntityType<?> type, BlockPos pos) {
        return MobHelper.spawnEntity(level, type, (double)pos.m_123341_() + 0.5, pos.m_123342_(), (double)pos.m_123343_() + 0.5);
    }

    public static boolean canApplyEffectsToTarget(LivingEntity entity, MobEffect debuff) {
        boolean isEntityNull = entity == null;
        boolean isEntityDead = entity.m_21224_();
        if (isEntityNull || isEntityDead) {
            return false;
        }
        boolean isEntityInvulnerable = entity.m_20147_();
        boolean isEntityAttackable = entity.m_6097_();
        boolean doesEntityHaveDebuffAlready = entity.m_21023_(debuff);
        return !isEntityInvulnerable && isEntityAttackable && !doesEntityHaveDebuffAlready;
    }

    public static void applyEffectToTarget(LivingEntity entity, MobEffect debuff, int duration, int amplifier) {
        if (MobHelper.canApplyEffectsToTarget(entity, debuff)) {
            entity.m_20194_().m_6937_((Runnable)new TickTask(entity.m_20194_().m_129921_() + 1, () -> entity.m_7292_(new MobEffectInstance(debuff, duration, amplifier))));
        }
    }

    public static boolean isLivingEntityInvulnerable(LivingEntity entity) {
        return entity.m_20147_() || !entity.m_6097_();
    }
}

