/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.thefleshthathates.item;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import java.util.List;
import net.mcreator.thefleshthathates.entity.PlaqueincubatoroneEntity;
import net.mcreator.thefleshthathates.entity.PlaqueincubatorstartEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class FleshCompassItem
extends Item {
    private static double lastDistance = -1.0;
    private static boolean shouldRenderText = false;

    public FleshCompassItem() {
        super(new Item.Properties().m_41487_(1).m_41497_(Rarity.COMMON));
    }

    public void m_6883_(ItemStack stack, Level world, Entity entity, int itemSlot, boolean isSelected) {
        if (!world.m_5776_() && entity instanceof Player) {
            Player player = (Player)entity;
            ItemStack mainHandItem = player.m_21205_();
            ItemStack offHandItem = player.m_21206_();
            boolean bl = shouldRenderText = mainHandItem == stack || offHandItem == stack;
            if (!player.m_150109_().m_36063_(stack)) {
                shouldRenderText = false;
            }
            if (shouldRenderText) {
                double closestDistance = this.findClosestIncubatorDistance(world, player);
                if (closestDistance != lastDistance) {
                    lastDistance = closestDistance;
                }
            } else {
                lastDistance = -1.0;
            }
        }
    }

    private double findClosestIncubatorDistance(Level world, Player player) {
        double closestDistance = Double.MAX_VALUE;
        List entities = ((ServerLevel)world).m_6443_(Entity.class, new AABB(player.m_20183_()).m_82400_(500.0), e -> e instanceof PlaqueincubatorstartEntity || e instanceof PlaqueincubatoroneEntity);
        for (Entity e2 : entities) {
            double distance = e2.m_20182_().m_82557_(player.m_20182_());
            if (!(distance < closestDistance)) continue;
            closestDistance = distance;
        }
        return closestDistance != Double.MAX_VALUE ? Math.sqrt(closestDistance) : -1.0;
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void onRenderGui(RenderGuiOverlayEvent.Post event) {
        Minecraft minecraft = Minecraft.m_91087_();
        LocalPlayer player = minecraft.f_91074_;
        boolean isInInventory = false;
        if (player != null) {
            for (ItemStack itemStack : player.m_150109_().f_35974_) {
                if (!(itemStack.m_41720_() instanceof FleshCompassItem)) continue;
                isInInventory = true;
                break;
            }
        }
        boolean bl = shouldRenderText = shouldRenderText && isInInventory;
        if (shouldRenderText) {
            Font font = minecraft.f_91062_;
            String distanceText = lastDistance >= 0.0 ? String.format("Distance to nearest incubator: %.2f", lastDistance) : "Incubator not found";
            MutableComponent textComponent = Component.m_237113_((String)distanceText);
            PoseStack poseStack = new PoseStack();
            poseStack.m_85836_();
            int textWidth = font.m_92852_((FormattedText)textComponent);
            int screenWidth = event.getWindow().m_85445_();
            int xPosition = (screenWidth - textWidth) / 2;
            float scale = 1.2f;
            poseStack.m_85841_(scale, scale, scale);
            int adjustedXPosition = (int)((float)xPosition / scale);
            int yPosition = (int)((float)(event.getWindow().m_85446_() - 70) / scale);
            poseStack.m_252880_((float)adjustedXPosition, (float)yPosition, 0.0f);
            MultiBufferSource.BufferSource bufferSource = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
            font.m_272077_((Component)textComponent, 0.0f, 0.0f, -1, false, poseStack.m_85850_().m_252922_(), (MultiBufferSource)bufferSource, Font.DisplayMode.NORMAL, 0, 0xF000F0);
            bufferSource.m_109911_();
            poseStack.m_85849_();
        }
    }
}

