/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.thefleshthathates.potion;

import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class FleshRageEffect
extends MobEffect {
    private static final UUID DAMAGE_BOOST_ID = UUID.randomUUID();
    private static final UUID SPEED_BOOST_ID = UUID.randomUUID();

    public FleshRageEffect() {
        super(MobEffectCategory.HARMFUL, -22223195);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public void m_6742_(LivingEntity entity, int amplifier) {
    }

    public void m_6385_(LivingEntity entity, AttributeMap attributeMap, int amplifier) {
        if (entity.m_21051_(Attributes.f_22281_) != null) {
            entity.m_21051_(Attributes.f_22281_).m_22118_(new AttributeModifier(DAMAGE_BOOST_ID, "Flesh Rage damage boost", 0.25 * (double)(amplifier + 1), AttributeModifier.Operation.MULTIPLY_TOTAL));
        }
        if (entity.m_21051_(Attributes.f_22279_) != null) {
            entity.m_21051_(Attributes.f_22279_).m_22118_(new AttributeModifier(SPEED_BOOST_ID, "Flesh Rage speed boost", 0.1 * (double)(amplifier + 1), AttributeModifier.Operation.MULTIPLY_TOTAL));
        }
    }

    public void m_6386_(LivingEntity entity, AttributeMap attributeMap, int amplifier) {
        entity.m_21051_(Attributes.f_22281_).m_22120_(DAMAGE_BOOST_ID);
        entity.m_21051_(Attributes.f_22279_).m_22120_(SPEED_BOOST_ID);
    }

    public boolean m_6584_(int duration, int amplifier) {
        return duration % 600 == 0;
    }

    @SubscribeEvent
    public void onLivingTick(LivingEvent.LivingTickEvent event) {
        if (event.getEntity().m_21023_((MobEffect)this)) {
            List toRemove = event.getEntity().m_21220_().stream().filter(effect -> effect.m_19544_().m_19483_() == MobEffectCategory.HARMFUL && effect.m_19544_() != this).collect(Collectors.toList());
            for (MobEffectInstance effect2 : toRemove) {
                event.getEntity().m_21195_(effect2.m_19544_());
            }
        }
    }

    @SubscribeEvent
    public void onLivingHurt(LivingHurtEvent event) {
        LivingEntity livingAttacker;
        if (event.isCanceled()) {
            return;
        }
        if (event.getSource().m_7639_() instanceof LivingEntity && (livingAttacker = (LivingEntity)event.getSource().m_7639_()).m_21023_((MobEffect)this)) {
            float healAmount = (float)((double)event.getAmount() * 0.2);
            livingAttacker.m_5634_(healAmount);
            if (event.getEntity() instanceof LivingEntity) {
                LivingEntity target = event.getEntity();
                double knockbackMultiplier = 0.5;
                target.m_5997_(-Math.sin((double)livingAttacker.m_146908_() * (Math.PI / 180)) * knockbackMultiplier, 0.1, Math.cos((double)livingAttacker.m_146908_() * (Math.PI / 180)) * knockbackMultiplier);
            }
        }
    }
}

