/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.thefleshthathates.procedures;

import java.util.Random;
import net.mcreator.thefleshthathates.init.TheFleshThatHatesModItems;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodData;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class FleshArmorEffectProcedure {
    private static int foodCounter = 0;

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        Player player;
        if (event.phase == TickEvent.Phase.END && (player = event.player) != null && FleshArmorEffectProcedure.isWearingFullFleshArmor((Entity)player)) {
            FleshArmorEffectProcedure.applyRegenerationEffect(player);
            if (++foodCounter >= 300) {
                FleshArmorEffectProcedure.decreaseFoodLevel(player);
                foodCounter = 0;
            }
        }
    }

    private static void applyRegenerationEffect(Player player) {
        if (player.m_36324_().m_38702_() > 0 && !player.m_21023_(MobEffects.f_19605_)) {
            player.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 600, 1, false, false, true));
        }
    }

    private static void decreaseFoodLevel(Player player) {
        FoodData foodData;
        int foodLevel;
        if (player.m_36325_() && (foodLevel = (foodData = player.m_36324_()).m_38702_()) > 0) {
            foodData.m_38705_(foodLevel - 2);
        }
    }

    private static boolean isWearingFullFleshArmor(Entity entity) {
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            return livingEntity.m_6844_(EquipmentSlot.HEAD).m_41720_() == TheFleshThatHatesModItems.FLESH_MASK_HELMET.get() && livingEntity.m_6844_(EquipmentSlot.CHEST).m_41720_() == TheFleshThatHatesModItems.FLESH_CHEST_CHESTPLATE.get() && livingEntity.m_6844_(EquipmentSlot.LEGS).m_41720_() == TheFleshThatHatesModItems.FLESH_PANTS_LEGGINGS.get() && livingEntity.m_6844_(EquipmentSlot.FEET).m_41720_() == TheFleshThatHatesModItems.FLESH_BOOT_BOOTS.get();
        }
        return false;
    }

    @SubscribeEvent
    public static void onLivingHurt(LivingHurtEvent event) {
        Random random;
        LivingEntity entity = event.getEntity();
        if (FleshArmorEffectProcedure.isWearingFullSkeletalArmor((Entity)entity) && (random = new Random()).nextFloat() < 0.15f) {
            event.setCanceled(true);
        }
    }

    private static boolean isWearingFullSkeletalArmor(Entity entity) {
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            return livingEntity.m_6844_(EquipmentSlot.HEAD).m_41720_() == TheFleshThatHatesModItems.SKELETAL_HELMET_HELMET.get() && livingEntity.m_6844_(EquipmentSlot.CHEST).m_41720_() == TheFleshThatHatesModItems.SKELETAL_CHESTPLATE_CHESTPLATE.get() && livingEntity.m_6844_(EquipmentSlot.LEGS).m_41720_() == TheFleshThatHatesModItems.SKELETAL_PANTS_LEGGINGS.get() && livingEntity.m_6844_(EquipmentSlot.FEET).m_41720_() == TheFleshThatHatesModItems.SKELETAL_BOOTS_BOOTS.get();
        }
        return false;
    }
}

